/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import commoble.tubesreloaded.blocks.tube.RemoteConnection;
import commoble.tubesreloaded.blocks.tube.TubeBlock;
import commoble.tubesreloaded.blocks.tube.TubeBlockEntity;
import commoble.tubesreloaded.blocks.tube.TubeBreakPacket;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class TubingPliersItem
extends Item {
    public static final String LAST_TUBE_DATA = "last_tube_data";
    public static final String LAST_TUBE_POS = "last_tube_pos";
    public static final String LAST_TUBE_SIDE = "last_tube_side";

    public TubingPliersItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level world = context.m_43725_();
        BlockEntity blockEntity = world.m_7702_(pos = context.m_8083_());
        if (blockEntity instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
            return this.onUseOnTube(world, pos, tube, context.m_43722_(), context.m_43723_(), context.m_43719_());
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_204336_(TubesReloaded.Tags.Blocks.ROTATABLE_BY_PLIERS)) {
            return this.useOnRotatable(world, pos, state);
        }
        return super.m_6225_(context);
    }

    private InteractionResult onUseOnTube(Level level, BlockPos pos, @Nonnull TubeBlockEntity tube, ItemStack stack, Player player, Direction activatedSide) {
        if (!level.f_46443_) {
            CompoundTag nbt = stack.m_41737_(LAST_TUBE_DATA);
            BlockState state = level.m_8055_(pos);
            if (nbt == null) {
                TubeBlock tubeBlock;
                Block block = state.m_60734_();
                if (block instanceof TubeBlock && !(tubeBlock = (TubeBlock)block).hasConnectionOnSide(state, activatedSide)) {
                    CompoundTag newNBT = new CompoundTag();
                    newNBT.m_128365_(LAST_TUBE_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
                    newNBT.m_128405_(LAST_TUBE_SIDE, activatedSide.ordinal());
                    stack.m_41700_(LAST_TUBE_DATA, (Tag)newNBT);
                }
            } else {
                BlockPos lastPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_(LAST_TUBE_POS));
                Direction lastSide = Direction.m_122376_((int)nbt.m_128451_(LAST_TUBE_SIDE));
                if (lastPos.equals((Object)pos)) {
                    stack.m_41749_(LAST_TUBE_DATA);
                } else if (tube.hasRemoteConnection(lastPos)) {
                    TubeBlockEntity.removeConnection((LevelAccessor)level, pos, lastPos);
                    stack.m_41749_(LAST_TUBE_DATA);
                } else {
                    if (tube.hasRemoteConnection(activatedSide)) {
                        stack.m_41749_(LAST_TUBE_DATA);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                TubesReloaded.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TubeBreakPacket(Vec3.m_82512_((Vec3i)lastPos), Vec3.m_82512_((Vec3i)pos)));
                                serverPlayer.m_6330_(SoundEvents.f_12587_, SoundSource.BLOCKS, 0.5f, 2.0f);
                            }
                        }
                        return InteractionResult.SUCCESS;
                    }
                    Vec3 startVec = RaytraceHelper.getTubeSideCenter(lastPos, lastSide);
                    Vec3 endVec = RaytraceHelper.getTubeSideCenter(pos, activatedSide);
                    Vec3 hit = RaytraceHelper.getTubeRaytraceHit(startVec, endVec, (BlockGetter)level);
                    BlockState lastState = level.m_8055_(lastPos);
                    if (hit != null) {
                        stack.m_41749_(LAST_TUBE_DATA);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                TubesReloaded.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TubeBreakPacket(startVec, endVec));
                                serverLevel.m_8624_(serverPlayer, (ParticleOptions)DustParticleOptions.f_123656_, false, hit.f_82479_, hit.f_82480_, hit.f_82481_, 5, 0.05, 0.05, 0.05, 0.0);
                                serverPlayer.m_6330_(SoundEvents.f_12587_, SoundSource.BLOCKS, 0.5f, 2.0f);
                            }
                        }
                    } else if (activatedSide == lastSide) {
                        stack.m_41749_(LAST_TUBE_DATA);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                TubesReloaded.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TubeBreakPacket(startVec, endVec));
                                serverLevel.m_8624_(serverPlayer, (ParticleOptions)DustParticleOptions.f_123656_, false, endVec.f_82479_, endVec.f_82480_, endVec.f_82481_, 5, 0.05, 0.05, 0.05, 0.0);
                                serverPlayer.m_6330_(SoundEvents.f_12587_, SoundSource.BLOCKS, 0.5f, 2.0f);
                            }
                        }
                    } else {
                        TubeBlock tubeBlock;
                        Block serverPlayer = state.m_60734_();
                        if (serverPlayer instanceof TubeBlock && !(tubeBlock = (TubeBlock)serverPlayer).hasConnectionOnSide(state, activatedSide)) {
                            TubeBlock lastTubeBlock;
                            Block serverLevel;
                            if (pos.m_123314_((Vec3i)lastPos, ((Double)TubesReloaded.get().serverConfig().maxTubeConnectionRange().get()).doubleValue()) && (serverLevel = lastState.m_60734_()) instanceof TubeBlock && !(lastTubeBlock = (TubeBlock)serverLevel).hasConnectionOnSide(lastState, lastSide)) {
                                stack.m_41749_(LAST_TUBE_DATA);
                                BlockEntity blockEntity = level.m_7702_(lastPos);
                                if (blockEntity instanceof TubeBlockEntity) {
                                    TubeBlockEntity lastPost = (TubeBlockEntity)blockEntity;
                                    RemoteConnection originalConnection = lastPost.getRemoteConnection(lastSide);
                                    if (originalConnection != null) {
                                        TubeBlockEntity.removeConnection((LevelAccessor)level, lastPos, originalConnection.toPos);
                                    }
                                    TubeBlockEntity.addConnection((LevelAccessor)level, lastPost, lastSide, tube, activatedSide);
                                }
                                stack.m_41622_(1, (LivingEntity)player, thePlayer -> thePlayer.m_21166_(EquipmentSlot.MAINHAND));
                            } else {
                                stack.m_41700_(LAST_TUBE_DATA, (Tag)NbtUtils.m_129224_((BlockPos)pos));
                            }
                        }
                    }
                }
            }
            level.m_5594_(null, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.1f + level.f_46441_.m_188501_() * 0.1f, 0.7f + level.f_46441_.m_188501_() * 0.1f);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult useOnRotatable(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, SoundEvents.f_11669_, SoundSource.BLOCKS, 0.1f + level.f_46441_.m_188501_() * 0.1f, 0.7f + level.f_46441_.m_188501_() * 0.1f);
        if (!level.f_46443_) {
            for (Property property : new Property[]{BlockStateProperties.f_61372_, BlockStateProperties.f_61374_}) {
                if (!state.m_61138_(property)) continue;
                level.m_7731_(pos, (BlockState)state.m_61122_(property), 3);
                break;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        BlockPos lastTubePos;
        CompoundTag lastTubeData;
        super.m_6883_(stack, level, entity, itemSlot, isSelected);
        if (!level.f_46443_ && (lastTubeData = stack.m_41737_(LAST_TUBE_DATA)) != null && TubingPliersItem.shouldRemoveConnection(lastTubePos = NbtUtils.m_129239_((CompoundTag)lastTubeData.m_128469_(LAST_TUBE_POS)), level, entity)) {
            TubingPliersItem.breakPendingConnection(stack, lastTubePos, entity, level);
        }
    }

    public static boolean shouldRemoveConnection(BlockPos connectionPos, Level level, Entity holder) {
        double maxDistance = (Double)TubesReloaded.get().serverConfig().maxTubeConnectionRange().get();
        if (holder.m_20182_().m_82557_(Vec3.m_82512_((Vec3i)connectionPos)) > maxDistance * maxDistance) {
            return true;
        }
        return !(level.m_7702_(connectionPos) instanceof TubeBlockEntity);
    }

    public static void breakPendingConnection(ItemStack stack, BlockPos connectingPos, Entity holder, Level level) {
        stack.m_41749_(LAST_TUBE_DATA);
        if (holder instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)holder;
            TubesReloaded.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new TubeBreakPacket(Vec3.m_82512_((Vec3i)connectingPos), new Vec3(holder.m_20185_(), holder.m_20188_(), holder.m_20189_())));
        }
    }
}

