/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.client;

import commoble.tubesreloaded.ClientProxy;
import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.filter.FilterBlock;
import commoble.tubesreloaded.blocks.loader.LoaderBlock;
import commoble.tubesreloaded.client.FilterTileEntityRenderer;
import commoble.tubesreloaded.client.OsmosisFilterTileEntityRenderer;
import commoble.tubesreloaded.client.StandardSizeContainerScreenFactory;
import commoble.tubesreloaded.client.TubeBlockEntityRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class ClientEvents {
    public static void subscribeClientEvents(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(ClientEvents::onClientSetup);
        modBus.addListener(ClientEvents::onRegisterRenderers);
        forgeBus.addListener(ClientEvents::onClientTick);
        forgeBus.addListener(ClientEvents::onClientLogIn);
        forgeBus.addListener(ClientEvents::onClientLogOut);
    }

    private static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientEvents::afterClientSetup);
    }

    private static void afterClientSetup() {
        MenuScreens.m_96206_((MenuType)((MenuType)TubesReloaded.get().loaderMenu.get()), StandardSizeContainerScreenFactory.of(new ResourceLocation("tubesreloaded", "textures/gui/loader.png"), ((LoaderBlock)((Object)TubesReloaded.get().loaderBlock.get())).m_7705_()));
        MenuScreens.m_96206_((MenuType)((MenuType)TubesReloaded.get().filterMenu.get()), StandardSizeContainerScreenFactory.of(new ResourceLocation("tubesreloaded", "textures/gui/filter.png"), ((FilterBlock)((Object)TubesReloaded.get().filterBlock.get())).m_7705_()));
    }

    private static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TubesReloaded.get().tubeEntity.get()), TubeBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TubesReloaded.get().redstoneTubeEntity.get()), TubeBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TubesReloaded.get().filterEntity.get()), FilterTileEntityRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TubesReloaded.get().osmosisFilterEntity.get()), OsmosisFilterTileEntityRenderer::new);
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            boolean sprintIsDown = mc.f_91066_.f_92091_.m_90857_();
            boolean sprintWasDown = ClientProxy.getWasSprinting();
            if (sprintWasDown != sprintIsDown) {
                ClientProxy.setIsSprintingAndNotifyServer(sprintIsDown);
            }
        }
    }

    private static void onClientLogIn(ClientPlayerNetworkEvent.LoggingIn event) {
        ClientProxy.reset();
    }

    private static void onClientLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientProxy.reset();
    }
}

