/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.client;

import com.mojang.blaze3d.vertex.PoseStack;
import commoble.tubesreloaded.blocks.tube.ItemInTubeWrapper;
import commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import commoble.tubesreloaded.blocks.tube.RemoteConnection;
import commoble.tubesreloaded.blocks.tube.TubeBlock;
import commoble.tubesreloaded.blocks.tube.TubeBlockEntity;
import commoble.tubesreloaded.blocks.tube.TubingPliersItem;
import commoble.tubesreloaded.client.TubeQuadRenderer;
import commoble.tubesreloaded.util.DirectionTransformer;
import java.util.Map;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class TubeBlockEntityRenderer
implements BlockEntityRenderer<TubeBlockEntity> {
    public TubeBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TubeBlockEntity tube, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!tube.inventory.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.inventory) {
                this.renderWrapper(tube, wrapper, partialTicks, matrix, buffer, combinedLight);
            }
        }
        if (!tube.incomingWrapperBuffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.incomingWrapperBuffer) {
                this.renderWrapper(tube, wrapper, partialTicks, matrix, buffer, combinedLight);
            }
        }
        this.renderLongTubes(tube, partialTicks, matrix, buffer, combinedLight, combinedOverlay);
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.m_41613_() > 48) {
            i = 5;
        } else if (stack.m_41613_() > 32) {
            i = 4;
        } else if (stack.m_41613_() > 16) {
            i = 3;
        } else if (stack.m_41613_() > 1) {
            i = 2;
        }
        return i;
    }

    public void renderWrapper(TubeBlockEntity tube, ItemInTubeWrapper wrapper, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int intA) {
        Vec3 renderOffset;
        Direction nextMove = wrapper.remainingMoves.peek();
        if (nextMove == null) {
            return;
        }
        ItemStack itemstack = wrapper.stack;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        RandomSource random = tube.m_58904_().f_46441_;
        Item item = itemstack.m_41720_();
        int renderSeed = itemstack.m_41619_() ? 187 : Item.m_41393_((Item)item) + itemstack.m_41773_();
        random.m_188584_((long)renderSeed);
        matrix.m_85836_();
        int renderedItemCount = this.getModelCount(itemstack);
        float lerpFactor = ((float)wrapper.ticksElapsed + partialTicks) / (float)wrapper.maximumDurationInTube;
        float remoteScale = 1.0f;
        if (wrapper.freshlyInserted) {
            float xEnd = 0.0f;
            float yEnd = 0.0f;
            float zEnd = 0.0f;
            float xStart = xEnd - (float)nextMove.m_122429_();
            float yStart = yEnd - (float)nextMove.m_122430_();
            float zStart = zEnd - (float)nextMove.m_122431_();
            float xLerp = Mth.m_14179_((float)lerpFactor, (float)xStart, (float)xEnd);
            float yLerp = Mth.m_14179_((float)lerpFactor, (float)yStart, (float)yEnd);
            float zLerp = Mth.m_14179_((float)lerpFactor, (float)zStart, (float)zEnd);
            renderOffset = new Vec3((double)xLerp, (double)yLerp, (double)zLerp);
        } else {
            renderOffset = TubeBlockEntityRenderer.getItemRenderOffset(tube, nextMove, lerpFactor);
            remoteScale = (float)TubeBlockEntityRenderer.getItemRenderScale(tube, nextMove, lerpFactor);
        }
        itemRenderer.f_115093_ -= 50.0f;
        for (int currentModelIndex = 0; currentModelIndex < renderedItemCount; ++currentModelIndex) {
            matrix.m_85836_();
            float xAdjustment = 0.0f;
            float yAdjustment = 0.0f;
            float zAdjustment = 0.0f;
            if (currentModelIndex > 0) {
                xAdjustment = (random.m_188501_() * 2.0f - 1.0f) * 0.01f;
                yAdjustment = (random.m_188501_() * 2.0f - 1.0f) * 0.01f;
                zAdjustment = (random.m_188501_() * 2.0f - 1.0f) * 0.01f;
            }
            float xTranslate = (float)(renderOffset.f_82479_ + (double)xAdjustment + 0.5);
            float yTranslate = (float)(renderOffset.f_82480_ + (double)yAdjustment + 0.4375);
            float zTranslate = (float)(renderOffset.f_82481_ + (double)zAdjustment + 0.5);
            matrix.m_85837_((double)xTranslate, (double)yTranslate, (double)zTranslate);
            float scale = remoteScale * 0.5f;
            matrix.m_85841_(scale, scale, scale);
            itemRenderer.m_174269_(itemstack, ItemTransforms.TransformType.GROUND, intA, OverlayTexture.f_118083_, matrix, buffer, renderSeed);
            matrix.m_85849_();
        }
        itemRenderer.f_115093_ += 50.0f;
        matrix.m_85849_();
    }

    public static Vec3 getItemRenderOffset(TubeBlockEntity tube, Direction travelDirection, float lerpFactor) {
        RemoteConnection connection = tube.getRemoteConnection(travelDirection);
        return connection == null ? TubeBlockEntityRenderer.getAdjacentRenderOffset(travelDirection, lerpFactor) : TubeBlockEntityRenderer.getRemoteItemRenderOffset(connection, travelDirection, tube.m_58899_(), lerpFactor);
    }

    public static double getItemRenderScale(TubeBlockEntity tube, Direction travelDirection, float lerpFactor) {
        RemoteConnection connection = tube.getRemoteConnection(travelDirection);
        return connection == null ? 1.0 : TubeBlockEntityRenderer.getRemoteItemRenderScale(connection, travelDirection, tube.m_58899_(), lerpFactor);
    }

    public static Vec3 getRemoteItemRenderOffset(RemoteConnection connection, Direction travelDirection, BlockPos fromPos, float lerpFactor) {
        Vec3 startVec = Vec3.m_82512_((Vec3i)fromPos);
        BlockPos endPos = connection.toPos;
        Vec3 endVec = Vec3.m_82512_((Vec3i)endPos);
        Direction endSide = connection.toSide;
        Vec3 startSideVec = RaytraceHelper.getTubeSideCenter(fromPos, travelDirection);
        Vec3 endSideVec = RaytraceHelper.getTubeSideCenter(endPos, endSide);
        if (lerpFactor < 0.25f) {
            Vec3 sideOffset = startSideVec.m_82546_(startVec);
            float subLerp = lerpFactor / 0.25f;
            double x = Mth.m_14139_((double)subLerp, (double)0.0, (double)sideOffset.f_82479_);
            double y = Mth.m_14139_((double)subLerp, (double)0.0, (double)sideOffset.f_82480_);
            double z = Mth.m_14139_((double)subLerp, (double)0.0, (double)sideOffset.f_82481_);
            return new Vec3(x, y, z);
        }
        if (lerpFactor < 0.75f) {
            float subLerp = (lerpFactor - 0.25f) / 0.5f;
            double x = Mth.m_14139_((double)subLerp, (double)startSideVec.f_82479_, (double)endSideVec.f_82479_);
            double y = Mth.m_14139_((double)subLerp, (double)startSideVec.f_82480_, (double)endSideVec.f_82480_);
            double z = Mth.m_14139_((double)subLerp, (double)startSideVec.f_82481_, (double)endSideVec.f_82481_);
            return new Vec3(x - startVec.f_82479_, y - startVec.f_82480_, z - startVec.f_82481_);
        }
        float subLerp = (lerpFactor - 0.75f) / 0.25f;
        double x = Mth.m_14139_((double)subLerp, (double)endSideVec.f_82479_, (double)endVec.f_82479_);
        double y = Mth.m_14139_((double)subLerp, (double)endSideVec.f_82480_, (double)endVec.f_82480_);
        double z = Mth.m_14139_((double)subLerp, (double)endSideVec.f_82481_, (double)endVec.f_82481_);
        return new Vec3(x - startVec.f_82479_, y - startVec.f_82480_, z - startVec.f_82481_);
    }

    public static double getRemoteItemRenderScale(RemoteConnection connection, Direction travelDirection, BlockPos fromPos, float lerpFactor) {
        Direction remoteFace = connection.toSide;
        BlockPos remotePos = connection.toPos;
        double smallestScale = Math.min(TubeBlockEntityRenderer.getRemoteItemRenderScale(travelDirection, fromPos, remotePos), TubeBlockEntityRenderer.getRemoteItemRenderScale(remoteFace, remotePos, fromPos));
        if (lerpFactor < 0.25f) {
            double subLerp = (lerpFactor - 0.25f) / 0.25f;
            return Mth.m_14139_((double)subLerp, (double)1.0, (double)smallestScale);
        }
        if (lerpFactor < 0.75f) {
            return smallestScale;
        }
        double subLerp = (lerpFactor - 0.75f) / 0.25f;
        return Mth.m_14139_((double)subLerp, (double)smallestScale, (double)1.0);
    }

    public static double getRemoteItemRenderScale(Direction startSide, BlockPos startPos, BlockPos toPos) {
        BlockPos dist = toPos.m_121996_((Vec3i)startPos);
        Direction.Axis travelAxis = startSide.m_122434_();
        Direction.Axis[] orthagonalAxes = DirectionTransformer.ORTHAGONAL_AXES[travelAxis.ordinal()];
        double parallelDistance = startSide.m_122434_().m_7863_(dist.m_123341_(), dist.m_123342_(), dist.m_123343_());
        double parallelDistanceSquared = parallelDistance * parallelDistance;
        double orthagonalDistanceSquared = 0.0;
        int axisCount = orthagonalAxes.length;
        for (int i = 0; i < axisCount; ++i) {
            int orthagonalDist = orthagonalAxes[i].m_7863_(dist.m_123341_(), dist.m_123342_(), dist.m_123343_());
            orthagonalDistanceSquared += (double)(orthagonalDist * orthagonalDist);
        }
        return Math.exp(-(orthagonalDistanceSquared / parallelDistanceSquared));
    }

    public static Vec3 getAdjacentRenderOffset(Direction travelDirection, float lerpFactor) {
        double xEnd = travelDirection.m_122429_();
        double yEnd = travelDirection.m_122430_();
        double zEnd = travelDirection.m_122431_();
        double xLerp = Mth.m_14139_((double)lerpFactor, (double)0.0, (double)xEnd);
        double yLerp = Mth.m_14139_((double)lerpFactor, (double)0.0, (double)yEnd);
        double zLerp = Mth.m_14139_((double)lerpFactor, (double)0.0, (double)zEnd);
        return new Vec3(xLerp, yLerp, zLerp);
    }

    public void renderLongTubes(TubeBlockEntity tube, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = tube.m_58904_();
        BlockPos startPos = tube.m_58899_();
        Block block = tube.m_58900_().m_60734_();
        if (block instanceof TubeBlock) {
            TubeBlock tubeBlock = (TubeBlock)block;
            for (Map.Entry<Direction, RemoteConnection> entry : tube.getRemoteConnections().entrySet()) {
                RemoteConnection connection = entry.getValue();
                if (!connection.isPrimary) continue;
                BlockPos endPos = connection.toPos;
                Direction startFace = entry.getKey();
                Direction endFace = connection.toSide;
                TubeQuadRenderer.renderQuads(world, partialTicks, startPos, endPos, startFace, endFace, matrix, buffer, tubeBlock);
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                for (InteractionHand hand : InteractionHand.values()) {
                    Vec3[] points;
                    float eyeHeight;
                    double handZ;
                    double handY;
                    double handX;
                    CompoundTag nbt;
                    ItemStack stack = player.m_21120_(hand);
                    if (!(stack.m_41720_() instanceof TubingPliersItem) || (nbt = stack.m_41737_("last_tube_data")) == null) continue;
                    BlockPos posOfLastTubeOfPlayer = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("last_tube_pos"));
                    Direction sideOfLastTubeOfPlayer = Direction.m_122376_((int)nbt.m_128451_("last_tube_side"));
                    if (!posOfLastTubeOfPlayer.equals((Object)tube.m_58899_())) continue;
                    EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
                    int handSideID = -(hand == InteractionHand.MAIN_HAND ? -1 : 1) * (player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1);
                    float swingProgress = player.m_21324_(partialTicks);
                    float swingZ = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
                    float playerAngle = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
                    double playerAngleX = Mth.m_14031_((float)playerAngle);
                    double playerAngleZ = Mth.m_14089_((float)playerAngle);
                    double handOffset = (double)handSideID * 0.35;
                    if (renderManager.f_114360_ == null || renderManager.f_114360_.m_92176_() == CameraType.FIRST_PERSON) {
                        double fov = ((Integer)renderManager.f_114360_.m_231837_().m_231551_()).doubleValue();
                        Vec3 handVector = new Vec3(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                        handVector = handVector.m_82496_(-Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) * ((float)Math.PI / 180));
                        handVector = handVector.m_82524_(-Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_) * ((float)Math.PI / 180));
                        handVector = handVector.m_82524_(swingZ * 0.5f);
                        handVector = handVector.m_82496_(-swingZ * 0.7f);
                        handX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + handVector.f_82479_;
                        handY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + handVector.f_82480_ + 0.0;
                        handZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + handVector.f_82481_;
                        eyeHeight = player.m_20192_();
                    } else {
                        handX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                        handY = -0.2 + player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                        handZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                        eyeHeight = player.m_6047_() ? -0.1875f : 0.0f;
                    }
                    Vec3 renderPlayerVec = new Vec3(handX, handY + (double)eyeHeight, handZ);
                    Vec3 startVec = RaytraceHelper.getTubeSideCenter(posOfLastTubeOfPlayer, sideOfLastTubeOfPlayer);
                    Vec3 endVec = renderPlayerVec;
                    for (Vec3 point : points = RaytraceHelper.getInterpolatedPoints(startVec, endVec)) {
                        world.m_7106_((ParticleOptions)ParticleTypes.f_123773_, point.f_82479_, point.f_82480_, point.f_82481_, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean shouldRenderOffScreen(TubeBlockEntity te) {
        return true;
    }
}

