/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import commoble.tubesreloaded.blocks.tube.TubeBlock;
import commoble.tubesreloaded.util.DirectionTransformer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class TubeQuadRenderer {
    public static final Map<ResourceLocation, Material> MATERIALS = new HashMap<ResourceLocation, Material>();

    public static void renderQuads(Level level, float partialTicks, BlockPos startPos, BlockPos endPos, Direction startFace, Direction endFace, PoseStack matrix, MultiBufferSource buffer, TubeBlock block) {
        TextureAtlasSprite textureatlassprite = MATERIALS.computeIfAbsent(block.textureLocation, tex -> new Material(TextureAtlas.f_118259_, tex)).m_119204_();
        Vec3 startVec = Vec3.m_82528_((Vec3i)startPos);
        Vec3 endVec = Vec3.m_82528_((Vec3i)endPos);
        Vec3[][] vertices = DirectionTransformer.getVertexPairs(startFace, endFace);
        Vec3 offsetToEndPos = endVec.m_82546_(startVec);
        VertexConsumer ivertexbuilder = buffer.m_6299_(Sheets.m_110789_());
        float totalMinU = textureatlassprite.m_118409_();
        float totalMinV = textureatlassprite.m_118411_();
        float totalMaxU = textureatlassprite.m_118410_();
        float totalMaxV = textureatlassprite.m_118412_();
        float texWidth = totalMaxU - totalMinU;
        float texHeight = totalMaxV - totalMinV;
        float tubeStartX = 0.375f * texWidth + totalMinU;
        float tubeStartY = totalMinV;
        float tubeWidth = 0.25f * texWidth;
        float tubeHeight = 0.25f * texHeight;
        float minU = tubeStartX;
        float minV = tubeStartY;
        float maxU = tubeStartX + tubeWidth;
        float maxV = tubeStartY + tubeHeight;
        int startLight = TubeQuadRenderer.getPackedLight(level, startPos);
        int endLight = TubeQuadRenderer.getPackedLight(level, endPos);
        for (int side = 0; side < 4; ++side) {
            matrix.m_85836_();
            int vertIndexA = side;
            int vertIndexB = (side + 1) % 4;
            Vec3 startVertexA = vertices[vertIndexA][0];
            Vec3 startVertexB = vertices[vertIndexB][0];
            Vec3 endVertexB = vertices[vertIndexB][1].m_82549_(offsetToEndPos);
            Vec3 endVertexA = vertices[vertIndexA][1].m_82549_(offsetToEndPos);
            float xA = (float)startVertexA.f_82479_ + 0.5f;
            float xB = (float)startVertexB.f_82479_ + 0.5f;
            float xC = (float)endVertexB.f_82479_ + 0.5f;
            float xD = (float)endVertexA.f_82479_ + 0.5f;
            float yA = (float)startVertexA.f_82480_ + 0.5f;
            float yB = (float)startVertexB.f_82480_ + 0.5f;
            float yC = (float)endVertexB.f_82480_ + 0.5f;
            float yD = (float)endVertexA.f_82480_ + 0.5f;
            float zA = (float)startVertexA.f_82481_ + 0.5f;
            float zB = (float)startVertexB.f_82481_ + 0.5f;
            float zC = (float)endVertexB.f_82481_ + 0.5f;
            float zD = (float)endVertexA.f_82481_ + 0.5f;
            PoseStack.Pose matrixEntry = matrix.m_85850_();
            Vec3 normal = startVertexB.m_82546_(startVertexA).m_82537_(endVertexA.m_82546_(startVertexA)).m_82541_();
            Vec3 reverseNormal = normal.m_82542_(-1.0, -1.0, -1.0);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xA, yA, zA, minU, maxV, startLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xB, yB, zB, maxU, maxV, startLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xC, yC, zC, maxU, minV, endLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xD, yD, zD, minU, minV, endLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xD, yD, zD, minU, minV, endLight, reverseNormal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xC, yC, zC, maxU, minV, endLight, reverseNormal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xB, yB, zB, maxU, maxV, startLight, reverseNormal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xA, yA, zA, minU, maxV, startLight, reverseNormal);
            matrix.m_85849_();
        }
    }

    private static void putVertex(PoseStack.Pose matrixEntryIn, VertexConsumer bufferIn, float x, float y, float z, float texU, float texV, int packedLight, Vec3 normal) {
        bufferIn.m_85982_(matrixEntryIn.m_85861_(), x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(texU, texV).m_7122_(0, 10).m_85969_(packedLight).m_85977_(matrixEntryIn.m_85864_(), (float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_).m_5752_();
    }

    public static int getPackedLight(Level world, BlockPos pos) {
        int blockLight = world.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = world.m_45517_(LightLayer.SKY, pos);
        return LightTexture.m_109885_((int)blockLight, (int)skyLight);
    }
}

