/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.routing;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class Endpoint {
    public final BlockPos pos;
    public final Direction face;

    public Endpoint(BlockPos tePos, Direction blockFace) {
        this.pos = tePos;
        this.face = blockFace;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Endpoint) {
            Endpoint otherEndpoint = (Endpoint)other;
            return this.pos.equals((Object)otherEndpoint.pos) && this.face.equals((Object)otherEndpoint.face);
        }
        return false;
    }

    public boolean canInsertItem(Level world, ItemStack stack) {
        BlockEntity te = world.m_7702_(this.pos);
        if (te == null) {
            return false;
        }
        LazyOptional optionalHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.face);
        return optionalHandler.map(handler -> Endpoint.canInsertItem(handler, stack)).orElse(false);
    }

    public static boolean canInsertItem(IItemHandler handler, ItemStack stack) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, stack) || handler.insertItem(i, stack, true).m_41613_() >= stack.m_41613_()) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode() ^ this.face.hashCode();
    }

    public String toString() {
        return this.pos + ";    " + this.face;
    }

    public int getFirstValidSlot(ItemStack stack, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.isItemValid(i, stack)) continue;
            return i;
        }
        return -1;
    }
}

