/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.routing;

import commoble.tubesreloaded.blocks.tube.TubeBlock;
import commoble.tubesreloaded.blocks.tube.TubeBlockEntity;
import commoble.tubesreloaded.routing.Endpoint;
import commoble.tubesreloaded.routing.PosAndDist;
import commoble.tubesreloaded.routing.Route;
import commoble.tubesreloaded.routing.RoutingNetwork;
import commoble.tubesreloaded.util.PosHelper;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FastestRoutesSolver {
    public static List<Route> generateRoutes(RoutingNetwork network, Level world, BlockPos startPos) {
        Object2IntOpenHashMap tubeDists = new Object2IntOpenHashMap();
        tubeDists.put((Object)startPos, 0);
        Object2IntOpenHashMap endpointDists = new Object2IntOpenHashMap();
        HashSet<BlockPos> visitedTubes = new HashSet<BlockPos>();
        HashSet<Endpoint> visitedEndpoints = new HashSet<Endpoint>();
        HashMap<BlockPos, BlockPos> tubePrevs = new HashMap<BlockPos, BlockPos>();
        HashMap<Endpoint, BlockPos> endpointPrevs = new HashMap<Endpoint, BlockPos>();
        PriorityQueue<PosAndDist> distQueue = new PriorityQueue<PosAndDist>(network.getSize());
        distQueue.add(new PosAndDist(startPos, 0));
        while (!distQueue.isEmpty()) {
            TubeBlockEntity tubeTe;
            PosAndDist node = (PosAndDist)distQueue.poll();
            visitedTubes.add(node.pos);
            BlockState state = world.m_8055_(node.pos);
            BlockEntity blockEntity = world.m_7702_(node.pos);
            TubeBlockEntity tube = blockEntity instanceof TubeBlockEntity ? (tubeTe = (TubeBlockEntity)blockEntity) : null;
            Set<Direction> dirs = tube == null ? TubeBlock.getConnectedDirections(state) : tube.getAllConnectedDirections();
            for (Direction face : dirs) {
                int newDist;
                BlockPos checkPos = tube == null ? node.pos.m_121945_(face) : tube.getConnectedPos(face);
                Endpoint maybeEndpoint = new Endpoint(checkPos, face.m_122424_());
                if (!visitedTubes.contains(checkPos) && network.tubes.contains(checkPos)) {
                    newDist = node.dist + 1;
                    if (!tubeDists.containsKey((Object)checkPos) || newDist < tubeDists.getInt((Object)checkPos)) {
                        tubeDists.put((Object)checkPos, newDist);
                        tubePrevs.put(checkPos, node.pos);
                    }
                    distQueue.add(new PosAndDist(checkPos, tubeDists.getInt((Object)checkPos)));
                    continue;
                }
                if (visitedEndpoints.contains(maybeEndpoint) || !network.endpoints.contains(maybeEndpoint)) continue;
                visitedEndpoints.add(maybeEndpoint);
                newDist = node.dist + 1;
                if (endpointDists.containsKey((Object)maybeEndpoint) && newDist >= endpointDists.getInt((Object)maybeEndpoint)) continue;
                endpointDists.put((Object)maybeEndpoint, newDist);
                endpointPrevs.put(maybeEndpoint, node.pos);
            }
        }
        ArrayList<Route> routes = new ArrayList<Route>(network.endpoints.size());
        for (Endpoint endpoint : network.endpoints) {
            LinkedList<Direction> sequenceOfMoves = FastestRoutesSolver.getSequenceOfMoves(world, endpoint, startPos, new LinkedList<Direction>(), tubePrevs, endpointPrevs);
            if (sequenceOfMoves == null) continue;
            routes.add(new Route(endpoint, sequenceOfMoves.size(), sequenceOfMoves));
        }
        routes.sort(null);
        return routes;
    }

    private static LinkedList<Direction> getSequenceOfMoves(Level world, Endpoint endpoint, BlockPos startPos, LinkedList<Direction> returnList, HashMap<BlockPos, BlockPos> tubePrevs, HashMap<Endpoint, BlockPos> endpointPrevs) {
        if (!endpointPrevs.containsKey(endpoint)) {
            return null;
        }
        BlockPos prevPos = endpointPrevs.get(endpoint);
        returnList.addFirst(endpoint.face.m_122424_());
        if (prevPos.equals((Object)startPos)) {
            return returnList;
        }
        return FastestRoutesSolver.getSequenceOfMoves(world, prevPos, startPos, returnList, tubePrevs);
    }

    private static LinkedList<Direction> getSequenceOfMoves(Level world, BlockPos pos, BlockPos startPos, LinkedList<Direction> returnList, HashMap<BlockPos, BlockPos> prevs) {
        if (!prevs.containsKey(pos)) {
            return null;
        }
        BlockPos prevPos = prevs.get(pos);
        returnList.addFirst(PosHelper.getTravelDirectionFromTo(world, prevPos, pos));
        if (prevPos.equals((Object)startPos)) {
            return returnList;
        }
        return FastestRoutesSolver.getSequenceOfMoves(world, prevPos, startPos, returnList, prevs);
    }
}

