/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.routing;

import commoble.tubesreloaded.routing.Endpoint;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Route
implements Comparable<Route> {
    public Queue<Direction> sequenceOfMoves;
    public Endpoint destination;
    public int length;

    public Route(Endpoint destination, int length, Queue<Direction> sequenceOfMoves) {
        this.destination = destination;
        this.length = length;
        this.sequenceOfMoves = sequenceOfMoves;
    }

    public boolean isRouteDestinationValid(Level world, BlockPos startPos, Direction insertionSide, ItemStack stack) {
        if (this.destination.pos.equals((Object)startPos.m_121945_(insertionSide)) && this.destination.face.m_122424_().equals((Object)insertionSide)) {
            return false;
        }
        return this.destination.canInsertItem(world, stack);
    }

    @Override
    public int compareTo(Route other) {
        if (this.length != other.length) {
            return this.length - other.length;
        }
        BlockPos thisEnd = this.destination.pos;
        BlockPos otherEnd = other.destination.pos;
        if (thisEnd.m_123342_() != otherEnd.m_123342_()) {
            return thisEnd.m_123342_() - otherEnd.m_123342_();
        }
        if (thisEnd.m_123343_() != otherEnd.m_123343_()) {
            return thisEnd.m_123343_() - otherEnd.m_123343_();
        }
        return thisEnd.m_123341_() - otherEnd.m_123341_();
    }

    public String toStringFrom(BlockPos startPos) {
        LinkedList<String> moveStrings = new LinkedList<String>();
        moveStrings.add(startPos.toString());
        for (Direction face : this.sequenceOfMoves) {
            if (face == null) {
                moveStrings.add("null");
                continue;
            }
            moveStrings.add(face.toString());
        }
        return String.join((CharSequence)", ", moveStrings);
    }
}

