/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.shadow.commoble.databuddy.datagen;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.data.event.GatherDataEvent;

public record BlockStateFile(Optional<Variants> variants, Optional<Multipart> multipart) {
    public static final Codec<BlockStateFile> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Variants.CODEC.optionalFieldOf("variants").forGetter(BlockStateFile::variants), (App)Multipart.CODEC.optionalFieldOf("multipart").forGetter(BlockStateFile::multipart)).apply((Applicative)builder, BlockStateFile::new));

    public static void addDataProvider(GatherDataEvent event, String modid, DynamicOps<JsonElement> dynamicOps, Map<ResourceLocation, BlockStateFile> entries) {
        DataGenerator dataGenerator = event.getGenerator();
        dataGenerator.m_236039_(event.includeClient(), (DataProvider)new JsonCodecProvider(dataGenerator, event.getExistingFileHelper(), modid, dynamicOps, PackType.CLIENT_RESOURCES, "blockstates", CODEC, entries));
    }

    public static BlockStateFile variants(Variants variants) {
        return new BlockStateFile(Optional.of(variants), Optional.empty());
    }

    public static BlockStateFile multipart(Multipart multipart) {
        return new BlockStateFile(Optional.empty(), Optional.of(multipart));
    }

    public static BlockStateFile variantsAndMultipart(Variants variants, Multipart multipart) {
        return new BlockStateFile(Optional.of(variants), Optional.of(multipart));
    }

    public record Variants(Map<List<PropertyValue<?>>, List<Model>> variants) {
        public static final Codec<Variants> CODEC = Codec.unboundedMap(PropertyValue.LIST_CODEC, (Codec)new ExtraCodecs.EitherCodec(Model.CODEC, Model.CODEC.listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((Model)list.get(0))) : Either.right((Object)list))).xmap(Variants::new, Variants::variants);

        public static Variants builder() {
            return new Variants(new HashMap());
        }

        public static Variants always(Model ... models) {
            return Variants.builder().addVariant(List.of(), models);
        }

        public Variants addVariant(PropertyValue<?> value, Model ... models) {
            this.addVariant(List.of(value), models);
            return this;
        }

        public Variants addVariant(List<PropertyValue<?>> values, Model ... models) {
            this.variants.put(values, Arrays.asList(models));
            return this;
        }
    }

    public record Multipart(List<WhenApply> cases) {
        public static final Codec<Multipart> CODEC = WhenApply.CODEC.listOf().xmap(Multipart::new, Multipart::cases);

        public static Multipart builder() {
            return new Multipart(new ArrayList<WhenApply>());
        }

        public Multipart addWhenApply(WhenApply whenApply) {
            this.cases.add(whenApply);
            return this;
        }
    }

    public record Model(ResourceLocation model, int x, int y, boolean uvLock, int weight) {
        public static final Codec<Model> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)ResourceLocation.f_135803_.fieldOf("model").forGetter(Model::model), (App)Codec.INT.optionalFieldOf("x", (Object)0).forGetter(Model::x), (App)Codec.INT.optionalFieldOf("y", (Object)0).forGetter(Model::y), (App)Codec.BOOL.optionalFieldOf("uvlock", (Object)false).forGetter(Model::uvLock), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(Model::weight)).apply((Applicative)instance, Model::new));

        public Model {
            if (BlockModelRotation.m_119153_((int)x, (int)y) == null) {
                throw new IllegalArgumentException(String.format("Invalid blockstate model part rotation: x=%s, y=%s (must be 0, 90, 180, or 270)", x, y));
            }
            if (weight < 1) {
                throw new IllegalArgumentException(String.format("Invalid blockstate model part weight %s: weight must be positive", weight));
            }
        }

        public static Model create(ResourceLocation model) {
            return Model.create(model, BlockModelRotation.X0_Y0);
        }

        public static Model create(ResourceLocation model, BlockModelRotation rotation) {
            return Model.create(model, rotation, false);
        }

        public static Model create(ResourceLocation model, BlockModelRotation rotation, boolean uvLock) {
            return Model.create(model, rotation, uvLock, 1);
        }

        public static Model create(ResourceLocation model, BlockModelRotation rotation, boolean uvLock, int weight) {
            int ordinal = rotation.ordinal();
            int x = ordinal / 4 * 90;
            int y = ordinal % 4 * 90;
            return new Model(model, x, y, uvLock, weight);
        }
    }

    public record OrCase(List<Either<OrCase, Case>> cases) {
        public static final Codec<OrCase> CODEC = Codec.either((Codec)ExtraCodecs.m_184415_(() -> CODEC), Case.CODEC).listOf().fieldOf("OR").codec().xmap(OrCase::new, OrCase::cases);

        public static OrCase builder() {
            return new OrCase(new ArrayList<Either<OrCase, Case>>());
        }

        public OrCase addCase(Case theCase) {
            this.cases.add((Either<OrCase, Case>)Either.right((Object)theCase));
            return this;
        }

        public OrCase addOrCase(OrCase orCase) {
            this.cases.add((Either<OrCase, Case>)Either.left((Object)orCase));
            return this;
        }
    }

    public record Case(Map<String, String> conditions) {
        public static final Codec<Case> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(Case::new, Case::conditions);

        @SafeVarargs
        public static <T extends Comparable<T>> Case create(Property<T> property, T value, T ... additionalValues) {
            return Case.builder().addCondition((Property)property, value, (Comparable[])additionalValues);
        }

        public static Case builder() {
            return new Case(new HashMap<String, String>());
        }

        @SafeVarargs
        public final <T extends Comparable<T>> Case addCondition(Property<T> property, T value, T ... additionalValues) {
            StringBuilder combinedValues = new StringBuilder(property.m_6940_(value));
            for (T v : additionalValues) {
                combinedValues.append("|" + property.m_6940_(v));
            }
            this.conditions.put(property.m_61708_(), combinedValues.toString());
            return this;
        }
    }

    public record WhenApply(Optional<Either<OrCase, Case>> when, List<Model> apply) {
        public static final Codec<WhenApply> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.either(OrCase.CODEC, Case.CODEC).optionalFieldOf("when").forGetter(WhenApply::when), (App)Codec.either((Codec)Model.CODEC.listOf(), Model.CODEC).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((Model)list.get(0))) : Either.left((Object)list)).fieldOf("apply").forGetter(WhenApply::apply)).apply((Applicative)builder, WhenApply::new));

        public static WhenApply when(Case when, Model apply, Model ... additionalRandomModels) {
            return new WhenApply(Optional.of(Either.right((Object)when)), Lists.asList((Object)apply, (Object[])additionalRandomModels));
        }

        public static WhenApply or(OrCase when, Model apply, Model ... additionalRandomModels) {
            return new WhenApply(Optional.of(Either.left((Object)when)), Lists.asList((Object)apply, (Object[])additionalRandomModels));
        }

        public static WhenApply always(Model apply, Model ... additionalRandomModels) {
            return new WhenApply(Optional.empty(), Lists.asList((Object)apply, (Object[])additionalRandomModels));
        }
    }

    public record PropertyValue<T extends Comparable<T>>(Property<T> property, T value) {
        public static final Codec<PropertyValue<?>> CODEC = Codec.STRING.comapFlatMap(s -> DataResult.error((String)"PropertyValue not deserializable"), PropertyValue::toString);
        public static final Codec<List<PropertyValue<?>>> LIST_CODEC = Codec.STRING.comapFlatMap(s -> DataResult.error((String)"PropertyValue List not deserializable"), values -> String.join((CharSequence)",", (CharSequence[])values.stream().map(PropertyValue::toString).toArray(String[]::new)));

        public static <T extends Comparable<T>> PropertyValue<T> create(Property<T> property, T value) {
            return new PropertyValue<T>(property, value);
        }

        @Override
        public String toString() {
            return this.property.m_61708_() + "=" + this.property.m_6940_(this.value);
        }
    }
}

