/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.shadow.commoble.databuddy.datagen;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.data.event.GatherDataEvent;

public record SimpleModel(ResourceLocation parent, Map<String, ResourceLocation> textures, Optional<ResourceLocation> renderType) {
    public static final Codec<SimpleModel> CODEC = RecordCodecBuilder.create((T builder) -> builder.group((App)ResourceLocation.f_135803_.fieldOf("parent").forGetter(SimpleModel::parent), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)ResourceLocation.f_135803_).optionalFieldOf("textures", Map.of()).forGetter(SimpleModel::textures), (App)ResourceLocation.f_135803_.optionalFieldOf("render_type").forGetter(SimpleModel::renderType)).apply((Applicative)builder, SimpleModel::new));

    @Deprecated(forRemoval=true, since="3.0.0.1")
    public SimpleModel(ResourceLocation parent, Map<String, ResourceLocation> textures) {
        this(parent, textures, Optional.empty());
    }

    public static void addDataProvider(GatherDataEvent event, String modid, DynamicOps<JsonElement> dynamicOps, Map<ResourceLocation, SimpleModel> entries) {
        DataGenerator dataGenerator = event.getGenerator();
        dataGenerator.m_236039_(event.includeClient(), (DataProvider)new JsonCodecProvider(dataGenerator, event.getExistingFileHelper(), modid, dynamicOps, PackType.CLIENT_RESOURCES, "models", CODEC, entries));
    }

    public static SimpleModel createWithoutRenderType(ResourceLocation parent) {
        return new SimpleModel(parent, new HashMap<String, ResourceLocation>(), Optional.empty());
    }

    public static SimpleModel create(ResourceLocation parent) {
        return SimpleModel.create(parent, RenderTypes.SOLID);
    }

    public static SimpleModel create(ResourceLocation parent, ResourceLocation renderType) {
        return new SimpleModel(parent, new HashMap<String, ResourceLocation>(), Optional.of(renderType));
    }

    public SimpleModel addTexture(String textureName, ResourceLocation textureId) {
        this.textures.put(textureName, textureId);
        return this;
    }

    public static class RenderTypes {
        public static final ResourceLocation SOLID = new ResourceLocation("solid");
        public static final ResourceLocation CUTOUT = new ResourceLocation("cutout");
        public static final ResourceLocation CUTOUT_MIPPED = new ResourceLocation("cutout_mipped");
        public static final ResourceLocation TRANSLUCENT = new ResourceLocation("translucent");
        public static final ResourceLocation TRIPWIRE = new ResourceLocation("tripwire");
    }
}

