/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public class DirectionTransformer {
    public static final Map<Direction, Direction[]> ORTHAGONALS = Maps.toMap((Iterable)Lists.newArrayList((Object[])Direction.values()), dir -> EnumSet.complementOf(EnumSet.of(dir, dir.m_122424_())).toArray(new Direction[4]));
    public static final Direction D = Direction.DOWN;
    public static final Direction U = Direction.UP;
    public static final Direction N = Direction.NORTH;
    public static final Direction S = Direction.SOUTH;
    public static final Direction W = Direction.WEST;
    public static final Direction E = Direction.EAST;
    public static final Direction[] SAMES = new Direction[]{D, U, N, S, W, E};
    public static final Direction[] OPPOSITES = new Direction[]{U, D, S, N, E, W};
    public static final Direction[] ROTATE_X_DNUS = new Direction[]{N, S, U, D, W, E};
    public static final Direction[] ROTATE_X_DSUN = new Direction[]{S, N, D, U, W, E};
    public static final Direction[] ROTATE_Y_NESW = new Direction[]{D, U, E, W, N, S};
    public static final Direction[] ROTATE_Y_NWSE = new Direction[]{D, U, W, E, S, N};
    public static final Direction[] ROTATE_Z_DWUE = new Direction[]{W, E, N, S, U, D};
    public static final Direction[] ROTATE_Z_DEUW = new Direction[]{E, W, N, S, D, U};
    public static final Direction.Axis[][] ORTHAGONAL_AXES = new Direction.Axis[][]{{Direction.Axis.Y, Direction.Axis.X}, {Direction.Axis.X, Direction.Axis.Z}, {Direction.Axis.Y, Direction.Axis.Z}};
    public static final Direction[][] ORTHAGONAL_ROTATION_TABLE = new Direction[][]{{N, E, S, W}, {S, E, N, W}, {U, E, D, W}, {D, E, U, W}, {D, S, U, N}, {U, S, D, N}};
    public static final Direction[][][] ROTATION_TABLE = new Direction[][][]{{SAMES, OPPOSITES, ROTATE_X_DNUS, ROTATE_X_DSUN, ROTATE_Z_DWUE, ROTATE_Z_DEUW}, {OPPOSITES, SAMES, ROTATE_X_DSUN, ROTATE_X_DNUS, ROTATE_Z_DEUW, ROTATE_Z_DWUE}, {ROTATE_X_DSUN, ROTATE_X_DNUS, SAMES, OPPOSITES, ROTATE_Y_NWSE, ROTATE_Y_NESW}, {ROTATE_X_DNUS, ROTATE_X_DSUN, OPPOSITES, SAMES, ROTATE_Y_NESW, ROTATE_Y_NWSE}, {ROTATE_Z_DEUW, ROTATE_Z_DWUE, ROTATE_Y_NESW, ROTATE_Y_NWSE, SAMES, OPPOSITES}, {ROTATE_Z_DWUE, ROTATE_Z_DEUW, ROTATE_Y_NWSE, ROTATE_Y_NESW, OPPOSITES, SAMES}};

    public static Direction getRotatedDirection(Direction from, Direction to, Direction toRotate) {
        return ROTATION_TABLE[from.ordinal()][to.ordinal()][toRotate.ordinal()];
    }

    public static Vec3[][] getVertexPairs(Direction startSide, Direction endSide) {
        Vec3i startSideVec = startSide.m_122436_();
        Vec3i endSideVec = endSide.m_122436_();
        Direction[] startEdgeDirections = ORTHAGONAL_ROTATION_TABLE[startSide.ordinal()];
        double tubeSideOffset = 0.25;
        double tubeEdgeOffset = 0.125;
        double tubeCornerOffset = 0.125;
        Vec3[][] result = new Vec3[4][2];
        for (int i = 0; i < 4; ++i) {
            Direction firstOrthagonal = startEdgeDirections[i];
            Vec3i firstOrthagonalSideVec = firstOrthagonal.m_122436_();
            Direction secondOrthagonal = startEdgeDirections[(i + 1) % 4];
            Vec3i secondOrthagonalSideVec = secondOrthagonal.m_122436_();
            result[i][0] = DirectionTransformer.getVertexOffset(startSideVec, firstOrthagonalSideVec, secondOrthagonalSideVec, tubeSideOffset, tubeEdgeOffset, tubeCornerOffset);
            if (endSide == startSide.m_122424_()) {
                result[i][1] = DirectionTransformer.getVertexOffset(endSideVec, firstOrthagonalSideVec, secondOrthagonalSideVec, tubeSideOffset, tubeEdgeOffset, tubeCornerOffset);
                continue;
            }
            Direction firstEndOrthagonal = DirectionTransformer.getRotatedDirection(endSide, startSide, firstOrthagonal);
            Direction secondEndOrthagonal = DirectionTransformer.getRotatedDirection(endSide, startSide, secondOrthagonal);
            Vec3i firstEndSideVec = firstEndOrthagonal.m_122436_();
            Vec3i secondEndSideVec = secondEndOrthagonal.m_122436_();
            result[i][1] = DirectionTransformer.getVertexOffset(endSideVec, firstEndSideVec, secondEndSideVec, tubeSideOffset, tubeEdgeOffset, tubeCornerOffset);
        }
        return result;
    }

    public static Vec3 getVertexOffset(Vec3i sideVec, Vec3i orthagonalA, Vec3i orthagonalB, double side, double edge, double corner) {
        return new Vec3((double)sideVec.m_123341_() * side + (double)orthagonalA.m_123341_() * edge + (double)orthagonalB.m_123341_() * corner, (double)sideVec.m_123342_() * side + (double)orthagonalA.m_123342_() * edge + (double)orthagonalB.m_123342_() * corner, (double)sideVec.m_123343_() * side + (double)orthagonalA.m_123343_() * edge + (double)orthagonalB.m_123343_() * corner);
    }
}

