/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.util;

import com.mojang.math.OctahedralGroup;
import commoble.tubesreloaded.blocks.tube.TubeBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PosHelper {
    @Nullable
    public static Direction getTravelDirectionFromTo(Level world, BlockPos startPos, BlockPos nextPos) {
        TubeBlockEntity startTube;
        Direction dir;
        BlockEntity blockEntity = world.m_7702_(startPos);
        if (blockEntity instanceof TubeBlockEntity && (dir = (startTube = (TubeBlockEntity)blockEntity).getDirectionOfRemoteConnection(nextPos)) != null) {
            return dir;
        }
        return PosHelper.getTravelDirectionBetweenAdjacentPositions(startPos, nextPos);
    }

    @Nullable
    public static Direction getTravelDirectionBetweenAdjacentPositions(BlockPos startPos, BlockPos nextPos) {
        for (Direction face : Direction.values()) {
            if (!startPos.m_121945_(face).equals((Object)nextPos)) continue;
            return face;
        }
        return null;
    }

    public static BlockPos transform(BlockPos pos, OctahedralGroup group) {
        if (group == OctahedralGroup.IDENTITY) {
            return pos;
        }
        BlockPos newPos = new BlockPos(0, 0, 0);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (x != 0) {
            Direction oldDirX = x > 0 ? Direction.EAST : Direction.WEST;
            Direction newDirX = group.m_56528_(oldDirX);
            newPos = newPos.m_5484_(newDirX, Math.abs(x));
        }
        if (y != 0) {
            Direction oldDirY = y > 0 ? Direction.UP : Direction.DOWN;
            Direction newDirY = group.m_56528_(oldDirY);
            newPos = newPos.m_5484_(newDirY, Math.abs(y));
        }
        if (z != 0) {
            Direction oldDirZ = z > 0 ? Direction.SOUTH : Direction.NORTH;
            Direction newDirZ = group.m_56528_(oldDirZ);
            newPos = newPos.m_5484_(newDirZ, Math.abs(z));
        }
        return newPos;
    }
}

