/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.util;

import commoble.tubesreloaded.ClientProxy;
import commoble.tubesreloaded.PlayerData;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WorldHelper {
    public static LazyOptional<IItemHandler> getItemHandlerAt(Level world, BlockPos pos, Direction faceOfBlockPos) {
        BlockEntity te = world.m_7702_(pos);
        return te != null ? te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, faceOfBlockPos) : LazyOptional.empty();
    }

    public static void ejectItemstack(Level world, BlockPos from_pos, @Nullable Direction output_dir, ItemStack stack) {
        double zVel;
        double yVel;
        double xVel;
        double z;
        double y;
        double x;
        double zOff;
        double yOff;
        double xOff;
        BlockPos outputPos;
        if (output_dir != null) {
            outputPos = from_pos.m_121945_(output_dir);
            xOff = output_dir.m_122429_();
            yOff = output_dir.m_122430_();
            zOff = output_dir.m_122431_();
        } else {
            outputPos = from_pos;
            xOff = 0.0;
            yOff = 0.0;
            zOff = 0.0;
        }
        if (!world.m_8055_(outputPos).m_60838_((BlockGetter)world, outputPos)) {
            x = (double)from_pos.m_123341_() + 0.5 + xOff * 0.75;
            y = (double)from_pos.m_123342_() + 0.25 + yOff * 0.75;
            z = (double)from_pos.m_123343_() + 0.5 + zOff * 0.75;
            xVel = xOff * 0.1;
            yVel = yOff * 0.1;
            zVel = zOff * 0.1;
        } else {
            x = (double)from_pos.m_123341_() + 0.5;
            y = (double)from_pos.m_123342_() + 0.5;
            z = (double)from_pos.m_123343_() + 0.5;
            xVel = 0.0;
            yVel = 0.0;
            zVel = 0.0;
        }
        ItemEntity itementity = new ItemEntity(world, x, y, z, stack);
        itementity.m_32060_();
        itementity.m_20334_(xVel, yVel, zVel);
        world.m_7967_((Entity)itementity);
    }

    public static ItemStack disperseItemToHandler(ItemStack stack, IItemHandler handler) {
        return WorldHelper.disperseItemToHandler(stack, handler, false);
    }

    public static ItemStack disperseItemToHandler(ItemStack stack, IItemHandler handler, boolean simulate) {
        int slotCount = handler.getSlots();
        for (int i = 0; i < slotCount; ++i) {
            if (handler.isItemValid(i, stack)) {
                stack = handler.insertItem(i, stack, simulate);
            }
            if (stack.m_41613_() != 0) continue;
            return stack.m_41777_();
        }
        return stack.m_41777_();
    }

    public static boolean doesItemHandlerHaveAnyExtractableItems(IItemHandler handler, Predicate<ItemStack> doesCallerWantItem) {
        return IntStream.range(0, handler.getSlots()).mapToObj(i -> handler.extractItem(i, 1, true)).anyMatch(stack -> stack.m_41613_() > 0 && doesCallerWantItem.test((ItemStack)stack));
    }

    public static Direction getBlockFacingForPlacement(BlockPlaceContext context) {
        boolean isSprintKeyHeld = context.m_43725_().m_5776_() ? ClientProxy.getWasSprinting() : PlayerData.getSprinting(context.m_43723_().m_20148_());
        Direction placeDir = isSprintKeyHeld ? context.m_43719_().m_122424_() : context.m_7820_();
        placeDir = context.m_7078_() ? placeDir : placeDir.m_122424_();
        return placeDir;
    }
}

