/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.client;

import com.github.commoble.tubesreloaded.client.FilterTileEntityRenderer;
import com.github.commoble.tubesreloaded.common.ConfigValues;
import com.github.commoble.tubesreloaded.common.blocks.filter.FilterTileEntity;
import com.github.commoble.tubesreloaded.common.blocks.filter.OsmosisFilterBlock;
import com.github.commoble.tubesreloaded.common.blocks.filter.OsmosisSlimeBlock;
import com.github.commoble.tubesreloaded.common.registry.BlockRegistrar;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;

public class OsmosisFilterTileEntityRenderer
extends FilterTileEntityRenderer {
    BlockRendererDispatcher blockRenderer = null;

    @Override
    public void render(FilterTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        super.render(te, x, y, z, partialTicks, destroyStage);
        this.renderSlime(te, x, y, z, partialTicks);
    }

    private void renderSlime(FilterTileEntity te, double x, double y, double z, float partialTicks) {
        BlockPos blockpos = te.func_174877_v();
        BlockState filterState = te.func_195044_w();
        Direction dir = (Direction)filterState.func_177229_b((IProperty)OsmosisFilterBlock.FACING);
        BlockState renderState = (BlockState)BlockRegistrar.OSMOSIS_SLIME.func_176223_P().func_206870_a((IProperty)OsmosisSlimeBlock.field_176387_N, (Comparable)dir);
        long transferhash = blockpos.hashCode();
        int rate = ConfigValues.osmosis_filter_transfer_rate;
        double ticks = (float)(te.func_145831_w().func_82737_E() + transferhash) + partialTicks;
        double minScale = 0.25;
        double lengthScale = minScale + ((Boolean)te.func_195044_w().func_177229_b((IProperty)OsmosisFilterBlock.TRANSFERRING_ITEMS) != false ? (-Math.cos(Math.PI * 2 * ticks / (double)rate) + 1.0) * 0.25 : 0.0);
        double lengthTranslateFactor = 1.0 - lengthScale;
        double zFightFix = 0.9999;
        int dirOffsetX = dir.func_82601_c();
        int dirOffsetY = dir.func_96559_d();
        int dirOffsetZ = dir.func_82599_e();
        double scaleX = dirOffsetX == 0 ? zFightFix : lengthScale;
        double scaleY = dirOffsetY == 0 ? zFightFix : lengthScale;
        double scaleZ = dirOffsetZ == 0 ? zFightFix : lengthScale;
        boolean translateFactorX = dirOffsetX != 0;
        boolean translateFactorY = dirOffsetY != 0;
        boolean translateFactorZ = dirOffsetZ != 0;
        double tX = dirOffsetX > 0 ? x + 1.0 : x;
        double tY = dirOffsetY > 0 ? y + 1.0 : y;
        double tZ = dirOffsetZ > 0 ? z + 1.0 : z;
        double translateX = (double)translateFactorX * (tX * lengthTranslateFactor - 0.125 * (double)dirOffsetX);
        double translateY = (double)translateFactorY * (tY * lengthTranslateFactor - 0.125 * (double)dirOffsetY);
        double translateZ = (double)translateFactorZ * (tZ * lengthTranslateFactor - 0.125 * (double)dirOffsetZ);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)translateX, (double)translateY, (double)translateZ);
        GlStateManager.scaled((double)scaleX, (double)scaleY, (double)scaleZ);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        this.func_147499_a(AtlasTexture.field_110575_b);
        RenderHelper.func_74518_a();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.enableBlend();
        GlStateManager.disableCull();
        if (Minecraft.func_71379_u()) {
            GlStateManager.shadeModel((int)7425);
        } else {
            GlStateManager.shadeModel((int)7424);
        }
        BlockModelRenderer.func_211847_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferbuilder.func_178969_c(x - (double)blockpos.func_177958_n(), y - (double)blockpos.func_177956_o(), z - (double)blockpos.func_177952_p());
        World world = this.func_178459_a();
        this.renderStateModel(blockpos, renderState, bufferbuilder, world, false);
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
        BlockModelRenderer.func_210266_a();
        RenderHelper.func_74519_b();
        GlStateManager.popMatrix();
    }

    private boolean renderStateModel(BlockPos pos, BlockState state, BufferBuilder buffer, World p_188186_4_, boolean checkSides) {
        if (this.blockRenderer == null) {
            this.blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        return this.blockRenderer.func_175019_b().func_217631_a((IEnviromentBlockReader)p_188186_4_, this.blockRenderer.func_184389_a(state), state, pos, buffer, checkSides, new Random(), state.func_209533_a(pos));
    }
}

