/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.client;

import com.github.commoble.tubesreloaded.common.blocks.tube.ItemInTubeWrapper;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeTileEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TubeTileEntityRenderer
extends TileEntityRenderer<TubeTileEntity> {
    public void render(TubeTileEntity tube, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!tube.inventory.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.inventory) {
                this.renderWrapper(tube, wrapper, x, y, z, partialTicks);
            }
        }
        if (!tube.incoming_wrapper_buffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.incoming_wrapper_buffer) {
                this.renderWrapper(tube, wrapper, x, y, z, partialTicks);
            }
        }
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.func_190916_E() > 48) {
            i = 5;
        } else if (stack.func_190916_E() > 32) {
            i = 4;
        } else if (stack.func_190916_E() > 16) {
            i = 3;
        } else if (stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }

    public void renderWrapper(TubeTileEntity tube, ItemInTubeWrapper wrapper, double x, double y, double z, float partialTicks) {
        float zStart;
        float yStart;
        float xStart;
        float zEnd;
        float yEnd;
        float xEnd;
        Direction nextMove = wrapper.remainingMoves.peek();
        if (nextMove == null) {
            return;
        }
        ItemStack itemstack = wrapper.stack;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        Random random = new Random();
        Item item = itemstack.func_77973_b();
        int i = itemstack.func_190926_b() ? 187 : Item.func_150891_b((Item)item) + itemstack.func_77952_i();
        random.setSeed(i);
        GlStateManager.pushMatrix();
        int renderedItemCount = this.getModelCount(itemstack);
        float lerpFactor = ((float)wrapper.ticksElapsed + partialTicks) / (float)wrapper.maximumDurationInTube;
        if (wrapper.freshlyInserted) {
            xEnd = (float)x;
            yEnd = (float)y;
            zEnd = (float)z;
            xStart = xEnd - (float)nextMove.func_82601_c();
            yStart = yEnd - (float)nextMove.func_96559_d();
            zStart = zEnd - (float)nextMove.func_82599_e();
        } else {
            xStart = (float)x;
            yStart = (float)y;
            zStart = (float)z;
            xEnd = xStart + (float)nextMove.func_82601_c();
            yEnd = yStart + (float)nextMove.func_96559_d();
            zEnd = zStart + (float)nextMove.func_82599_e();
        }
        float xLerp = MathHelper.func_219799_g((float)lerpFactor, (float)xStart, (float)xEnd);
        float yLerp = MathHelper.func_219799_g((float)lerpFactor, (float)yStart, (float)yEnd);
        float zLerp = MathHelper.func_219799_g((float)lerpFactor, (float)zStart, (float)zEnd);
        itemRenderer.field_77023_b -= 50.0f;
        for (int currentModelIndex = 0; currentModelIndex < renderedItemCount; ++currentModelIndex) {
            GlStateManager.pushMatrix();
            float xAdjustment = 0.0f;
            float yAdjustment = 0.0f;
            float zAdjustment = 0.0f;
            if (currentModelIndex > 0) {
                xAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                yAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                zAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
            }
            float xTranslate = xLerp + xAdjustment + 0.5f;
            float yTranslate = yLerp + yAdjustment + 0.4375f;
            float zTranslate = zLerp + zAdjustment + 0.5f;
            GlStateManager.translatef((float)xTranslate, (float)yTranslate, (float)zTranslate);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            itemRenderer.func_181564_a(itemstack, ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.popMatrix();
        }
        itemRenderer.field_77023_b += 50.0f;
        GlStateManager.popMatrix();
    }
}

