/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="tubesreloaded", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigValues {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int soft_tube_cap;
    public static int hard_tube_cap;
    public static int ticks_in_tube;
    public static int max_items_in_tube;
    public static int osmosis_filter_transfer_rate;

    @SubscribeEvent
    public static void onConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == SERVER_SPEC) {
            ConfigValues.refreshServer();
        }
    }

    public static void refreshServer() {
        soft_tube_cap = (Integer)ConfigValues.SERVER.soft_tube_cap.get();
        hard_tube_cap = (Integer)ConfigValues.SERVER.hard_tube_cap.get();
        ticks_in_tube = (Integer)ConfigValues.SERVER.ticks_in_tube.get();
        max_items_in_tube = (Integer)ConfigValues.SERVER.max_items_in_tube.get();
        osmosis_filter_transfer_rate = (Integer)ConfigValues.SERVER.osmosis_filter_transfer_rate.get();
    }

    static {
        soft_tube_cap = 100;
        hard_tube_cap = 200;
        ticks_in_tube = 10;
        max_items_in_tube = Integer.MAX_VALUE;
        osmosis_filter_transfer_rate = 8;
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.IntValue soft_tube_cap;
        public final ForgeConfigSpec.IntValue hard_tube_cap;
        public final ForgeConfigSpec.IntValue ticks_in_tube;
        public final ForgeConfigSpec.IntValue max_items_in_tube;
        public final ForgeConfigSpec.IntValue osmosis_filter_transfer_rate;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.soft_tube_cap = builder.comment("Soft cap on how many tubes can exist in a contiguous network of tubes. Items are transported slowlier in networks of greater size than this value.").translation("tubesreloaded.config.soft_tube_cap").defineInRange("soft_tube_cap", 100, 1, 10000);
            this.hard_tube_cap = builder.comment("Hard cap on how many tubes can exist in a contiguous network of tubes. If a player attempts to make a network of greater size from this value, not all tubes in the attempted network will become part of that network.").translation("tubesreloaded.config.hard_tube_cap").defineInRange("hard_tube_cap", 200, 1, 10000);
            this.ticks_in_tube = builder.comment("Base time in ticks that a moving itemstack spends in each individual tube block. Adjusted by other factors.").translation("tubesreloaded.config.ticks_in_tube").defineInRange("ticks_in_tube", 10, 1, 72000);
            this.max_items_in_tube = builder.comment("Max items that can fit in a single tube. A tube block will break of the number of itemstacks contained with them is greater than this value, dropping their items on the ground").translation("tubesreloaded.config.max_items_in_tube").defineInRange("max_items_in_tube", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
            this.osmosis_filter_transfer_rate = builder.comment("Osmosis filter automatic item transfer rate in ticks per item. The default value of 8 is the same as vanilla hoppers.").translation("tubesreloaded.config.osmosis_filter_transfer_rate").defineInRange("osmosis_filter_transfer_rate", 8, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

