/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.blocks.loader;

import com.github.commoble.tubesreloaded.common.util.DirectionHelper;
import com.github.commoble.tubesreloaded.common.util.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class LoaderBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;

    public LoaderBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack heldStack = player.func_184586_b(handIn);
        if (heldStack.func_190916_E() > 0) {
            ItemStack remaining = this.insertItem(heldStack.func_77946_l(), worldIn, pos, state);
            if (remaining.func_190916_E() < heldStack.func_190916_E()) {
                if (!worldIn.field_72995_K) {
                    player.func_184611_a(handIn, remaining);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private ItemStack insertItem(ItemStack stack, World world, BlockPos pos, BlockState state) {
        Direction output_dir = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos output_pos = pos.func_177972_a(output_dir);
        ItemStack remaining = (ItemStack)WorldHelper.getTEItemHandlerAt(world, output_pos, output_dir.func_176734_d()).map(handler -> WorldHelper.disperseItemToHandler(stack, handler)).orElse((Object)stack.func_77946_l());
        if (remaining.func_190916_E() > 0) {
            if (world.func_180495_p(output_pos).func_200015_d((IBlockReader)world, output_pos)) {
                return remaining;
            }
            WorldHelper.ejectItemstack(world, pos, output_dir, remaining);
            world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.25f + 2.0f);
            return ItemStack.field_190927_a;
        }
        world.func_184133_a(null, pos, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.25f + 1.0f);
        return ItemStack.field_190927_a;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)DirectionHelper.getBlockFacingForPlacement(context));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }
}

