/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.registry;

import com.github.commoble.tubesreloaded.common.blocks.extractor.ExtractorBlock;
import com.github.commoble.tubesreloaded.common.blocks.filter.FilterBlock;
import com.github.commoble.tubesreloaded.common.blocks.filter.OsmosisFilterBlock;
import com.github.commoble.tubesreloaded.common.blocks.filter.OsmosisSlimeBlock;
import com.github.commoble.tubesreloaded.common.blocks.loader.LoaderBlock;
import com.github.commoble.tubesreloaded.common.blocks.shunt.ShuntBlock;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.common.blocks.tube.colored_tubes.ColoredTubeBlock;
import com.github.commoble.tubesreloaded.common.blocks.tube.redstone_tube.RedstoneTubeBlock;
import com.github.commoble.tubesreloaded.common.registry.BlockNames;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="tubesreloaded")
public class BlockRegistrar {
    @ObjectHolder(value="tube")
    public static final TubeBlock TUBE = null;
    @ObjectHolder(value="shunt")
    public static final ShuntBlock SHUNT = null;
    @ObjectHolder(value="loader")
    public static final LoaderBlock LOADER = null;
    @ObjectHolder(value="redstone_tube")
    public static final RedstoneTubeBlock REDSTONE_TUBE = null;
    @ObjectHolder(value="extractor")
    public static final ExtractorBlock EXTRACTOR = null;
    @ObjectHolder(value="filter")
    public static final FilterBlock FILTER = null;
    @ObjectHolder(value="osmosis_filter")
    public static final OsmosisFilterBlock OSMOSIS_FILTER = null;
    @ObjectHolder(value="osmosis_slime")
    public static final OsmosisSlimeBlock OSMOSIS_SLIME = null;

    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new TubeBlock(Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_193565_Q).func_200943_b(0.4f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "tube");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new ShuntBlock(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "shunt");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new LoaderBlock(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "loader");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new RedstoneTubeBlock(Block.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(0.4f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "redstone_tube");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new ExtractorBlock(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "extractor");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new FilterBlock(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "filter");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new OsmosisFilterBlock(Block.Properties.func_200945_a((Material)Material.field_151571_B).func_200948_a(2.0f, 6.0f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), "osmosis_filter");
        BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new OsmosisSlimeBlock(Block.Properties.func_200945_a((Material)Material.field_151571_B)), "osmosis_slime");
        IntStream.range(0, 16).forEach(i -> BlockRegistrar.registerBlock((IForgeRegistry<Block>)registry, new ColoredTubeBlock(DyeColor.values()[i], Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.4f).harvestTool(ToolType.PICKAXE).func_200947_a(SoundType.field_185852_e)), BlockNames.COLORED_TUBE_NAMES[i]));
    }

    private static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T newBlock, String name) {
        String prefixedName = "tubesreloaded:" + name;
        newBlock.setRegistryName(prefixedName);
        registry.register(newBlock);
        return newBlock;
    }
}

