/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.routing;

import com.github.commoble.tubesreloaded.common.ConfigValues;
import com.github.commoble.tubesreloaded.common.blocks.tube.TubeTileEntity;
import com.github.commoble.tubesreloaded.common.routing.Endpoint;
import com.github.commoble.tubesreloaded.common.routing.FastestRoutesSolver;
import com.github.commoble.tubesreloaded.common.routing.Route;
import com.github.commoble.tubesreloaded.common.util.WorldHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class RoutingNetwork {
    public final Set<BlockPos> tubes = new HashSet<BlockPos>();
    public final Set<Endpoint> endpoints = new HashSet<Endpoint>();
    private final HashMap<BlockPos, List<Route>> bestRoutes = new HashMap();
    public boolean invalid = false;
    public static final RoutingNetwork INVALID_NETWORK = new RoutingNetwork();
    private int ticksPerTube = 10;

    private RoutingNetwork() {
    }

    public int getTicksPerTube() {
        return this.ticksPerTube;
    }

    private void setTicksPerTube() {
        int baseDuration = ConfigValues.ticks_in_tube;
        int size = this.tubes.size();
        int softCap = ConfigValues.soft_tube_cap;
        int hardCap = ConfigValues.hard_tube_cap + 1;
        if (size < softCap) {
            this.ticksPerTube = baseDuration;
            return;
        }
        float slope = 1.0f / (float)(softCap - hardCap);
        float offset = (float)(-hardCap) * slope;
        float dilation = (float)size * slope + offset;
        float time = 1.0f / (dilation * dilation);
        this.ticksPerTube = (int)(time * (float)baseDuration);
    }

    public boolean contains(BlockPos pos, Direction face) {
        if (this.tubes.contains(pos)) {
            return true;
        }
        for (Endpoint endpoint : this.endpoints) {
            if (!endpoint.pos.equals((Object)pos) || !endpoint.face.equals((Object)face)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidToBeInNetwork(BlockPos pos, World world, Direction face) {
        if (this.invalid) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        return te != null && (te instanceof TubeTileEntity || te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face).isPresent());
    }

    public int getSize() {
        return this.tubes.size() + this.endpoints.size();
    }

    @Nullable
    public Route getBestRoute(World world, BlockPos startPos, Direction insertionSide, ItemStack stack) {
        List<Route> routes;
        if (stack.func_190916_E() <= 0) {
            return null;
        }
        if (this.bestRoutes.containsKey(startPos)) {
            routes = this.bestRoutes.get(startPos);
        } else {
            routes = this.generateRoutes(world, startPos);
            this.bestRoutes.put(startPos, routes);
        }
        for (Route route : routes) {
            if (!route.isRouteDestinationValid(world, startPos, insertionSide, stack)) continue;
            return route;
        }
        return null;
    }

    private List<Route> generateRoutes(World world, BlockPos startPos) {
        return FastestRoutesSolver.generateRoutes(this, world, startPos);
    }

    public static RoutingNetwork buildNetworkFrom(BlockPos pos, World world) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        HashSet<BlockPos> potentialEndpoints = new HashSet<BlockPos>();
        RoutingNetwork network = new RoutingNetwork();
        RoutingNetwork.iterativelyBuildNetworkFrom(pos, world, network, visited, potentialEndpoints);
        for (BlockPos endPos : potentialEndpoints) {
            TileEntity te = world.func_175625_s(endPos);
            if (te == null) continue;
            for (Direction face : Direction.values()) {
                if (!network.tubes.contains(endPos.func_177972_a(face))) continue;
                LazyOptional possibleHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face);
                possibleHandler.ifPresent(handler -> network.endpoints.add(new Endpoint(endPos, face)));
            }
        }
        network.confirmAllTubes(world);
        network.setTicksPerTube();
        return network;
    }

    private static void iterativelyBuildNetworkFrom(BlockPos startPos, World world, RoutingNetwork network, HashSet<BlockPos> visited, HashSet<BlockPos> potentialEndpoints) {
        LinkedList<BlockPos> blocksToVisit = new LinkedList<BlockPos>();
        blocksToVisit.add(startPos);
        while (!blocksToVisit.isEmpty() && network.tubes.size() <= ConfigValues.hard_tube_cap) {
            BlockPos visitedPos = (BlockPos)blocksToVisit.poll();
            visited.add(visitedPos);
            TileEntity te = world.func_175625_s(visitedPos);
            if (te instanceof TubeTileEntity) {
                network.tubes.add(visitedPos);
                List<Direction> dirs = ((TubeTileEntity)te).getConnectedDirections();
                for (Direction face : dirs) {
                    BlockPos checkPos = visitedPos.func_177972_a(face);
                    if (visited.contains(checkPos)) continue;
                    blocksToVisit.add(checkPos);
                }
                continue;
            }
            if (te == null) continue;
            potentialEndpoints.add(visitedPos);
        }
    }

    public void confirmAllTubes(World world) {
        WorldHelper.getBlockPositionsAsTubeTileEntities(world, this.tubes).forEach(tube -> tube.setNetwork(this));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof RoutingNetwork) {
            RoutingNetwork otherNetwork = (RoutingNetwork)other;
            return this.endpoints.equals(otherNetwork.endpoints) && this.tubes.equals(otherNetwork.tubes);
        }
        return false;
    }

    public int hashCode() {
        return this.endpoints.hashCode() ^ this.tubes.hashCode();
    }

    public String toString() {
        String endpointText = this.endpoints.stream().map(endpoint -> endpoint.toString()).reduce("Endpoints:\n", (head, tail) -> head + tail + "\n");
        String tubeText = this.tubes.stream().map(tube -> tube.toString()).reduce("Tubes:\n", (head, tail) -> head + tail + "\n");
        return endpointText + "\n" + tubeText;
    }

    static {
        RoutingNetwork.INVALID_NETWORK.invalid = true;
    }
}

