/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.common.util;

import com.github.commoble.tubesreloaded.common.blocks.tube.TubeTileEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WorldHelper {
    public static List<TubeTileEntity> getTubesAdjacentTo(World world, BlockPos pos) {
        ArrayList<TubeTileEntity> tes = new ArrayList<TubeTileEntity>(6);
        for (Direction face : Direction.values()) {
            BlockPos checkPos = pos.func_177972_a(face);
            TileEntity te = world.func_175625_s(checkPos);
            if (!(te instanceof TubeTileEntity)) continue;
            tes.add((TubeTileEntity)te);
        }
        return tes;
    }

    public static Stream<TubeTileEntity> getBlockPositionsAsTubeTileEntities(World world, Collection<BlockPos> posCollection) {
        Stream<TileEntity> teStream = posCollection.stream().map(tubePos -> world.func_175625_s(tubePos));
        Stream<TileEntity> filteredStream = teStream.filter(te -> te instanceof TubeTileEntity);
        return filteredStream.map(te -> (TubeTileEntity)((Object)te));
    }

    public static Optional<TileEntity> getTileEntityAt(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return Optional.ofNullable(te);
    }

    public static <T extends TileEntity> Optional<T> getTileEntityAt(Class<? extends T> clazz, IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return Optional.ofNullable(te != null && clazz.isInstance(te) ? te : null);
    }

    public static LazyOptional<IItemHandler> getTEItemHandlerAt(World world, BlockPos pos, Direction faceOfBlockPos) {
        TileEntity te = world.func_175625_s(pos);
        return te != null ? te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, faceOfBlockPos) : LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> getTEItemHandlerAtIf(World world, BlockPos pos, Direction faceOfBlockPos, Predicate<TileEntity> pred) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return LazyOptional.empty();
        }
        if (!pred.test(te)) {
            return LazyOptional.empty();
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, faceOfBlockPos);
    }

    public static void ejectItemstack(World world, BlockPos from_pos, @Nullable Direction output_dir, ItemStack stack) {
        double zVel;
        double yVel;
        double xVel;
        double z;
        double y;
        double x;
        double zOff;
        double yOff;
        double xOff;
        BlockPos output_pos;
        if (output_dir != null) {
            output_pos = from_pos.func_177972_a(output_dir);
            xOff = output_dir.func_82601_c();
            yOff = output_dir.func_96559_d();
            zOff = output_dir.func_82599_e();
        } else {
            output_pos = from_pos;
            xOff = 0.0;
            yOff = 0.0;
            zOff = 0.0;
        }
        if (!world.func_180495_p(output_pos).func_200132_m()) {
            x = (double)from_pos.func_177958_n() + 0.5 + xOff * 0.75;
            y = (double)from_pos.func_177956_o() + 0.25 + yOff * 0.75;
            z = (double)from_pos.func_177952_p() + 0.5 + zOff * 0.75;
            xVel = xOff * 0.1;
            yVel = yOff * 0.1;
            zVel = zOff * 0.1;
        } else {
            x = (double)from_pos.func_177958_n() + 0.5;
            y = (double)from_pos.func_177956_o() + 0.5;
            z = (double)from_pos.func_177952_p() + 0.5;
            xVel = 0.0;
            yVel = 0.0;
            zVel = 0.0;
        }
        ItemEntity itementity = new ItemEntity(world, x, y, z, stack);
        itementity.func_174869_p();
        itementity.func_213293_j(xVel, yVel, zVel);
        world.func_217376_c((Entity)itementity);
    }

    public static ItemStack disperseItemToHandler(ItemStack stack, IItemHandler handler) {
        int slotCount = handler.getSlots();
        for (int i = 0; i < slotCount; ++i) {
            if (handler.isItemValid(i, stack)) {
                stack = handler.insertItem(i, stack, false);
            }
            if (stack.func_190916_E() != 0) continue;
            return stack.func_77946_l();
        }
        return stack.func_77946_l();
    }

    public static boolean doesItemHandlerHaveAnyExtractableItems(IItemHandler handler, Predicate<ItemStack> doesCallerWantItem) {
        return IntStream.range(0, handler.getSlots()).mapToObj(i -> handler.extractItem(i, 1, true)).anyMatch(stack -> stack.func_190916_E() > 0 && doesCallerWantItem.test((ItemStack)stack));
    }
}

