/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.distributor;

import com.github.commoble.tubesreloaded.blocks.distributor.DistributorTileEntity;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DistributorItemHandler
implements IItemHandler {
    protected final DistributorTileEntity distributor;
    public final Direction inputFace;
    private Direction nextDirection = Direction.DOWN;

    public DistributorItemHandler(DistributorTileEntity distributor, Direction inputFace) {
        this.distributor = distributor;
        this.inputFace = inputFace;
    }

    public int getNextDirectionIndex() {
        return this.nextDirection.func_176745_a();
    }

    public void setNextDirectionIndex(int index) {
        this.nextDirection = Direction.func_82600_a((int)index);
        this.distributor.func_70296_d();
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int startCheckIndex = this.nextDirection.func_176745_a();
        int checkIndex = 0;
        ItemStack remainingStack = stack;
        if (!simulate && !stack.func_190926_b()) {
            for (int i = 0; i < 6; ++i) {
                checkIndex = (i + startCheckIndex) % 6;
                Direction checkDirection = Direction.func_82600_a((int)checkIndex);
                if (checkDirection == this.inputFace) continue;
                BlockPos outputPos = this.distributor.func_174877_v().func_177972_a(checkDirection);
                ItemStack stackForNextInsertion = remainingStack.func_77946_l();
                remainingStack = (ItemStack)this.getOutputOptional(outputPos, checkDirection).map(handler -> WorldHelper.disperseItemToHandler(stackForNextInsertion, handler, simulate)).orElse((Object)remainingStack);
                if (remainingStack.func_190926_b()) break;
            }
            if (!remainingStack.func_190926_b()) {
                WorldHelper.ejectItemstack(this.distributor.func_145831_w(), this.distributor.func_174877_v(), this.inputFace.func_176734_d(), remainingStack);
            }
            this.setNextDirectionIndex((checkIndex + 1) % 6);
        }
        return ItemStack.field_190927_a;
    }

    private LazyOptional<IItemHandler> getOutputOptional(BlockPos output_pos, Direction output_dir) {
        ITag shuntTag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("tubesreloaded", "shunts"));
        return WorldHelper.getTEItemHandlerAtIf(this.distributor.func_145831_w(), output_pos, output_dir.func_176734_d(), te -> !shuntTag.func_230235_a_((Object)te.func_195044_w().func_177230_c()));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

