/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.filter;

import com.github.commoble.tubesreloaded.blocks.filter.FilterContainer;
import com.github.commoble.tubesreloaded.blocks.filter.FilterTileEntity;
import com.github.commoble.tubesreloaded.registry.TileEntityRegistrar;
import com.github.commoble.tubesreloaded.util.ClassHelper;
import com.github.commoble.tubesreloaded.util.DirectionHelper;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class FilterBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    protected final VoxelShape[] shapes;

    public FilterBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.shapes = this.makeShapes();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityRegistrar.FILTER.func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ClassHelper.as(player, ServerPlayerEntity.class).ifPresent(serverPlayer -> WorldHelper.getTileEntityAt(FilterTileEntity.class, (IWorldReader)world, pos).ifPresent(filter -> NetworkHooks.openGui((ServerPlayerEntity)serverPlayer, (INamedContainerProvider)new SimpleNamedContainerProvider(FilterContainer.getServerContainerProvider(filter), (ITextComponent)new TranslationTextComponent(this.func_149739_a())))));
        return ActionResultType.SUCCESS;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (!world.field_72995_K) {
                WorldHelper.getTileEntityAt(FilterTileEntity.class, (IWorldReader)world, pos).ifPresent(te -> te.dropItems());
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)DirectionHelper.getBlockFacingForPlacement(context));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    protected VoxelShape[] makeShapes() {
        VoxelShape[] shapes = new VoxelShape[6];
        for (int face = 0; face < 6; ++face) {
            boolean DOWN = face == 0;
            boolean UP = face == 1;
            boolean NORTH = face == 2;
            boolean SOUTH = face == 3;
            boolean WEST = face == 4;
            boolean EAST = face == 5;
            double x_min = EAST ? 14.0 : 0.0;
            double x_max = WEST ? 2.0 : 16.0;
            double y_min = UP ? 14.0 : 0.0;
            double y_max = DOWN ? 2.0 : 16.0;
            double z_min = SOUTH ? 14.0 : 0.0;
            double z_max = NORTH ? 2.0 : 16.0;
            VoxelShape plate = Block.func_208617_a((double)x_min, (double)y_min, (double)z_min, (double)x_max, (double)y_max, (double)z_max);
            double d = WEST ? 0.0 : (x_min = EAST ? 0.0 : 6.0);
            x_max = WEST ? 16.0 : (EAST ? 16.0 : 10.0);
            y_min = 0.0;
            y_max = 16.0;
            double d2 = WEST ? 6.0 : (z_min = EAST ? 6.0 : 0.0);
            z_max = WEST ? 10.0 : (EAST ? 10.0 : 16.0);
            VoxelShape vertical = Block.func_208617_a((double)x_min, (double)y_min, (double)z_min, (double)x_max, (double)y_max, (double)z_max);
            x_min = 0.0;
            x_max = 16.0;
            double d3 = UP ? 0.0 : (y_min = DOWN ? 0.0 : 6.0);
            double d4 = UP ? 16.0 : (y_max = DOWN ? 16.0 : 10.0);
            double d5 = UP ? 6.0 : (z_min = DOWN ? 6.0 : 0.0);
            z_max = UP ? 10.0 : (DOWN ? 10.0 : 16.0);
            VoxelShape horizontal = Block.func_208617_a((double)x_min, (double)y_min, (double)z_min, (double)x_max, (double)y_max, (double)z_max);
            shapes[face] = VoxelShapes.func_216384_a((VoxelShape)plate, (VoxelShape[])new VoxelShape[]{vertical, horizontal});
        }
        return shapes;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public int getShapeIndex(BlockState state) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176745_a();
    }
}

