/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.filter;

import com.github.commoble.tubesreloaded.blocks.filter.FilterTileEntity;
import com.github.commoble.tubesreloaded.registry.ContainerRegistrar;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FilterContainer
extends Container {
    public final IInventory inventory;

    public static FilterContainer getClientContainer(int id, PlayerInventory playerInventory) {
        return new FilterContainer(id, playerInventory, (IInventory)new Inventory(1));
    }

    public static IContainerProvider getServerContainerProvider(FilterTileEntity filter) {
        return (id, playerInventory, theServerPlayer) -> new FilterContainer(id, playerInventory, new FilterInventory(filter));
    }

    private FilterContainer(int id, PlayerInventory playerInventory, IInventory filterInventory) {
        super(ContainerRegistrar.FILTER, id);
        this.inventory = filterInventory;
        this.func_75146_a(new FilterSlot(filterInventory, 0, 80, 35));
        for (int backpackRow = 0; backpackRow < 3; ++backpackRow) {
            for (int backpackColumn = 0; backpackColumn < 9; ++backpackColumn) {
                this.func_75146_a(new Slot((IInventory)playerInventory, backpackColumn + backpackRow * 9 + 9, 8 + backpackColumn * 18, 84 + backpackRow * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)playerInventory, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack copiedStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackFromSlot = slot.func_75211_c();
            copiedStack = stackFromSlot.func_77946_l();
            if (index == 0 ? !this.func_75135_a(stackFromSlot, 1, 37, true) : !this.func_75135_a(stackFromSlot, 0, 1, false)) {
                return ItemStack.field_190927_a;
            }
            if (stackFromSlot.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackFromSlot.func_190916_E() == copiedStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stackFromSlot);
        }
        return copiedStack;
    }

    static class FilterInventory
    implements IInventory {
        private final FilterTileEntity filter;

        public FilterInventory(FilterTileEntity filter) {
            this.filter = filter;
        }

        public void func_174888_l() {
            this.filter.setFilterStackAndSaveAndSync(ItemStack.field_190927_a);
        }

        public int func_70302_i_() {
            return 1;
        }

        public boolean func_191420_l() {
            return this.filter.filterStack.func_190926_b();
        }

        public ItemStack func_70301_a(int index) {
            return this.filter.filterStack;
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack newStack = this.filter.filterStack.func_77979_a(count);
            this.filter.setFilterStackAndSaveAndSync(this.filter.filterStack);
            return newStack;
        }

        public ItemStack func_70304_b(int index) {
            ItemStack stack = this.filter.filterStack.func_77946_l();
            this.filter.setFilterStackAndSaveAndSync(ItemStack.field_190927_a);
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.filter.setFilterStackAndSaveAndSync(stack);
        }

        public void func_70296_d() {
            this.filter.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            World world = this.filter.func_145831_w();
            BlockPos pos = this.filter.func_174877_v();
            Block block = this.filter.func_195044_w().func_177230_c();
            return world.func_180495_p(pos).func_177230_c() != block ? false : player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= 64.0;
        }
    }

    static class FilterSlot
    extends Slot {
        public FilterSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public int func_75219_a() {
            return 1;
        }
    }
}

