/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.filter;

import com.github.commoble.tubesreloaded.blocks.filter.FilterBlock;
import com.github.commoble.tubesreloaded.blocks.filter.FilterTileEntity;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class FilterShuntingItemHandler
implements IItemHandler {
    public FilterTileEntity filter;
    private LazyOptional<IItemHandler> targetInventory = LazyOptional.empty();

    public FilterShuntingItemHandler(FilterTileEntity filter) {
        this.filter = filter;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Direction output_dir;
        BlockPos pos;
        BlockPos output_pos;
        ItemStack remaining;
        if (!this.isItemValid(slot, stack)) {
            return stack.func_77946_l();
        }
        if (!simulate && (remaining = (ItemStack)this.getOutputOptional(output_pos = (pos = this.filter.func_174877_v()).func_177972_a(output_dir = (Direction)this.filter.func_195044_w().func_177229_b((Property)FilterBlock.FACING)), output_dir).map(handler -> WorldHelper.disperseItemToHandler(stack, handler)).orElse((Object)stack.func_77946_l())).func_190916_E() > 0) {
            WorldHelper.ejectItemstack(this.filter.func_145831_w(), pos, output_dir, remaining);
        }
        return ItemStack.field_190927_a;
    }

    private LazyOptional<IItemHandler> getOutputOptional(BlockPos output_pos, Direction output_dir) {
        if (!this.targetInventory.isPresent()) {
            ITag shuntTag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("tubesreloaded", "shunts"));
            this.targetInventory = WorldHelper.getTEItemHandlerAtIf(this.filter.func_145831_w(), output_pos, output_dir.func_176734_d(), te -> !shuntTag.func_230235_a_((Object)te.func_195044_w().func_177230_c()));
        }
        return this.targetInventory;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.func_190916_E() > 0 && this.filter.canItemPassThroughFilter(stack);
    }
}

