/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.shunt;

import com.github.commoble.tubesreloaded.registry.TileEntityRegistrar;
import com.github.commoble.tubesreloaded.util.DirectionHelper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class ShuntBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.field_176387_N;
    protected final VoxelShape[] shapes;

    public ShuntBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
        this.shapes = this.makeShapes();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityRegistrar.SHUNT.func_200968_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)DirectionHelper.getBlockFacingForPlacement(context));
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    protected VoxelShape[] makeShapes() {
        double MIN_VOXEL = 0.0;
        double ONE_QUARTER = 4.0;
        double THREE_QUARTERS = 12.0;
        double SIX_SIXTEENTHS = 6.0;
        double TEN_SIXTEENTHS = 10.0;
        double MAX_VOXEL = 16.0;
        VoxelShape[] shapes = new VoxelShape[6];
        VoxelShape coreNorth = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape coreSouth = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape coreWest = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape coreEast = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        VoxelShape coreDown = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape coreUp = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape down = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
        VoxelShape up = Block.func_208617_a((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
        VoxelShape south = Block.func_208617_a((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
        VoxelShape west = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
        VoxelShape east = Block.func_208617_a((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape[] tube_dunswe = new VoxelShape[]{down, up, north, south, west, east};
        VoxelShape[] core_dunswe = new VoxelShape[]{coreDown, coreUp, coreNorth, coreSouth, coreWest, coreEast};
        for (int state_dir = 0; state_dir < 6; ++state_dir) {
            VoxelShape stateShape = core_dunswe[state_dir];
            for (int voxel_dir = 0; voxel_dir < 6; ++voxel_dir) {
                if (voxel_dir == state_dir) continue;
                stateShape = VoxelShapes.func_197872_a((VoxelShape)stateShape, (VoxelShape)tube_dunswe[voxel_dir]);
            }
            shapes[state_dir] = stateShape;
        }
        return shapes;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_196954_c(worldIn, pos);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public int getShapeIndex(BlockState state) {
        return ((Direction)state.func_177229_b((Property)FACING)).func_176745_a();
    }
}

