/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.tube;

import com.github.commoble.tubesreloaded.blocks.tube.TubeRayTraceContext;
import com.github.commoble.tubesreloaded.blocks.tube.TubeRayTraceSelectionContext;
import com.github.commoble.tubesreloaded.blocks.tube.TubeTileEntity;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RaytraceHelper {
    public static Vector3d[] getInterpolatedDifferences(Vector3d vector) {
        int points = 17;
        Vector3d[] list = new Vector3d[points];
        double dx = vector.func_82615_a();
        double dy = vector.func_82617_b();
        double dz = vector.func_82616_c();
        for (int point = 0; point < points; ++point) {
            double startLerp = RaytraceHelper.getFractionalLerp(point, points - 1);
            list[point] = new Vector3d(startLerp * dx, startLerp * dy, startLerp * dz);
        }
        return list;
    }

    public static Vector3d[] getInterpolatedPoints(Vector3d lower, Vector3d upper) {
        Vector3d diff = upper.func_178788_d(lower);
        Vector3d[] diffs = RaytraceHelper.getInterpolatedDifferences(diff);
        Vector3d[] points = new Vector3d[diffs.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = lower.func_178787_e(diffs[i]);
        }
        return points;
    }

    public static double getFractionalLerp(int current, int max) {
        return (double)current / (double)max;
    }

    public static Vector3d getTubeSideCenter(BlockPos pos, Direction side) {
        Vector3d center = TubeTileEntity.getCenter(pos);
        double offsetFromCenter = 0.25;
        double xOff = (double)side.func_82601_c() * offsetFromCenter;
        double yOff = (double)side.func_96559_d() * offsetFromCenter;
        double zOff = (double)side.func_82599_e() * offsetFromCenter;
        return center.func_72441_c(xOff, yOff, zOff);
    }

    @Nullable
    public static Vector3d getTubeRaytraceHit(Vector3d startVec, Vector3d endVec, World world) {
        Vector3d[] points = RaytraceHelper.getInterpolatedPoints(startVec, endVec);
        TubeRayTraceSelectionContext selector = new TubeRayTraceSelectionContext();
        int pointCount = points.length;
        int rayTraceCount = pointCount - 1;
        for (int i = 0; i < rayTraceCount; ++i) {
            TubeRayTraceContext context = new TubeRayTraceContext(selector, points[i], points[i + 1], RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE);
            BlockRayTraceResult result = RaytraceHelper.rayTraceBlocks(world, context);
            if (result.func_216346_c() == RayTraceResult.Type.MISS) continue;
            return result.func_216347_e();
        }
        return null;
    }

    public static BlockRayTraceResult rayTraceBlocks(World world, TubeRayTraceContext context) {
        return RaytraceHelper.doRayTrace(context, (rayTraceContext, pos) -> {
            BlockState state = world.func_180495_p(pos);
            Vector3d startVec = rayTraceContext.getStartVec();
            Vector3d endVec = rayTraceContext.getEndVec();
            VoxelShape shape = rayTraceContext.getBlockShape(state, (IBlockReader)world, (BlockPos)pos);
            BlockRayTraceResult result = world.func_217296_a(startVec, endVec, pos, shape, state);
            return result;
        }, rayTraceContext -> {
            Vector3d difference = rayTraceContext.getStartVec().func_178788_d(rayTraceContext.getEndVec());
            return BlockRayTraceResult.func_216352_a((Vector3d)rayTraceContext.getEndVec(), (Direction)Direction.func_210769_a((double)difference.field_72450_a, (double)difference.field_72448_b, (double)difference.field_72449_c), (BlockPos)new BlockPos(rayTraceContext.getEndVec()));
        });
    }

    static <T> T doRayTrace(TubeRayTraceContext context, BiFunction<TubeRayTraceContext, BlockPos, T> rayTracer, Function<TubeRayTraceContext, T> missFactory) {
        int startZInt;
        int startYInt;
        Vector3d end;
        Vector3d start = context.getStartVec();
        if (start.equals((Object)(end = context.getEndVec()))) {
            return missFactory.apply(context);
        }
        double endX = MathHelper.func_219803_d((double)-1.0E-7, (double)end.field_72450_a, (double)start.field_72450_a);
        double endY = MathHelper.func_219803_d((double)-1.0E-7, (double)end.field_72448_b, (double)start.field_72448_b);
        double endZ = MathHelper.func_219803_d((double)-1.0E-7, (double)end.field_72449_c, (double)start.field_72449_c);
        double startX = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72450_a, (double)end.field_72450_a);
        double startY = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72448_b, (double)end.field_72448_b);
        double startZ = MathHelper.func_219803_d((double)-1.0E-7, (double)start.field_72449_c, (double)end.field_72449_c);
        int startXInt = MathHelper.func_76128_c((double)startX);
        BlockPos.Mutable mutaPos = new BlockPos.Mutable(startXInt, startYInt = MathHelper.func_76128_c((double)startY), startZInt = MathHelper.func_76128_c((double)startZ));
        T result = rayTracer.apply(context, (BlockPos)mutaPos);
        if (result != null) {
            return result;
        }
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        int xSign = MathHelper.func_219802_k((double)dx);
        int ySign = MathHelper.func_219802_k((double)dy);
        int zSign = MathHelper.func_219802_k((double)dz);
        double reciprocalX = xSign == 0 ? Double.MAX_VALUE : (double)xSign / dx;
        double reciprocalY = ySign == 0 ? Double.MAX_VALUE : (double)ySign / dy;
        double reciprocalZ = zSign == 0 ? Double.MAX_VALUE : (double)zSign / dz;
        double calcX = reciprocalX * (xSign > 0 ? 1.0 - MathHelper.func_181162_h((double)startX) : MathHelper.func_181162_h((double)startX));
        double calcY = reciprocalY * (ySign > 0 ? 1.0 - MathHelper.func_181162_h((double)startY) : MathHelper.func_181162_h((double)startY));
        double calcZ = reciprocalZ * (zSign > 0 ? 1.0 - MathHelper.func_181162_h((double)startZ) : MathHelper.func_181162_h((double)startZ));
        while (calcX <= 1.0 || calcY <= 1.0 || calcZ <= 1.0) {
            T fallbackResult;
            if (calcX < calcY) {
                if (calcX < calcZ) {
                    startXInt += xSign;
                    calcX += reciprocalX;
                } else {
                    startZInt += zSign;
                    calcZ += reciprocalZ;
                }
            } else if (calcY < calcZ) {
                startYInt += ySign;
                calcY += reciprocalY;
            } else {
                startZInt += zSign;
                calcZ += reciprocalZ;
            }
            if ((fallbackResult = rayTracer.apply(context, (BlockPos)mutaPos.func_181079_c(startXInt, startYInt, startZInt))) == null) continue;
            return fallbackResult;
        }
        return missFactory.apply(context);
    }
}

