/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.tube;

import com.github.commoble.tubesreloaded.TubesReloaded;
import com.github.commoble.tubesreloaded.blocks.tube.ItemInTubeWrapper;
import com.github.commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import com.github.commoble.tubesreloaded.blocks.tube.RemoteConnection;
import com.github.commoble.tubesreloaded.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.blocks.tube.TubeInventoryHandler;
import com.github.commoble.tubesreloaded.network.PacketHandler;
import com.github.commoble.tubesreloaded.network.TubeBreakPacket;
import com.github.commoble.tubesreloaded.registry.TileEntityRegistrar;
import com.github.commoble.tubesreloaded.routing.Route;
import com.github.commoble.tubesreloaded.routing.RoutingNetwork;
import com.github.commoble.tubesreloaded.util.NBTMapHelper;
import com.github.commoble.tubesreloaded.util.NestedBoundingBox;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TubeTileEntity
extends TileEntity
implements ITickableTileEntity {
    public static final String INV_NBT_KEY_ADD = "inventory_new_items";
    public static final String INV_NBT_KEY_RESET = "inventory_reset";
    public static final String CONNECTIONS = "connections";
    public static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final String SIDE = "side";
    public static final NBTMapHelper<Direction, IntNBT, RemoteConnection.Storage, CompoundNBT> REMOTE_CONNECTIONS_CODEC = new NBTMapHelper<Direction, IntNBT, RemoteConnection.Storage, CompoundNBT>("connections", side -> IntNBT.func_229692_a_((int)side.ordinal()), nbt -> Direction.func_82600_a((int)nbt.func_150287_d()), rcs -> rcs.toNBT(), nbt -> RemoteConnection.Storage.fromNBT(nbt));
    private Map<Direction, RemoteConnection> remoteConnections = new HashMap<Direction, RemoteConnection>();
    private AxisAlignedBB renderAABB = EMPTY_AABB;
    @Nonnull
    public Queue<ItemInTubeWrapper> inventory = new LinkedList<ItemInTubeWrapper>();
    protected final TubeInventoryHandler[] inventoryHandlers = (TubeInventoryHandler[])Arrays.stream(Direction.values()).map(dir -> new TubeInventoryHandler(this, (Direction)dir)).toArray(TubeInventoryHandler[]::new);
    protected final LazyOptional<IItemHandler>[] handlerOptionals = (LazyOptional[])Arrays.stream(this.inventoryHandlers).map(handler -> LazyOptional.of(() -> handler)).toArray(LazyOptional[]::new);
    private Queue<ItemInTubeWrapper> wrappers_to_send_to_client = new LinkedList<ItemInTubeWrapper>();
    public Queue<ItemInTubeWrapper> incoming_wrapper_buffer = new LinkedList<ItemInTubeWrapper>();
    @Nonnull
    private RoutingNetwork network = RoutingNetwork.INVALID_NETWORK;

    public TubeTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public TubeTileEntity() {
        this(TileEntityRegistrar.TUBE);
    }

    public static Optional<TubeTileEntity> getTubeTEAt(IWorld world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return Optional.ofNullable(te instanceof TubeTileEntity ? (TubeTileEntity)te : null);
    }

    public static boolean addConnection(IWorld world, Direction sideA, BlockPos posA, Direction sideB, BlockPos posB) {
        return TubeTileEntity.getTubeTEAt(world, posA).flatMap(tubeA -> TubeTileEntity.getTubeTEAt(world, posB).map(tubeB -> TubeTileEntity.addConnection(world, tubeA, sideA, tubeB, sideB))).orElse(false);
    }

    public static boolean addConnection(IWorld world, @Nonnull TubeTileEntity fromTube, @Nonnull Direction fromSide, @Nonnull TubeTileEntity toTube, @Nonnull Direction toSide) {
        fromTube.addConnection(fromSide, toSide, toTube.field_174879_c, true);
        toTube.addConnection(toSide, fromSide, fromTube.field_174879_c, false);
        return true;
    }

    public static boolean areTubesConnected(IWorld world, BlockPos posA, BlockPos posB) {
        return TubeTileEntity.getTubeTEAt(world, posA).flatMap(tubeA -> TubeTileEntity.getTubeTEAt(world, posB).map(tubeB -> tubeA.hasRemoteConnection(posB) && tubeB.hasRemoteConnection(posA))).orElse(false);
    }

    public static void removeConnection(IWorld world, BlockPos posA, BlockPos posB) {
        TubeTileEntity.getTubeTEAt(world, posA).ifPresent(tube -> tube.removeConnection(posB));
        TubeTileEntity.getTubeTEAt(world, posB).ifPresent(tube -> tube.removeConnection(posA));
    }

    public static Vector3d getCenter(BlockPos pos) {
        return new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static AxisAlignedBB getAABBContainingAllBlockPos(BlockPos startPos, Set<BlockPos> theRest) {
        return theRest.stream().map(AxisAlignedBB::new).reduce(new AxisAlignedBB(startPos), AxisAlignedBB::func_111270_a, AxisAlignedBB::func_111270_a);
    }

    public RoutingNetwork getNetwork() {
        if (this.network.invalid) {
            this.network = RoutingNetwork.buildNetworkFrom(this.field_174879_c, this.field_145850_b);
        }
        return this.network;
    }

    public void setNetwork(RoutingNetwork network) {
        this.network = network;
    }

    public boolean isTubeCompatible(TubeTileEntity tube) {
        Block thisBlock = this.func_195044_w().func_177230_c();
        Block otherBlock = tube.func_195044_w().func_177230_c();
        if (thisBlock instanceof TubeBlock && otherBlock instanceof TubeBlock) {
            return ((TubeBlock)thisBlock).isTubeCompatible((TubeBlock)otherBlock);
        }
        return false;
    }

    public Set<Direction> getAdjacentConnectedDirections() {
        BlockState state = this.func_195044_w();
        return TubeBlock.getConnectedDirections(state);
    }

    public Set<Direction> getAllConnectedDirections() {
        HashSet<Direction> result = new HashSet<Direction>();
        result.addAll(this.getAdjacentConnectedDirections());
        result.addAll(this.getRemoteConnections().keySet());
        return result;
    }

    public Route getBestRoute(Direction insertionSide, ItemStack stack) {
        return this.getNetwork().getBestRoute(this.field_145850_b, this.field_174879_c, insertionSide, stack);
    }

    public Map<Direction, RemoteConnection> getRemoteConnections() {
        return this.remoteConnections;
    }

    public boolean hasRemoteConnection(BlockPos otherPos) {
        return this.getDirectionOfRemoteConnection(otherPos).isPresent();
    }

    public Optional<RemoteConnection> getRemoteConnection(Direction face) {
        return Optional.ofNullable(this.getRemoteConnections().get(face));
    }

    public boolean hasRemoteConnection(Direction face) {
        return this.getRemoteConnections().containsKey(face);
    }

    public Optional<Direction> getDirectionOfRemoteConnection(BlockPos otherPos) {
        return this.getRemoteConnections().entrySet().stream().filter(entry -> ((RemoteConnection)entry.getValue()).toPos.equals((Object)otherPos)).findAny().map(entry -> (Direction)entry.getKey());
    }

    public void clearRemoteConnections() {
        this.remoteConnections.entrySet().forEach(entry -> TubeTileEntity.getTubeTEAt((IWorld)this.field_145850_b, ((RemoteConnection)entry.getValue()).toPos).ifPresent(otherTube -> otherTube.removeConnection(this.field_174879_c)));
        this.remoteConnections = new HashMap<Direction, RemoteConnection>();
        this.onDataUpdated();
    }

    private void addConnection(Direction thisSide, Direction otherSide, BlockPos otherPos, boolean isPrimary) {
        this.remoteConnections.put(thisSide, new RemoteConnection(thisSide, otherSide, this.field_174879_c, otherPos, isPrimary));
        this.network.invalid = true;
        this.onDataUpdated();
    }

    private void removeConnection(BlockPos otherPos) {
        BlockState newState = this.func_195044_w();
        for (Direction dir : Direction.values()) {
            RemoteConnection connection = this.remoteConnections.get(dir);
            if (connection == null || !connection.toPos.equals((Object)otherPos)) continue;
            this.remoteConnections.remove(dir);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.onPossibleNetworkUpdateRequired();
            this.network.invalid = true;
            this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.field_145850_b.func_175726_f(this.field_174879_c)), (Object)new TubeBreakPacket(TubeTileEntity.getCenter(this.field_174879_c), TubeTileEntity.getCenter(otherPos)));
        }
        this.onDataUpdated();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderAABB;
    }

    @Nullable
    public Vector3d doesBlockStateIntersectConnection(BlockPos placePos, BlockState placeState, Set<BlockPos> checkedTubePositions) {
        for (Map.Entry<Direction, RemoteConnection> entry : this.remoteConnections.entrySet()) {
            Direction toSide;
            Direction fromSide;
            Vector3d hit;
            RemoteConnection connection = entry.getValue();
            BlockPos pos = connection.toPos;
            if (checkedTubePositions.contains(pos) || (hit = TubeTileEntity.doesBlockStateIntersectConnection(this.field_174879_c, fromSide = entry.getKey(), pos, toSide = connection.toSide, placePos, placeState, connection.box, this.func_145831_w())) == null) continue;
            return hit;
        }
        return null;
    }

    @Nullable
    public static Vector3d doesBlockStateIntersectConnection(BlockPos startPos, Direction startSide, BlockPos endPos, Direction endSide, BlockPos placePos, BlockState placeState, NestedBoundingBox box, World world) {
        VoxelShape shape = placeState.func_196952_d((IBlockReader)world, placePos);
        for (AxisAlignedBB aabb : shape.func_197756_d()) {
            if (!box.intersects(aabb.func_186670_a(placePos))) continue;
            Vector3d startVec = RaytraceHelper.getTubeSideCenter(startPos, startSide);
            Vector3d endVec = RaytraceHelper.getTubeSideCenter(endPos, endSide);
            return RaytraceHelper.getTubeRaytraceHit(startVec, endVec, world);
        }
        return null;
    }

    public void func_145843_s() {
        this.dropItems();
        this.network.invalid = true;
        Arrays.stream(this.handlerOptionals).forEach(optional -> optional.invalidate());
        this.clearRemoteConnections();
        super.func_145843_s();
    }

    public void onPossibleNetworkUpdateRequired() {
        if (!this.network.invalid && this.didNetworkChange()) {
            this.network.invalid = true;
        }
    }

    private boolean didNetworkChange() {
        for (Direction face : Direction.values()) {
            BlockPos checkPos = this.field_174879_c.func_177972_a(face);
            if (this.getNetwork().contains(this.field_174879_c, face.func_176734_d()) == this.getNetwork().isValidToBeInNetwork(checkPos, this.field_145850_b, face.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        this.merge_buffer();
        if (!this.inventory.isEmpty()) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
            }
            LinkedList<ItemInTubeWrapper> remainingWrappers = new LinkedList<ItemInTubeWrapper>();
            for (ItemInTubeWrapper wrapper : this.inventory) {
                ++wrapper.ticksElapsed;
                if (wrapper.ticksElapsed >= wrapper.maximumDurationInTube) {
                    if (wrapper.freshlyInserted) {
                        wrapper.freshlyInserted = false;
                        wrapper.remainingMoves.removeFirst();
                        wrapper.ticksElapsed = 0;
                        remainingWrappers.add(wrapper);
                        continue;
                    }
                    this.sendWrapperOnward(wrapper);
                    continue;
                }
                remainingWrappers.add(wrapper);
            }
            this.inventory = remainingWrappers;
        }
        if (!this.field_145850_b.field_72995_K && this.inventory.size() > TubesReloaded.serverConfig.max_items_in_tube.get()) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
    }

    public BlockPos getConnectedPos(Direction dir) {
        if (this.remoteConnections.containsKey(dir)) {
            return this.remoteConnections.get((Object)dir).toPos;
        }
        return this.field_174879_c.func_177972_a(dir);
    }

    public void sendWrapperOnward(ItemInTubeWrapper wrapper) {
        if (!wrapper.remainingMoves.isEmpty()) {
            Direction dir = wrapper.remainingMoves.poll();
            BlockPos nextPos = this.getConnectedPos(dir);
            TileEntity te = this.field_145850_b.func_175625_s(nextPos);
            if (te instanceof TubeTileEntity) {
                if (this.isTubeCompatible((TubeTileEntity)te) || this.hasRemoteConnection(nextPos)) {
                    ((TubeTileEntity)te).enqueueItemStack(wrapper.stack, wrapper.remainingMoves, wrapper.maximumDurationInTube);
                }
            } else if (!this.field_145850_b.field_72995_K) {
                if (te != null) {
                    ItemStack remaining = (ItemStack)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d()).map(handler -> WorldHelper.disperseItemToHandler(wrapper.stack, handler)).orElse((Object)wrapper.stack.func_77946_l());
                    if (!remaining.func_190926_b()) {
                        ItemStack unenqueueableItems = this.enqueueItemStack(remaining, dir, false);
                        WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, dir, unenqueueableItems);
                    }
                } else {
                    WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, dir, wrapper.stack);
                }
            }
        } else if (!this.field_145850_b.field_72995_K) {
            WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, null, wrapper.stack);
        }
    }

    public void onDataUpdated() {
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            return this.handlerOptionals[side.func_176745_a()].cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack enqueueItemStack(ItemStack stack, Direction face, boolean simulate) {
        Route route = this.getNetwork().getBestRoute(this.field_145850_b, this.field_174879_c, face, stack);
        if (route == null || route.sequenceOfMoves.isEmpty()) {
            return stack.func_77946_l();
        }
        if (simulate) {
            return ItemStack.field_190927_a;
        }
        int ticks_per_tube = this.getNetwork().getTicksPerTube();
        this.wrappers_to_send_to_client.add(new ItemInTubeWrapper(stack, route.sequenceOfMoves, ticks_per_tube, face.func_176734_d()));
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        return this.enqueueItemStack(new ItemInTubeWrapper(stack, route.sequenceOfMoves, 10, face.func_176734_d()));
    }

    public ItemStack enqueueItemStack(ItemInTubeWrapper wrapper) {
        this.incoming_wrapper_buffer.add(wrapper);
        return ItemStack.field_190927_a;
    }

    public ItemStack enqueueItemStack(ItemStack stack, Queue<Direction> remainingMoves, int ticksPerTube) {
        return this.enqueueItemStack(new ItemInTubeWrapper(stack, remainingMoves, ticksPerTube));
    }

    public void merge_buffer() {
        if (!this.incoming_wrapper_buffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : this.incoming_wrapper_buffer) {
                this.inventory.add(wrapper);
            }
            this.incoming_wrapper_buffer = new LinkedList<ItemInTubeWrapper>();
        }
    }

    public void dropItems() {
        this.merge_buffer();
        for (ItemInTubeWrapper wrapper : this.inventory) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)wrapper.stack);
        }
        this.inventory = new LinkedList<ItemInTubeWrapper>();
    }

    public static boolean isSpaceForAnythingInItemHandler(IItemHandler handler) {
        return true;
    }

    public boolean isAnyInventoryAdjacent() {
        for (Direction face : Direction.values()) {
            LazyOptional cap;
            IItemHandler handler;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
            if (te == null || te instanceof TubeTileEntity || (handler = (IItemHandler)(cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())).orElse(null)) == null || !TubeTileEntity.isSpaceForAnythingInItemHandler(handler)) continue;
            return true;
        }
        return false;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readNBT(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT invList = new ListNBT();
        this.merge_buffer();
        for (ItemInTubeWrapper wrapper : this.inventory) {
            CompoundNBT invTag = new CompoundNBT();
            wrapper.writeToNBT(invTag);
            invList.add((Object)invTag);
        }
        if (!invList.isEmpty()) {
            compound.func_218657_a(INV_NBT_KEY_RESET, (INBT)invList);
        }
        REMOTE_CONNECTIONS_CODEC.write(Maps.transformValues(this.remoteConnections, connection -> connection.toStorage()), compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        super.func_189515_b(nbt);
        ListNBT invList = new ListNBT();
        while (!this.wrappers_to_send_to_client.isEmpty()) {
            ItemInTubeWrapper wrapper = this.wrappers_to_send_to_client.poll();
            CompoundNBT invTag = new CompoundNBT();
            wrapper.writeToNBT(invTag);
            invList.add((Object)invTag);
        }
        if (!invList.isEmpty()) {
            nbt.func_218657_a(INV_NBT_KEY_ADD, (INBT)invList);
        }
        REMOTE_CONNECTIONS_CODEC.write(Maps.transformValues(this.remoteConnections, connection -> connection.toStorage()), nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.readNBT(packet.func_148857_g());
    }

    public void readNBT(CompoundNBT compound) {
        ListNBT invList;
        if (compound.func_74764_b(INV_NBT_KEY_RESET)) {
            invList = compound.func_150295_c(INV_NBT_KEY_RESET, 10);
            LinkedList<ItemInTubeWrapper> inventory = new LinkedList<ItemInTubeWrapper>();
            for (int i = 0; i < invList.size(); ++i) {
                CompoundNBT itemTag = invList.func_150305_b(i);
                inventory.add(ItemInTubeWrapper.readFromNBT(itemTag));
            }
            this.inventory = inventory;
        } else if (compound.func_74764_b(INV_NBT_KEY_ADD)) {
            invList = compound.func_150295_c(INV_NBT_KEY_ADD, 10);
            for (int i = 0; i < invList.size(); ++i) {
                CompoundNBT itemTag = invList.func_150305_b(i);
                this.inventory.add(ItemInTubeWrapper.readFromNBT(itemTag));
            }
        }
        if (compound.func_74764_b(CONNECTIONS)) {
            Map<Direction, RemoteConnection.Storage> rawMap = REMOTE_CONNECTIONS_CODEC.read(compound);
            HashMap<Direction, RemoteConnection> newMap = new HashMap<Direction, RemoteConnection>();
            rawMap.entrySet().forEach(entry -> newMap.put((Direction)entry.getKey(), RemoteConnection.fromStorage((RemoteConnection.Storage)entry.getValue(), (Direction)entry.getKey(), this.field_174879_c)));
            this.remoteConnections = newMap;
        }
        this.renderAABB = TubeTileEntity.getAABBContainingAllBlockPos(this.field_174879_c, this.remoteConnections.values().stream().map(connection -> connection.toPos).collect(Collectors.toSet()));
    }
}

