/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.client;

import com.github.commoble.tubesreloaded.TubesReloaded;
import com.github.commoble.tubesreloaded.blocks.filter.FilterTileEntity;
import com.github.commoble.tubesreloaded.blocks.filter.OsmosisFilterBlock;
import com.github.commoble.tubesreloaded.blocks.filter.OsmosisSlimeBlock;
import com.github.commoble.tubesreloaded.client.FilterTileEntityRenderer;
import com.github.commoble.tubesreloaded.registry.BlockRegistrar;
import com.github.commoble.tubesreloaded.registry.ItemRegistrar;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class OsmosisFilterTileEntityRenderer
extends FilterTileEntityRenderer {
    public final ItemStack SLIME_STACK = new ItemStack((IItemProvider)ItemRegistrar.OSMOSIS_SLIME);

    public OsmosisFilterTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
    }

    @Override
    public void render(FilterTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA, int intB) {
        this.renderSlime(te, partialTicks, matrix, buffer, intA, intB);
        super.render(te, partialTicks, matrix, buffer, intA, intB);
    }

    private void renderSlime(FilterTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA, int intB) {
        BlockPos blockpos = te.func_174877_v();
        BlockState filterState = te.func_195044_w();
        Direction dir = (Direction)filterState.func_177229_b((Property)OsmosisFilterBlock.FACING);
        BlockState renderState = (BlockState)BlockRegistrar.OSMOSIS_SLIME.func_176223_P().func_206870_a((Property)OsmosisSlimeBlock.field_176387_N, (Comparable)dir);
        long transferhash = blockpos.hashCode();
        int rate = TubesReloaded.serverConfig.osmosis_filter_transfer_rate.get();
        double ticks = (float)(te.func_145831_w().func_82737_E() + transferhash) + partialTicks;
        double minScale = 0.25;
        double lengthScale = minScale + ((Boolean)te.func_195044_w().func_177229_b((Property)OsmosisFilterBlock.TRANSFERRING_ITEMS) != false ? (-Math.cos(Math.PI * 2 * ticks / (double)rate) + 1.0) * 0.25 : 0.0);
        double lengthTranslateFactor = 1.0 - lengthScale;
        double zFightFix = 0.9999;
        int dirOffsetX = dir.func_82601_c();
        int dirOffsetY = dir.func_96559_d();
        int dirOffsetZ = dir.func_82599_e();
        float scaleX = (float)(dirOffsetX == 0 ? zFightFix : lengthScale);
        float scaleY = (float)(dirOffsetY == 0 ? zFightFix : lengthScale);
        float scaleZ = (float)(dirOffsetZ == 0 ? zFightFix : lengthScale);
        boolean translateFactorX = dirOffsetX != 0;
        boolean translateFactorY = dirOffsetY != 0;
        boolean translateFactorZ = dirOffsetZ != 0;
        double tX = dirOffsetX > 0 ? 1.0 : 0.0;
        double tY = dirOffsetY > 0 ? 1.0 : 0.0;
        double tZ = dirOffsetZ > 0 ? 1.0 : 0.0;
        double translateX = (double)translateFactorX * (tX * lengthTranslateFactor - 0.125 * (double)dirOffsetX);
        double translateY = (double)translateFactorY * (tY * lengthTranslateFactor - 0.125 * (double)dirOffsetY);
        double translateZ = (double)translateFactorZ * (tZ * lengthTranslateFactor - 0.125 * (double)dirOffsetZ);
        matrix.func_227860_a_();
        matrix.func_227861_a_(translateX, translateY, translateZ);
        matrix.func_227862_a_(scaleX, scaleY, scaleZ);
        RenderType renderType = RenderTypeLookup.func_239221_b_((BlockState)renderState);
        ForgeHooksClient.setRenderLayer((RenderType)renderType);
        BlockRendererDispatcher blockDispatcher = Minecraft.func_71410_x().func_175602_ab();
        World world = te.func_145831_w();
        blockDispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, blockDispatcher.func_184389_a(renderState), renderState, blockpos, matrix, buffer.getBuffer(renderType), false, world.field_73012_v, renderState.func_209533_a(blockpos), OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
        matrix.func_227865_b_();
    }
}

