/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.event;

import com.github.commoble.tubesreloaded.blocks.tube.TubeTileEntity;
import com.github.commoble.tubesreloaded.blocks.tube.TubesInChunk;
import com.github.commoble.tubesreloaded.blocks.tube.TubesInChunkCapability;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tubesreloaded", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonForgeEvents {
    @SubscribeEvent
    public static void onAttachChunkCapabilities(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(new ResourceLocation("tubesreloaded", "tubes_in_chunk"), (ICapabilityProvider)new TubesInChunk());
    }

    @SubscribeEvent
    public static void onEntityPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos = event.getPos();
        IWorld iworld = event.getWorld();
        BlockState state = event.getState();
        if (iworld instanceof World && !iworld.func_201670_d()) {
            World world = (World)iworld;
            Set<ChunkPos> chunkPositions = TubesInChunk.getRelevantChunkPositionsNearPos(pos);
            for (ChunkPos chunkPos : chunkPositions) {
                if (!world.func_175667_e(chunkPos.func_206849_h())) continue;
                Chunk chunk = world.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
                chunk.getCapability(TubesInChunkCapability.INSTANCE).ifPresent(tubes -> {
                    HashSet<BlockPos> checkedTubePositions = new HashSet<BlockPos>();
                    for (BlockPos tubePos : tubes.getPositions()) {
                        TileEntity te = world.func_175625_s(tubePos);
                        if (!(te instanceof TubeTileEntity)) continue;
                        Vector3d hit = ((TubeTileEntity)te).doesBlockStateIntersectConnection(pos, state, checkedTubePositions);
                        if (hit != null) {
                            event.setCanceled(true);
                            Entity entity = event.getEntity();
                            if (entity instanceof ServerPlayerEntity) {
                                ServerPlayerEntity serverPlayer = (ServerPlayerEntity)entity;
                                serverPlayer.field_71135_a.func_147359_a((IPacket)new SEntityEquipmentPacket(serverPlayer.func_145782_y(), (List)ImmutableList.of((Object)Pair.of((Object)EquipmentSlotType.MAINHAND, (Object)serverPlayer.func_184586_b(Hand.MAIN_HAND)))));
                                ((ServerWorld)world).func_195600_a(serverPlayer, (IParticleData)RedstoneParticleData.field_197564_a, false, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 5, 0.05, 0.05, 0.05, 0.0);
                                serverPlayer.func_213823_a(SoundEvents.field_219713_mY, SoundCategory.BLOCKS, 0.5f, 2.0f);
                            }
                            return;
                        }
                        checkedTubePositions.add(tubePos);
                    }
                });
            }
        }
    }
}

