/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.network;

import com.github.commoble.tubesreloaded.client.ClientPacketHandlers;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class TubeBreakPacket {
    public final Vector3d start;
    public final Vector3d end;

    public TubeBreakPacket(Vector3d start, Vector3d end) {
        this.start = start;
        this.end = end;
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("startX", this.start.field_72450_a);
        nbt.func_74780_a("startY", this.start.field_72448_b);
        nbt.func_74780_a("startZ", this.start.field_72449_c);
        nbt.func_74780_a("endX", this.end.field_72450_a);
        nbt.func_74780_a("endY", this.end.field_72448_b);
        nbt.func_74780_a("endZ", this.end.field_72449_c);
        buffer.func_150786_a(nbt);
    }

    public static TubeBreakPacket read(PacketBuffer buffer) {
        CompoundNBT nbt = buffer.func_150793_b();
        if (nbt == null) {
            return new TubeBreakPacket(Vector3d.field_186680_a, Vector3d.field_186680_a);
        }
        Vector3d start = new Vector3d(nbt.func_74769_h("startX"), nbt.func_74769_h("startY"), nbt.func_74769_h("startZ"));
        Vector3d end = new Vector3d(nbt.func_74769_h("endX"), nbt.func_74769_h("endY"), nbt.func_74769_h("endZ"));
        return new TubeBreakPacket(start, end);
    }

    public void handle(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        context.enqueueWork(() -> ClientPacketHandlers.onWireBreakPacket(context, this));
        context.setPacketHandled(true);
    }
}

