/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class DirectionTransformer {
    public static final Map<Direction, Direction[]> ORTHAGONALS = Maps.toMap((Iterable)Lists.newArrayList((Object[])Direction.values()), dir -> EnumSet.complementOf(EnumSet.of(dir, dir.func_176734_d())).toArray(new Direction[4]));
    public static final Direction D = Direction.DOWN;
    public static final Direction U = Direction.UP;
    public static final Direction N = Direction.NORTH;
    public static final Direction S = Direction.SOUTH;
    public static final Direction W = Direction.WEST;
    public static final Direction E = Direction.EAST;
    public static final Direction[] SAMES = new Direction[]{D, U, N, S, W, E};
    public static final Direction[] OPPOSITES = new Direction[]{U, D, S, N, E, W};
    public static final Direction[] ROTATE_X_DNUS = new Direction[]{N, S, U, D, W, E};
    public static final Direction[] ROTATE_X_DSUN = new Direction[]{S, N, D, U, W, E};
    public static final Direction[] ROTATE_Y_NESW = new Direction[]{D, U, E, W, N, S};
    public static final Direction[] ROTATE_Y_NWSE = new Direction[]{D, U, W, E, S, N};
    public static final Direction[] ROTATE_Z_DWUE = new Direction[]{W, E, N, S, U, D};
    public static final Direction[] ROTATE_Z_DEUW = new Direction[]{E, W, N, S, D, U};
    public static final Direction.Axis[][] ORTHAGONAL_AXES = new Direction.Axis[][]{{Direction.Axis.Y, Direction.Axis.X}, {Direction.Axis.X, Direction.Axis.Z}, {Direction.Axis.Y, Direction.Axis.Z}};
    public static final Direction[][] ORTHAGONAL_ROTATION_TABLE = new Direction[][]{{N, E, S, W}, {S, E, N, W}, {U, E, D, W}, {D, E, U, W}, {D, S, U, N}, {U, S, D, N}};
    public static final Direction[][][] ROTATION_TABLE = new Direction[][][]{{SAMES, OPPOSITES, ROTATE_X_DNUS, ROTATE_X_DSUN, ROTATE_Z_DWUE, ROTATE_Z_DEUW}, {OPPOSITES, SAMES, ROTATE_X_DSUN, ROTATE_X_DNUS, ROTATE_Z_DEUW, ROTATE_Z_DWUE}, {ROTATE_X_DSUN, ROTATE_X_DNUS, SAMES, OPPOSITES, ROTATE_Y_NWSE, ROTATE_Y_NESW}, {ROTATE_X_DNUS, ROTATE_X_DSUN, OPPOSITES, SAMES, ROTATE_Y_NESW, ROTATE_Y_NWSE}, {ROTATE_Z_DEUW, ROTATE_Z_DWUE, ROTATE_Y_NESW, ROTATE_Y_NWSE, SAMES, OPPOSITES}, {ROTATE_Z_DWUE, ROTATE_Z_DEUW, ROTATE_Y_NWSE, ROTATE_Y_NESW, OPPOSITES, SAMES}};

    public static Direction getRotatedDirection(Direction from, Direction to, Direction toRotate) {
        return ROTATION_TABLE[from.ordinal()][to.ordinal()][toRotate.ordinal()];
    }

    public static Vector3d[][] getVertexPairs(Direction startSide, Direction endSide) {
        Vector3i startSideVec = startSide.func_176730_m();
        Vector3i endSideVec = endSide.func_176730_m();
        Direction[] startEdgeDirections = ORTHAGONAL_ROTATION_TABLE[startSide.ordinal()];
        double tubeSideOffset = 0.25;
        double tubeEdgeOffset = 0.125;
        double tubeCornerOffset = 0.125;
        Vector3d[][] result = new Vector3d[4][2];
        for (int i = 0; i < 4; ++i) {
            Direction firstOrthagonal = startEdgeDirections[i];
            Vector3i firstOrthagonalSideVec = firstOrthagonal.func_176730_m();
            Direction secondOrthagonal = startEdgeDirections[(i + 1) % 4];
            Vector3i secondOrthagonalSideVec = secondOrthagonal.func_176730_m();
            result[i][0] = DirectionTransformer.getVertexOffset(startSideVec, firstOrthagonalSideVec, secondOrthagonalSideVec, tubeSideOffset, tubeEdgeOffset, tubeCornerOffset);
            if (endSide == startSide.func_176734_d()) {
                result[i][1] = DirectionTransformer.getVertexOffset(endSideVec, firstOrthagonalSideVec, secondOrthagonalSideVec, tubeSideOffset, tubeEdgeOffset, tubeCornerOffset);
                continue;
            }
            Direction firstEndOrthagonal = DirectionTransformer.getRotatedDirection(endSide, startSide, firstOrthagonal);
            Direction secondEndOrthagonal = DirectionTransformer.getRotatedDirection(endSide, startSide, secondOrthagonal);
            Vector3i firstEndSideVec = firstEndOrthagonal.func_176730_m();
            Vector3i secondEndSideVec = secondEndOrthagonal.func_176730_m();
            result[i][1] = DirectionTransformer.getVertexOffset(endSideVec, firstEndSideVec, secondEndSideVec, tubeSideOffset, tubeEdgeOffset, tubeCornerOffset);
        }
        return result;
    }

    public static Vector3d getVertexOffset(Vector3i sideVec, Vector3i orthagonalA, Vector3i orthagonalB, double side, double edge, double corner) {
        return new Vector3d((double)sideVec.func_177958_n() * side + (double)orthagonalA.func_177958_n() * edge + (double)orthagonalB.func_177958_n() * corner, (double)sideVec.func_177956_o() * side + (double)orthagonalA.func_177956_o() * edge + (double)orthagonalB.func_177956_o() * corner, (double)sideVec.func_177952_p() * side + (double)orthagonalA.func_177952_p() * edge + (double)orthagonalB.func_177952_p() * corner);
    }
}

