/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class NBTListHelper<T> {
    private final String name;
    private final Function<T, CompoundNBT> elementWriter;
    private final Function<CompoundNBT, T> elementReader;

    public NBTListHelper(String name, Function<T, CompoundNBT> elementWriter, Function<CompoundNBT, T> elementReader) {
        this.name = name;
        this.elementWriter = elementWriter;
        this.elementReader = elementReader;
    }

    public List<T> read(CompoundNBT compound) {
        ArrayList newList = new ArrayList();
        ListNBT listNBT = compound.func_150295_c(this.name, 10);
        if (listNBT == null) {
            return newList;
        }
        int listSize = listNBT.size();
        if (listSize <= 0) {
            return newList;
        }
        IntStream.range(0, listSize).mapToObj(i -> listNBT.func_150305_b(i)).forEach(nbt -> newList.add(this.elementReader.apply((CompoundNBT)nbt)));
        return newList;
    }

    public CompoundNBT write(List<T> list, CompoundNBT compound) {
        ListNBT nbtList = new ListNBT();
        list.forEach(element -> nbtList.add((Object)this.elementWriter.apply(element)));
        compound.func_218657_a(this.name, (INBT)nbtList);
        return compound;
    }
}

