/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.util;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.util.math.AxisAlignedBB;

public class NestedBoundingBox {
    @Nonnull
    private final List<NestedBoundingBox> subBoxes;
    @Nonnull
    private final AxisAlignedBB superBox;
    private static final AxisAlignedBB EMPTY_AABB = new AxisAlignedBB(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);

    public NestedBoundingBox(@Nonnull NestedBoundingBox boxA, @Nonnull NestedBoundingBox boxB) {
        this.subBoxes = Collections.unmodifiableList(Lists.newArrayList((Object[])new NestedBoundingBox[]{boxA, boxB}));
        this.superBox = boxA.superBox.func_111270_a(boxB.superBox);
    }

    public NestedBoundingBox(@Nonnull AxisAlignedBB box) {
        this.subBoxes = Collections.emptyList();
        this.superBox = box;
    }

    public NestedBoundingBox combine(@Nonnull NestedBoundingBox other) {
        return new NestedBoundingBox(this, other);
    }

    public static NestedBoundingBox fromAABBs(AxisAlignedBB ... boxes) {
        return NestedBoundingBox.fromAABBs(0, boxes.length - 1, boxes);
    }

    private static NestedBoundingBox fromAABBs(int fromIndex, int toIndex, AxisAlignedBB ... boxes) {
        int size = toIndex - fromIndex + 1;
        if (size <= 0) {
            return new NestedBoundingBox(EMPTY_AABB);
        }
        if (size == 1) {
            return new NestedBoundingBox(boxes[toIndex]);
        }
        int partition = (fromIndex + toIndex) / 2;
        return new NestedBoundingBox(NestedBoundingBox.fromAABBs(fromIndex, partition, boxes), NestedBoundingBox.fromAABBs(partition + 1, toIndex, boxes));
    }

    public boolean intersects(@Nonnull AxisAlignedBB target) {
        return new IntersectionPredicate(target).test(this);
    }

    private static class IntersectionPredicate
    implements Predicate<NestedBoundingBox> {
        private final AxisAlignedBB target;

        public IntersectionPredicate(AxisAlignedBB target) {
            this.target = target;
        }

        @Override
        public boolean test(NestedBoundingBox box) {
            if (!box.superBox.func_72326_a(this.target)) {
                return false;
            }
            if (box.subBoxes.isEmpty()) {
                return true;
            }
            return box.subBoxes.parallelStream().anyMatch(this);
        }
    }
}

