/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.filter;

import com.github.commoble.tubesreloaded.blocks.filter.FilterShuntingItemHandler;
import com.github.commoble.tubesreloaded.blocks.filter.FilterStorageItemHandler;
import com.github.commoble.tubesreloaded.blocks.shunt.ShuntBlock;
import com.github.commoble.tubesreloaded.registry.TileEntityRegistrar;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FilterTileEntity
extends TileEntity {
    public static final String INV_KEY = "inventory";
    public ItemStack filterStack = ItemStack.field_190927_a;
    public FilterShuntingItemHandler shuntingHandler = new FilterShuntingItemHandler(this);
    public FilterStorageItemHandler storageHandler = new FilterStorageItemHandler(this);
    private LazyOptional<IItemHandler> shuntingOptional = LazyOptional.of(() -> this.shuntingHandler);
    private LazyOptional<IItemHandler> storageOptional = LazyOptional.of(() -> this.storageHandler);

    public FilterTileEntity(TileEntityType<?> teType) {
        super(teType);
    }

    public FilterTileEntity() {
        this(TileEntityRegistrar.FILTER);
    }

    public void func_145843_s() {
        this.shuntingOptional.invalidate();
        this.storageOptional.invalidate();
        super.func_145843_s();
    }

    public boolean canItemPassThroughFilter(ItemStack stack) {
        if (stack.func_190916_E() <= 0) {
            return false;
        }
        if (this.filterStack.func_190916_E() <= 0) {
            return true;
        }
        return this.filterStack.func_77973_b().equals(stack.func_77973_b());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Direction output_dir = (Direction)this.func_195044_w().func_177229_b((Property)ShuntBlock.FACING);
            if (side == output_dir.func_176734_d()) {
                return this.shuntingOptional.cast();
            }
            if (side != output_dir) {
                return this.storageOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public boolean onActivated(PlayerEntity player, Direction sideOfBlock, ItemStack stackInHand) {
        if (stackInHand.func_190916_E() <= 0) {
            if (!this.field_145850_b.field_72995_K) {
                ItemStack filtered = this.filterStack.func_77946_l();
                this.setFilterStackAndSaveAndSync(stackInHand.func_77979_a(1));
                player.func_191521_c(filtered);
            }
            return true;
        }
        if (stackInHand.func_77973_b().equals(this.filterStack.func_77973_b())) {
            if (!this.field_145850_b.field_72995_K) {
                ItemStack filtered = this.filterStack.func_77946_l();
                this.setFilterStackAndSaveAndSync(ItemStack.field_190927_a);
                if (!player.func_191521_c(filtered)) {
                    WorldHelper.ejectItemstack(this.field_145850_b, this.field_174879_c, sideOfBlock, filtered);
                }
            }
            return true;
        }
        if (this.filterStack.func_190916_E() <= 0) {
            if (!this.field_145850_b.field_72995_K) {
                this.setFilterStackAndSaveAndSync(stackInHand.func_77979_a(1));
            }
            return true;
        }
        return false;
    }

    public void setFilterStackAndSaveAndSync(ItemStack filterStack) {
        this.filterStack = filterStack;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public void dropItems() {
        InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.filterStack);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readNBT(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT inventory = new CompoundNBT();
        this.filterStack.func_77955_b(inventory);
        compound.func_218657_a(INV_KEY, (INBT)inventory);
        return super.func_189515_b(compound);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.readNBT(packet.func_148857_g());
    }

    public void readNBT(CompoundNBT nbt) {
        CompoundNBT inventory = nbt.func_74775_l(INV_KEY);
        this.filterStack = ItemStack.func_199557_a((CompoundNBT)inventory);
    }
}

