/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.filter;

import com.github.commoble.tubesreloaded.blocks.filter.FilterBlock;
import com.github.commoble.tubesreloaded.blocks.filter.OsmosisFilterTileEntity;
import com.github.commoble.tubesreloaded.registry.TileEntityRegistrar;
import com.github.commoble.tubesreloaded.util.ClassHelper;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class OsmosisFilterBlock
extends FilterBlock {
    public static final BooleanProperty TRANSFERRING_ITEMS = BlockStateProperties.field_208180_g;

    public OsmosisFilterBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, TRANSFERRING_ITEMS});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityRegistrar.OSMOSIS_FILTER.func_200968_a();
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c()) {
            this.updateState(worldIn, pos, state);
        }
    }

    private void updateState(World world, BlockPos pos, BlockState state) {
        if (!world.field_72995_K) {
            boolean hasRedstoneSignal = world.func_175640_z(pos);
            boolean active = (Boolean)state.func_177229_b((Property)TRANSFERRING_ITEMS);
            Direction outputDirection = (Direction)state.func_177229_b((Property)FACING);
            Direction inputDirection = outputDirection.func_176734_d();
            Optional<OsmosisFilterTileEntity> maybeFilter = WorldHelper.getTileEntityAt(OsmosisFilterTileEntity.class, (IWorldReader)world, pos);
            boolean checkedItemsThisTick = maybeFilter.map(OsmosisFilterTileEntity::getCheckedItemsAndMarkChecked).orElse(true);
            if (!checkedItemsThisTick) {
                boolean canExtractItems = maybeFilter.filter(filter -> WorldHelper.getTileEntityAt(world, pos.func_177972_a(inputDirection)).filter(te -> te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputDirection).filter(handler -> WorldHelper.doesItemHandlerHaveAnyExtractableItems(handler, filter::canItemPassThroughFilter)).isPresent()).isPresent()).isPresent();
                if (active && (hasRedstoneSignal || !canExtractItems)) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(false)), 6);
                } else if (!active && !hasRedstoneSignal && canExtractItems) {
                    world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(true)), 6);
                }
            }
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ActionResultType result = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        this.updateState(worldIn, pos, state);
        return result;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.updateState(worldIn, pos, state);
    }

    public void onNeighborChange(BlockState state, IWorldReader worldReader, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, worldReader, pos, neighbor);
        ClassHelper.as(worldReader, World.class).ifPresent(world -> this.updateState((World)world, pos, state));
    }
}

