/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.shunt;

import com.github.commoble.tubesreloaded.blocks.shunt.ShuntBlock;
import com.github.commoble.tubesreloaded.blocks.shunt.ShuntTileEntity;
import com.github.commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ShuntItemHandler
implements IItemHandler {
    public final ShuntTileEntity shunt;
    public final boolean can_take_items;

    public ShuntItemHandler(ShuntTileEntity shunt, boolean can_take_items) {
        this.shunt = shunt;
        this.can_take_items = can_take_items;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Direction output_dir;
        BlockPos shunt_pos;
        BlockPos output_pos;
        ItemStack remaining;
        if (!this.can_take_items) {
            return stack.func_77946_l();
        }
        if (!simulate && (remaining = (ItemStack)this.getOutputOptional(output_pos = (shunt_pos = this.shunt.func_174877_v()).func_177972_a(output_dir = (Direction)this.shunt.func_195044_w().func_177229_b((Property)ShuntBlock.FACING)), output_dir).map(handler -> WorldHelper.disperseItemToHandler(stack, handler)).orElse((Object)stack.func_77946_l())).func_190916_E() > 0) {
            WorldHelper.ejectItemstack(this.shunt.func_145831_w(), shunt_pos, output_dir, remaining);
        }
        return ItemStack.field_190927_a;
    }

    private LazyOptional<IItemHandler> getOutputOptional(BlockPos output_pos, Direction output_dir) {
        ITag shuntTag = BlockTags.func_199896_a().func_199910_a(new ResourceLocation("tubesreloaded", "shunts"));
        return WorldHelper.getTEItemHandlerAtIf(this.shunt.func_145831_w(), output_pos, output_dir.func_176734_d(), te -> !shuntTag.func_230235_a_((Object)te.func_195044_w().func_177230_c()));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        World world = this.shunt.func_145831_w();
        BlockPos pos = this.shunt.func_174877_v();
        return this.can_take_items && !world.func_175640_z(pos);
    }
}

