/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.tube;

import com.github.commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import com.github.commoble.tubesreloaded.blocks.tube.TubeTileEntity;
import com.github.commoble.tubesreloaded.util.NestedBoundingBox;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;

public class RemoteConnection {
    public final Direction toSide;
    public final BlockPos toPos;
    public final boolean isPrimary;
    public NestedBoundingBox box;

    public RemoteConnection(Direction fromSide, Direction toSide, BlockPos fromPos, BlockPos toPos, boolean isPrimary) {
        this.toSide = toSide;
        this.toPos = toPos;
        this.isPrimary = isPrimary;
        this.box = RemoteConnection.getNestedBoundingBoxForConnectedPos(fromPos, toPos);
    }

    public Storage toStorage() {
        return new Storage(this.toSide, this.toPos, this.isPrimary);
    }

    public static RemoteConnection fromStorage(Storage storage, Direction fromSide, BlockPos fromPos) {
        return new RemoteConnection(fromSide, storage.toSide, fromPos, storage.toPos, storage.isPrimary);
    }

    private static NestedBoundingBox getNestedBoundingBoxForConnectedPos(BlockPos from, BlockPos to) {
        Vector3d thisVec = TubeTileEntity.getCenter(from);
        Vector3d otherVec = TubeTileEntity.getCenter(to);
        boolean otherHigher = otherVec.field_72448_b > thisVec.field_72448_b;
        Vector3d higherVec = otherHigher ? otherVec : thisVec;
        Vector3d lowerVec = otherHigher ? thisVec : otherVec;
        Vector3d[] points = RaytraceHelper.getInterpolatedPoints(lowerVec, higherVec);
        int segmentCount = points.length - 1;
        AxisAlignedBB[] boxes = new AxisAlignedBB[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            boxes[i] = new AxisAlignedBB(points[i], points[i + 1]);
        }
        return NestedBoundingBox.fromAABBs(boxes);
    }

    public static class Storage {
        public final Direction toSide;
        public final BlockPos toPos;
        public final boolean isPrimary;

        public Storage(Direction toSide, BlockPos toPos, boolean isPrimary) {
            this.toSide = toSide;
            this.toPos = toPos;
            this.isPrimary = isPrimary;
        }

        public static Storage fromNBT(CompoundNBT nbt) {
            Direction toSide = Direction.func_82600_a((int)nbt.func_74762_e("toSide"));
            BlockPos toPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("toPos"));
            boolean isPrimary = nbt.func_74767_n("isPrimary");
            return new Storage(toSide, toPos, isPrimary);
        }

        public CompoundNBT toNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a("toSide", this.toSide.ordinal());
            nbt.func_218657_a("toPos", (INBT)NBTUtil.func_186859_a((BlockPos)this.toPos));
            nbt.func_74757_a("isPrimary", this.isPrimary);
            return nbt;
        }
    }
}

