/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.tube;

import com.github.commoble.tubesreloaded.TubesReloaded;
import com.github.commoble.tubesreloaded.blocks.tube.ITubesInChunk;
import com.github.commoble.tubesreloaded.blocks.tube.TubesInChunkCapability;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class TubesInChunk
implements ITubesInChunk,
ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    private final LazyOptional<ITubesInChunk> holder = LazyOptional.of(() -> this);
    private Set<BlockPos> positions = new HashSet<BlockPos>();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == TubesInChunkCapability.INSTANCE) {
            return TubesInChunkCapability.INSTANCE.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    @Override
    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    @Override
    public void setPositions(Set<BlockPos> set) {
        this.positions = set;
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)TubesInChunkCapability.INSTANCE.getStorage().writeNBT(TubesInChunkCapability.INSTANCE, (Object)this, null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        TubesInChunkCapability.INSTANCE.getStorage().readNBT(TubesInChunkCapability.INSTANCE, (Object)this, null, (INBT)nbt);
    }

    public static Set<ChunkPos> getRelevantChunkPositionsNearPos(BlockPos pos) {
        double range = TubesReloaded.serverConfig.max_remote_tube_connection_range.get();
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkRange = (int)Math.ceil(range / 16.0);
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        for (int xOff = -chunkRange; xOff <= chunkRange; ++xOff) {
            for (int zOff = -chunkRange; zOff <= chunkRange; ++zOff) {
                set.add(new ChunkPos(chunkPos.field_77276_a + xOff, chunkPos.field_77275_b + zOff));
            }
        }
        return set;
    }
}

