/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.blocks.tube;

import com.github.commoble.tubesreloaded.TubesReloaded;
import com.github.commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import com.github.commoble.tubesreloaded.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.blocks.tube.TubeTileEntity;
import com.github.commoble.tubesreloaded.network.PacketHandler;
import com.github.commoble.tubesreloaded.network.TubeBreakPacket;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class TubingPliersItem
extends Item {
    public static final String LAST_TUBE_DATA = "last_tube_data";
    public static final String LAST_TUBE_POS = "last_tube_pos";
    public static final String LAST_TUBE_SIDE = "last_tube_side";

    public TubingPliersItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        return TubeTileEntity.getTubeTEAt((IWorld)world, pos).map(tube -> this.onUseOnTube(world, pos, (TubeTileEntity)((Object)tube), context.func_195996_i(), context.func_195999_j(), context.func_196000_l())).orElseGet(() -> super.func_195939_a(context));
    }

    private ActionResultType onUseOnTube(World world, BlockPos pos, @Nonnull TubeTileEntity tube, ItemStack stack, PlayerEntity player, Direction activatedSide) {
        if (!world.field_72995_K) {
            CompoundNBT nbt = stack.func_179543_a(LAST_TUBE_DATA);
            BlockState state = world.func_180495_p(pos);
            if (nbt == null) {
                if (state.func_177230_c() instanceof TubeBlock && !((Boolean)state.func_177229_b((Property)SixWayBlock.field_196491_B.get(activatedSide))).booleanValue()) {
                    CompoundNBT newNBT = new CompoundNBT();
                    newNBT.func_218657_a(LAST_TUBE_POS, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                    newNBT.func_74768_a(LAST_TUBE_SIDE, activatedSide.ordinal());
                    stack.func_77983_a(LAST_TUBE_DATA, (INBT)newNBT);
                }
            } else {
                BlockPos lastPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l(LAST_TUBE_POS));
                Direction lastSide = Direction.func_82600_a((int)nbt.func_74762_e(LAST_TUBE_SIDE));
                if (lastPos.equals((Object)pos)) {
                    stack.func_196083_e(LAST_TUBE_DATA);
                } else if (tube.hasRemoteConnection(lastPos)) {
                    TubeTileEntity.removeConnection((IWorld)world, pos, lastPos);
                    stack.func_196083_e(LAST_TUBE_DATA);
                } else {
                    if (tube.hasRemoteConnection(activatedSide)) {
                        stack.func_196083_e(LAST_TUBE_DATA);
                        if (player instanceof ServerPlayerEntity && world instanceof ServerWorld) {
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new TubeBreakPacket(Vector3d.func_237489_a_((Vector3i)lastPos), Vector3d.func_237489_a_((Vector3i)pos)));
                            ((ServerPlayerEntity)player).func_213823_a(SoundEvents.field_219713_mY, SoundCategory.BLOCKS, 0.5f, 2.0f);
                        }
                        return ActionResultType.SUCCESS;
                    }
                    Vector3d startVec = RaytraceHelper.getTubeSideCenter(lastPos, lastSide);
                    Vector3d endVec = RaytraceHelper.getTubeSideCenter(pos, activatedSide);
                    Vector3d hit = RaytraceHelper.getTubeRaytraceHit(startVec, endVec, world);
                    BlockState lastState = world.func_180495_p(lastPos);
                    if (hit != null) {
                        stack.func_196083_e(LAST_TUBE_DATA);
                        if (player instanceof ServerPlayerEntity && world instanceof ServerWorld) {
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new TubeBreakPacket(startVec, endVec));
                            ((ServerWorld)world).func_195600_a((ServerPlayerEntity)player, (IParticleData)RedstoneParticleData.field_197564_a, false, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 5, 0.05, 0.05, 0.05, 0.0);
                            ((ServerPlayerEntity)player).func_213823_a(SoundEvents.field_219713_mY, SoundCategory.BLOCKS, 0.5f, 2.0f);
                        }
                    } else if (activatedSide == lastSide) {
                        stack.func_196083_e(LAST_TUBE_DATA);
                        if (player instanceof ServerPlayerEntity && world instanceof ServerWorld) {
                            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new TubeBreakPacket(startVec, endVec));
                            ((ServerWorld)world).func_195600_a((ServerPlayerEntity)player, (IParticleData)RedstoneParticleData.field_197564_a, false, endVec.field_72450_a, endVec.field_72448_b, endVec.field_72449_c, 5, 0.05, 0.05, 0.05, 0.0);
                            ((ServerPlayerEntity)player).func_213823_a(SoundEvents.field_219713_mY, SoundCategory.BLOCKS, 0.5f, 2.0f);
                        }
                    } else if (state.func_177230_c() instanceof TubeBlock && !((Boolean)state.func_177229_b((Property)SixWayBlock.field_196491_B.get(activatedSide))).booleanValue()) {
                        if (pos.func_218141_a((Vector3i)lastPos, TubesReloaded.serverConfig.max_remote_tube_connection_range.get().doubleValue()) && lastState.func_177230_c() instanceof TubeBlock && !((Boolean)lastState.func_177229_b((Property)SixWayBlock.field_196491_B.get(lastSide))).booleanValue()) {
                            stack.func_196083_e(LAST_TUBE_DATA);
                            TubeTileEntity.getTubeTEAt((IWorld)world, lastPos).ifPresent(lastPost -> {
                                BlockPos originalConnection = lastPost.getConnectedPos(lastSide);
                                if (originalConnection != null) {
                                    TubeTileEntity.removeConnection((IWorld)world, lastPos, originalConnection);
                                }
                                TubeTileEntity.addConnection((IWorld)world, lastPost, lastSide, tube, activatedSide);
                            });
                            stack.func_222118_a(1, (LivingEntity)player, thePlayer -> thePlayer.func_213361_c(EquipmentSlotType.MAINHAND));
                        } else {
                            stack.func_77983_a(LAST_TUBE_DATA, (INBT)NBTUtil.func_186859_a((BlockPos)pos));
                        }
                    }
                }
            }
            world.func_184133_a(null, pos, SoundEvents.field_187692_g, SoundCategory.BLOCKS, 0.1f + world.field_73012_v.nextFloat() * 0.1f, 0.7f + world.field_73012_v.nextFloat() * 0.1f);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K) {
            Optional.ofNullable(stack.func_179543_a(LAST_TUBE_DATA)).map(nbt -> NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l(LAST_TUBE_POS))).filter(pos -> TubingPliersItem.shouldRemoveConnection(pos, worldIn, entityIn)).ifPresent(pos -> TubingPliersItem.breakPendingConnection(stack, pos, entityIn, worldIn));
        }
    }

    public static boolean shouldRemoveConnection(BlockPos connectionPos, World world, Entity holder) {
        double maxDistance = TubesReloaded.serverConfig.max_remote_tube_connection_range.get();
        if (holder.func_213303_ch().func_72436_e(Vector3d.func_237489_a_((Vector3i)connectionPos)) > maxDistance * maxDistance) {
            return true;
        }
        TileEntity te = world.func_175625_s(connectionPos);
        return !(te instanceof TubeTileEntity);
    }

    public static void breakPendingConnection(ItemStack stack, BlockPos connectingPos, Entity holder, World world) {
        stack.func_196083_e(LAST_TUBE_DATA);
        if (holder instanceof ServerPlayerEntity) {
            PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)holder), (Object)new TubeBreakPacket(TubeTileEntity.getCenter(connectingPos), new Vector3d(holder.func_226277_ct_(), holder.func_226280_cw_(), holder.func_226281_cx_())));
        }
    }
}

