/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.client;

import com.github.commoble.tubesreloaded.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.util.DirectionTransformer;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

public class TubeQuadRenderer {
    public static void renderQuads(World world, float partialTicks, BlockPos startPos, BlockPos endPos, Direction startFace, Direction endFace, MatrixStack matrix, IRenderTypeBuffer buffer, TubeBlock block) {
        TextureAtlasSprite textureatlassprite = new RenderMaterial(AtlasTexture.field_110575_b, block.textureLocation).func_229314_c_();
        Vector3d startVec = Vector3d.func_237491_b_((Vector3i)startPos);
        Vector3d endVec = Vector3d.func_237491_b_((Vector3i)endPos);
        Vector3d[][] vertices = DirectionTransformer.getVertexPairs(startFace, endFace);
        Vector3d offsetToEndPos = endVec.func_178788_d(startVec);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(Atlases.func_228783_h_());
        float totalMinU = textureatlassprite.func_94209_e();
        float totalMinV = textureatlassprite.func_94206_g();
        float totalMaxU = textureatlassprite.func_94212_f();
        float totalMaxV = textureatlassprite.func_94210_h();
        float texWidth = totalMaxU - totalMinU;
        float texHeight = totalMaxV - totalMinV;
        float tubeStartX = 0.375f * texWidth + totalMinU;
        float tubeStartY = totalMinV;
        float tubeWidth = 0.25f * texWidth;
        float tubeHeight = 0.25f * texHeight;
        float minU = tubeStartX;
        float minV = tubeStartY;
        float maxU = tubeStartX + tubeWidth;
        float maxV = tubeStartY + tubeHeight;
        int startLight = TubeQuadRenderer.getPackedLight(world, startPos);
        int endLight = TubeQuadRenderer.getPackedLight(world, endPos);
        for (int side = 0; side < 4; ++side) {
            matrix.func_227860_a_();
            int vertIndexA = side;
            int vertIndexB = (side + 1) % 4;
            Vector3d startVertexA = vertices[vertIndexA][0];
            Vector3d startVertexB = vertices[vertIndexB][0];
            Vector3d endVertexB = vertices[vertIndexB][1].func_178787_e(offsetToEndPos);
            Vector3d endVertexA = vertices[vertIndexA][1].func_178787_e(offsetToEndPos);
            float xA = (float)startVertexA.field_72450_a + 0.5f;
            float xB = (float)startVertexB.field_72450_a + 0.5f;
            float xC = (float)endVertexB.field_72450_a + 0.5f;
            float xD = (float)endVertexA.field_72450_a + 0.5f;
            float yA = (float)startVertexA.field_72448_b + 0.5f;
            float yB = (float)startVertexB.field_72448_b + 0.5f;
            float yC = (float)endVertexB.field_72448_b + 0.5f;
            float yD = (float)endVertexA.field_72448_b + 0.5f;
            float zA = (float)startVertexA.field_72449_c + 0.5f;
            float zB = (float)startVertexB.field_72449_c + 0.5f;
            float zC = (float)endVertexB.field_72449_c + 0.5f;
            float zD = (float)endVertexA.field_72449_c + 0.5f;
            MatrixStack.Entry matrixEntry = matrix.func_227866_c_();
            Vector3d normal = startVertexB.func_178788_d(startVertexA).func_72431_c(endVertexA.func_178788_d(startVertexA)).func_72432_b();
            Vector3d reverseNormal = normal.func_216372_d(-1.0, -1.0, -1.0);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xA, yA, zA, minU, maxV, startLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xB, yB, zB, maxU, maxV, startLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xC, yC, zC, maxU, minV, endLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xD, yD, zD, minU, minV, endLight, normal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xD, yD, zD, minU, minV, endLight, reverseNormal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xC, yC, zC, maxU, minV, endLight, reverseNormal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xB, yB, zB, maxU, maxV, startLight, reverseNormal);
            TubeQuadRenderer.putVertex(matrixEntry, ivertexbuilder, xA, yA, zA, minU, maxV, startLight, reverseNormal);
            matrix.func_227865_b_();
        }
    }

    private static void putVertex(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, float x, float y, float z, float texU, float texV, int packedLight, Vector3d normal) {
        bufferIn.func_227888_a_(matrixEntryIn.func_227870_a_(), x, y, z).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(texU, texV).func_225585_a_(0, 10).func_227886_a_(packedLight).func_227887_a_(matrixEntryIn.func_227872_b_(), (float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c).func_181675_d();
    }

    public static int getPackedLight(World world, BlockPos pos) {
        int blockLight = world.func_226658_a_(LightType.BLOCK, pos);
        int skyLight = world.func_226658_a_(LightType.SKY, pos);
        return LightTexture.func_228451_a_((int)blockLight, (int)skyLight);
    }
}

