/*
 * Decompiled with CFR 0.152.
 */
package com.github.commoble.tubesreloaded.client;

import com.github.commoble.tubesreloaded.blocks.tube.ItemInTubeWrapper;
import com.github.commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import com.github.commoble.tubesreloaded.blocks.tube.RemoteConnection;
import com.github.commoble.tubesreloaded.blocks.tube.TubeBlock;
import com.github.commoble.tubesreloaded.blocks.tube.TubeTileEntity;
import com.github.commoble.tubesreloaded.blocks.tube.TubingPliersItem;
import com.github.commoble.tubesreloaded.client.TubeQuadRenderer;
import com.github.commoble.tubesreloaded.util.DirectionTransformer;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TubeTileEntityRenderer
extends TileEntityRenderer<TubeTileEntity> {
    private final ModelRenderer field_228875_k_ = new ModelRenderer(32, 16, 0, 0);

    public TubeTileEntityRenderer(TileEntityRendererDispatcher p_i226006_1_) {
        super(p_i226006_1_);
        this.field_228875_k_.func_228300_a_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f);
    }

    public void render(TubeTileEntity tube, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (!tube.inventory.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.inventory) {
                this.renderWrapper(tube, wrapper, partialTicks, matrix, buffer, combinedLight);
            }
        }
        if (!tube.incoming_wrapper_buffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : tube.incoming_wrapper_buffer) {
                this.renderWrapper(tube, wrapper, partialTicks, matrix, buffer, combinedLight);
            }
        }
        this.renderLongTubes(tube, partialTicks, matrix, buffer, combinedLight, combinedOverlay);
    }

    protected int getModelCount(ItemStack stack) {
        int i = 1;
        if (stack.func_190916_E() > 48) {
            i = 5;
        } else if (stack.func_190916_E() > 32) {
            i = 4;
        } else if (stack.func_190916_E() > 16) {
            i = 3;
        } else if (stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }

    public void renderWrapper(TubeTileEntity tube, ItemInTubeWrapper wrapper, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int intA) {
        Vector3d renderOffset;
        Direction nextMove = wrapper.remainingMoves.peek();
        if (nextMove == null) {
            return;
        }
        ItemStack itemstack = wrapper.stack;
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        Random random = tube.func_145831_w().field_73012_v;
        Item item = itemstack.func_77973_b();
        int i = itemstack.func_190926_b() ? 187 : Item.func_150891_b((Item)item) + itemstack.func_77952_i();
        random.setSeed(i);
        matrix.func_227860_a_();
        int renderedItemCount = this.getModelCount(itemstack);
        float lerpFactor = ((float)wrapper.ticksElapsed + partialTicks) / (float)wrapper.maximumDurationInTube;
        float remoteScale = 1.0f;
        if (wrapper.freshlyInserted) {
            float xEnd = 0.0f;
            float yEnd = 0.0f;
            float zEnd = 0.0f;
            float xStart = xEnd - (float)nextMove.func_82601_c();
            float yStart = yEnd - (float)nextMove.func_96559_d();
            float zStart = zEnd - (float)nextMove.func_82599_e();
            float xLerp = MathHelper.func_219799_g((float)lerpFactor, (float)xStart, (float)xEnd);
            float yLerp = MathHelper.func_219799_g((float)lerpFactor, (float)yStart, (float)yEnd);
            float zLerp = MathHelper.func_219799_g((float)lerpFactor, (float)zStart, (float)zEnd);
            renderOffset = new Vector3d((double)xLerp, (double)yLerp, (double)zLerp);
        } else {
            renderOffset = TubeTileEntityRenderer.getItemRenderOffset(tube, nextMove, lerpFactor);
            remoteScale = (float)TubeTileEntityRenderer.getItemRenderScale(tube, nextMove, lerpFactor);
        }
        itemRenderer.field_77023_b -= 50.0f;
        for (int currentModelIndex = 0; currentModelIndex < renderedItemCount; ++currentModelIndex) {
            matrix.func_227860_a_();
            float xAdjustment = 0.0f;
            float yAdjustment = 0.0f;
            float zAdjustment = 0.0f;
            if (currentModelIndex > 0) {
                xAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                yAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
                zAdjustment = (random.nextFloat() * 2.0f - 1.0f) * 0.01f;
            }
            float xTranslate = (float)(renderOffset.field_72450_a + (double)xAdjustment + 0.5);
            float yTranslate = (float)(renderOffset.field_72448_b + (double)yAdjustment + 0.4375);
            float zTranslate = (float)(renderOffset.field_72449_c + (double)zAdjustment + 0.5);
            matrix.func_227861_a_((double)xTranslate, (double)yTranslate, (double)zTranslate);
            float scale = remoteScale * 0.5f;
            matrix.func_227862_a_(scale, scale, scale);
            itemRenderer.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.GROUND, intA, OverlayTexture.field_229196_a_, matrix, buffer);
            matrix.func_227865_b_();
        }
        itemRenderer.field_77023_b += 50.0f;
        matrix.func_227865_b_();
    }

    public static Vector3d getItemRenderOffset(TubeTileEntity tube, Direction travelDirection, float lerpFactor) {
        return tube.getRemoteConnection(travelDirection).map(connection -> TubeTileEntityRenderer.getRemoteItemRenderOffset(connection, travelDirection, tube.func_174877_v(), lerpFactor)).orElse(TubeTileEntityRenderer.getAdjacentRenderOffset(travelDirection, lerpFactor));
    }

    public static double getItemRenderScale(TubeTileEntity tube, Direction travelDirection, float lerpFactor) {
        return tube.getRemoteConnection(travelDirection).map(connection -> TubeTileEntityRenderer.getRemoteItemRenderScale(connection, travelDirection, tube.func_174877_v(), lerpFactor)).orElse(1.0);
    }

    public static Vector3d getRemoteItemRenderOffset(RemoteConnection connection, Direction travelDirection, BlockPos fromPos, float lerpFactor) {
        Vector3d startVec = TubeTileEntity.getCenter(fromPos);
        BlockPos endPos = connection.toPos;
        Vector3d endVec = TubeTileEntity.getCenter(endPos);
        Direction endSide = connection.toSide;
        Vector3d startSideVec = RaytraceHelper.getTubeSideCenter(fromPos, travelDirection);
        Vector3d endSideVec = RaytraceHelper.getTubeSideCenter(endPos, endSide);
        if (lerpFactor < 0.25f) {
            Vector3d sideOffset = startSideVec.func_178788_d(startVec);
            float subLerp = lerpFactor / 0.25f;
            double x = MathHelper.func_219803_d((double)subLerp, (double)0.0, (double)sideOffset.field_72450_a);
            double y = MathHelper.func_219803_d((double)subLerp, (double)0.0, (double)sideOffset.field_72448_b);
            double z = MathHelper.func_219803_d((double)subLerp, (double)0.0, (double)sideOffset.field_72449_c);
            return new Vector3d(x, y, z);
        }
        if (lerpFactor < 0.75f) {
            float subLerp = (lerpFactor - 0.25f) / 0.5f;
            double x = MathHelper.func_219803_d((double)subLerp, (double)startSideVec.field_72450_a, (double)endSideVec.field_72450_a);
            double y = MathHelper.func_219803_d((double)subLerp, (double)startSideVec.field_72448_b, (double)endSideVec.field_72448_b);
            double z = MathHelper.func_219803_d((double)subLerp, (double)startSideVec.field_72449_c, (double)endSideVec.field_72449_c);
            return new Vector3d(x - startVec.field_72450_a, y - startVec.field_72448_b, z - startVec.field_72449_c);
        }
        float subLerp = (lerpFactor - 0.75f) / 0.25f;
        double x = MathHelper.func_219803_d((double)subLerp, (double)endSideVec.field_72450_a, (double)endVec.field_72450_a);
        double y = MathHelper.func_219803_d((double)subLerp, (double)endSideVec.field_72448_b, (double)endVec.field_72448_b);
        double z = MathHelper.func_219803_d((double)subLerp, (double)endSideVec.field_72449_c, (double)endVec.field_72449_c);
        return new Vector3d(x - startVec.field_72450_a, y - startVec.field_72448_b, z - startVec.field_72449_c);
    }

    public static double getRemoteItemRenderScale(RemoteConnection connection, Direction travelDirection, BlockPos fromPos, float lerpFactor) {
        Direction remoteFace = connection.toSide;
        BlockPos remotePos = connection.toPos;
        double smallestScale = Math.min(TubeTileEntityRenderer.getRemoteItemRenderScale(travelDirection, fromPos, remotePos), TubeTileEntityRenderer.getRemoteItemRenderScale(remoteFace, remotePos, fromPos));
        if (lerpFactor < 0.25f) {
            double subLerp = (lerpFactor - 0.25f) / 0.25f;
            return MathHelper.func_219803_d((double)subLerp, (double)1.0, (double)smallestScale);
        }
        if (lerpFactor < 0.75f) {
            return smallestScale;
        }
        double subLerp = (lerpFactor - 0.75f) / 0.25f;
        return MathHelper.func_219803_d((double)subLerp, (double)smallestScale, (double)1.0);
    }

    public static double getRemoteItemRenderScale(Direction startSide, BlockPos startPos, BlockPos toPos) {
        BlockPos dist = toPos.func_177973_b((Vector3i)startPos);
        Direction.Axis travelAxis = startSide.func_176740_k();
        Direction.Axis[] orthagonalAxes = DirectionTransformer.ORTHAGONAL_AXES[travelAxis.ordinal()];
        double parallelDistance = startSide.func_176740_k().func_196052_a(dist.func_177958_n(), dist.func_177956_o(), dist.func_177952_p());
        double parallelDistanceSquared = parallelDistance * parallelDistance;
        double orthagonalDistanceSquared = 0.0;
        int axisCount = orthagonalAxes.length;
        for (int i = 0; i < axisCount; ++i) {
            int orthagonalDist = orthagonalAxes[i].func_196052_a(dist.func_177958_n(), dist.func_177956_o(), dist.func_177952_p());
            orthagonalDistanceSquared += (double)(orthagonalDist * orthagonalDist);
        }
        return Math.exp(-(orthagonalDistanceSquared / parallelDistanceSquared));
    }

    public static Vector3d getAdjacentRenderOffset(Direction travelDirection, float lerpFactor) {
        double xEnd = travelDirection.func_82601_c();
        double yEnd = travelDirection.func_96559_d();
        double zEnd = travelDirection.func_82599_e();
        double xLerp = MathHelper.func_219803_d((double)lerpFactor, (double)0.0, (double)xEnd);
        double yLerp = MathHelper.func_219803_d((double)lerpFactor, (double)0.0, (double)yEnd);
        double zLerp = MathHelper.func_219803_d((double)lerpFactor, (double)0.0, (double)zEnd);
        return new Vector3d(xLerp, yLerp, zLerp);
    }

    public void renderLongTubes(TubeTileEntity tube, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        World world = tube.func_145831_w();
        BlockPos startPos = tube.func_174877_v();
        Block block = tube.func_195044_w().func_177230_c();
        if (block instanceof TubeBlock) {
            for (Map.Entry<Direction, RemoteConnection> entry : tube.getRemoteConnections().entrySet()) {
                RemoteConnection connection = entry.getValue();
                if (!connection.isPrimary) continue;
                BlockPos endPos = connection.toPos;
                Direction startFace = entry.getKey();
                Direction endFace = connection.toSide;
                TubeQuadRenderer.renderQuads(world, partialTicks, startPos, endPos, startFace, endFace, matrix, buffer, (TubeBlock)block);
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                for (Hand hand : Hand.values()) {
                    Vector3d[] points;
                    float eyeHeight;
                    double handZ;
                    double handY;
                    double handX;
                    CompoundNBT nbt;
                    ItemStack stack = player.func_184586_b(hand);
                    if (!(stack.func_77973_b() instanceof TubingPliersItem) || (nbt = stack.func_179543_a("last_tube_data")) == null) continue;
                    BlockPos posOfLastTubeOfPlayer = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("last_tube_pos"));
                    Direction sideOfLastTubeOfPlayer = Direction.func_82600_a((int)nbt.func_74762_e("last_tube_side"));
                    if (!posOfLastTubeOfPlayer.equals((Object)tube.func_174877_v())) continue;
                    EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
                    int handSideID = -(hand == Hand.MAIN_HAND ? -1 : 1) * (player.func_184591_cq() == HandSide.RIGHT ? 1 : -1);
                    float swingProgress = player.func_70678_g(partialTicks);
                    float swingZ = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
                    float playerAngle = MathHelper.func_219799_g((float)partialTicks, (float)player.field_70760_ar, (float)player.field_70761_aq) * ((float)Math.PI / 180);
                    double playerAngleX = MathHelper.func_76126_a((float)playerAngle);
                    double playerAngleZ = MathHelper.func_76134_b((float)playerAngle);
                    double handOffset = (double)handSideID * 0.35;
                    if (renderManager.field_78733_k == null || renderManager.field_78733_k.func_243230_g() == PointOfView.FIRST_PERSON) {
                        double fov = renderManager.field_78733_k.field_74334_X;
                        Vector3d handVector = new Vector3d(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                        handVector = handVector.func_178789_a(-MathHelper.func_219799_g((float)partialTicks, (float)player.field_70127_C, (float)player.field_70125_A) * ((float)Math.PI / 180));
                        handVector = handVector.func_178785_b(-MathHelper.func_219799_g((float)partialTicks, (float)player.field_70126_B, (float)player.field_70177_z) * ((float)Math.PI / 180));
                        handVector = handVector.func_178785_b(swingZ * 0.5f);
                        handVector = handVector.func_178789_a(-swingZ * 0.7f);
                        handX = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70169_q, (double)player.func_226277_ct_()) + handVector.field_72450_a;
                        handY = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70167_r, (double)player.func_226278_cu_()) + handVector.field_72448_b + 0.0;
                        handZ = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70166_s, (double)player.func_226281_cx_()) + handVector.field_72449_c;
                        eyeHeight = player.func_70047_e();
                    } else {
                        handX = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70169_q, (double)player.func_226277_ct_()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                        handY = -0.2 + player.field_70167_r + (double)player.func_70047_e() + (player.func_226278_cu_() - player.field_70167_r) * (double)partialTicks - 0.45;
                        handZ = MathHelper.func_219803_d((double)partialTicks, (double)player.field_70166_s, (double)player.func_226281_cx_()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                        eyeHeight = player.func_213453_ef() ? -0.1875f : 0.0f;
                    }
                    Vector3d renderPlayerVec = new Vector3d(handX, handY + (double)eyeHeight, handZ);
                    Vector3d startVec = RaytraceHelper.getTubeSideCenter(posOfLastTubeOfPlayer, sideOfLastTubeOfPlayer);
                    Vector3d endVec = renderPlayerVec;
                    for (Vector3d point : points = RaytraceHelper.getInterpolatedPoints(startVec, endVec)) {
                        world.func_195594_a((IParticleData)ParticleTypes.field_203218_U, point.field_72450_a, point.field_72448_b, point.field_72449_c, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean isGlobalRenderer(TubeTileEntity te) {
        return true;
    }
}

