/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.footwork;

import jackiecrazy.footwork.api.WarAttributes;
import jackiecrazy.footwork.capability.goal.GoalCapability;
import jackiecrazy.footwork.capability.goal.IGoalHelper;
import jackiecrazy.footwork.capability.resources.CombatStorage;
import jackiecrazy.footwork.capability.resources.DummyCombatCap;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.capability.weaponry.DummyCombatItemCap;
import jackiecrazy.footwork.capability.weaponry.ICombatItemCapability;
import jackiecrazy.footwork.potion.FootworkEffects;
import java.util.Random;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="footwork")
public class Footwork {
    public static final String MODID = "footwork";
    public static final Random rand = new Random();
    private static final Logger LOGGER = LogManager.getLogger();

    public Footwork() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::attribute);
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        WarAttributes.ATTRIBUTES.register(bus);
        FootworkEffects.EFFECTS.register(bus);
    }

    private void setup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(ICombatCapability.class, (Capability.IStorage)new CombatStorage(), DummyCombatCap::new);
        CapabilityManager.INSTANCE.register(ICombatItemCapability.class, (Capability.IStorage)new DummyCombatItemCap.Storage(), DummyCombatItemCap::new);
        CapabilityManager.INSTANCE.register(IGoalHelper.class, (Capability.IStorage)new GoalCapability.Storage(), GoalCapability::new);
    }

    private void attribute(EntityAttributeModificationEvent e) {
        for (EntityType type : e.getTypes()) {
            if (!e.has(type, Attributes.field_233819_b_)) {
                e.add(type, Attributes.field_233819_b_, 32.0);
            }
            if (!e.has(type, Attributes.field_233825_h_)) {
                e.add(type, Attributes.field_233825_h_);
            }
            for (RegistryObject a : WarAttributes.ATTRIBUTES.getEntries()) {
                e.add(type, (Attribute)a.get());
            }
        }
    }
}

