/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.footwork.capability.resources;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;

public interface ICombatCapability {
    public float getResolve();

    public void setResolve(float var1);

    public float getMight();

    public void setMight(float var1);

    public float addMight(float var1);

    default public boolean consumeMight(float amount) {
        return this.consumeMight(amount, 0.0f);
    }

    public boolean consumeMight(float var1, float var2);

    public int getMightGrace();

    public void setMightGrace(int var1);

    public int decrementMightGrace(int var1);

    public float getSpirit();

    public void setSpirit(float var1);

    public float addSpirit(float var1);

    default public boolean consumeSpirit(float amount) {
        return this.consumeSpirit(amount, 0.0f);
    }

    public boolean consumeSpirit(float var1, float var2);

    public int getSpiritGrace();

    public void setSpiritGrace(int var1);

    public int decrementSpiritGrace(int var1);

    public float getPosture();

    public void setPosture(float var1);

    public float addPosture(float var1);

    default public boolean doConsumePosture(float amount) {
        return this.consumePosture(amount, 0.0f) == 0.0f;
    }

    default public float consumePosture(float amount) {
        return this.consumePosture(amount, 0.0f);
    }

    default public float consumePosture(LivingEntity attacker, float amount) {
        return this.consumePosture(attacker, amount, 0.0f);
    }

    default public float consumePosture(float amount, float above) {
        return this.consumePosture(null, amount, above, false);
    }

    default public float consumePosture(LivingEntity attacker, float amount, float above) {
        return this.consumePosture(attacker, amount, above, false);
    }

    public boolean isFirstStaggerStrike();

    public float consumePosture(LivingEntity var1, float var2, float var3, boolean var4);

    public int getPostureGrace();

    public void setPostureGrace(int var1);

    public int decrementPostureGrace(int var1);

    public float getRank();

    public void setRank(float var1);

    default public int getComboRank() {
        float workingCombo = this.getRank();
        if (workingCombo >= 9.0f) {
            return 7;
        }
        if (workingCombo >= 6.0f) {
            return 6;
        }
        if (workingCombo >= 4.0f) {
            return 5;
        }
        return (int)workingCombo;
    }

    public void setAdrenalineCooldown(int var1);

    public boolean halvedAdrenaline();

    public float addRank(float var1);

    default public boolean consumeRank(float amount) {
        return this.consumeRank(amount, 0.0f);
    }

    public boolean consumeRank(float var1, float var2);

    public float getTrueMaxPosture();

    public void setTrueMaxPosture(float var1);

    public float getTrueMaxSpirit();

    public void setTrueMaxSpirit(float var1);

    public float getMaxMight();

    public void setMaxMight(float var1);

    default public float getMaxPosture() {
        return Math.max(0.1f, this.getTrueMaxPosture() - this.getFatigue());
    }

    default public float getMaxSpirit() {
        return Math.max(0.1f, this.getTrueMaxSpirit() - this.getBurnout());
    }

    public int getMaxStaggerTime();

    public int getStaggerTime();

    public void setStaggerTime(int var1);

    public int decrementStaggerTime(int var1);

    public int getMaxStaggerCount();

    public int getStaggerCount();

    public void setStaggerCount(int var1);

    public void decrementStaggerCount(int var1);

    public int getBarrierCooldown();

    public void setBarrierCooldown(int var1);

    public void decrementBarrierCooldown(int var1);

    public float getMaxBarrier();

    public void setMaxBarrier(float var1);

    public float getBarrier();

    public void setBarrier(float var1);

    public float consumeBarrier(float var1);

    public void addBarrier(float var1);

    public int getOffhandCooldown();

    public void setOffhandCooldown(int var1);

    public void addOffhandCooldown(int var1);

    public int getRollTime();

    public void setRollTime(int var1);

    public void decrementRollTime(int var1);

    public boolean isOffhandAttack();

    public void setOffhandAttack(boolean var1);

    public boolean isCombatMode();

    public void toggleCombatMode(boolean var1);

    public float getWounding();

    public void setWounding(float var1);

    public float getFatigue();

    public void setFatigue(float var1);

    public float getBurnout();

    public void setBurnout(float var1);

    public void addWounding(float var1);

    public void addFatigue(float var1);

    public void addBurnout(float var1);

    public int getHandBind(Hand var1);

    public void setHandBind(Hand var1, int var2);

    public void decrementHandBind(Hand var1, int var2);

    public float getHandReel(Hand var1);

    public void setHandReel(Hand var1, float var2);

    public boolean consumeShatter(float var1);

    public int getShatterCooldown();

    public void setShatterCooldown(int var1);

    public int decrementShatterCooldown(int var1);

    public float getCachedCooldown();

    public void setCachedCooldown(float var1);

    public int getForcedSweep();

    public void setForcedSweep(int var1);

    public void clientTick();

    public void serverTick();

    public void sync();

    public ItemStack getTempItemStack();

    public void setTempItemStack(ItemStack var1);

    public void read(CompoundNBT var1);

    public int getParryingTick();

    public void setParryingTick(int var1);

    public int getSweepTick();

    public void setSweepTick(int var1);

    public boolean isValid();

    public Vector3d getMotionConsistently();

    public CompoundNBT write();

    public void addRangedMight(boolean var1);

    public int getRetina();

    public float visionRange();
}

