/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.footwork.config;

import com.mojang.datafixers.util.Pair;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;

public class DisplayConfigUtils {
    public static Pair<Integer, Integer> translateCoords(DisplayData dd, int width, int height) {
        return DisplayConfigUtils.translateCoords(dd.anchorPoint, dd.numberX, dd.numberY, width, height);
    }

    public static Pair<Integer, Integer> translateCoords(AnchorPoint ap, int x, int y, int width, int height) {
        int rety;
        int retx;
        switch (ap) {
            case TOPLEFT: {
                retx = 0;
                rety = 0;
                break;
            }
            case TOPRIGHT: {
                retx = 0;
                rety = width;
                break;
            }
            case CROSSHAIR: {
                retx = width / 2;
                rety = height / 2;
                break;
            }
            case TOPCENTER: {
                retx = width / 2;
                rety = 0;
                break;
            }
            case BOTTOMLEFT: {
                retx = 0;
                rety = height;
                break;
            }
            case MIDDLELEFT: {
                retx = 0;
                rety = height / 2;
                break;
            }
            case BOTTOMRIGHT: {
                retx = width;
                rety = height;
                break;
            }
            case MIDDLERIGHT: {
                retx = width;
                rety = height / 2;
                break;
            }
            case BOTTOMCENTER: {
                retx = width / 2;
                rety = height;
                break;
            }
            default: {
                rety = 0;
                retx = 0;
            }
        }
        retx = MathHelper.func_76125_a((int)(retx + x), (int)0, (int)width);
        rety = MathHelper.func_76125_a((int)(rety + y), (int)0, (int)height);
        return Pair.of((Object)retx, (Object)rety);
    }

    public static class DisplayData {
        private final ForgeConfigSpec.EnumValue<AnchorPoint> _anchor;
        private final ForgeConfigSpec.IntValue _numberX;
        private final ForgeConfigSpec.IntValue _numberY;
        private final ForgeConfigSpec.BooleanValue _display;
        public AnchorPoint anchorPoint;
        public int numberX;
        public int numberY;
        public boolean enabled;

        public DisplayData(ForgeConfigSpec.Builder b, String s, AnchorPoint ap, int defX, int defY) {
            this._display = b.translation("footwork.config." + s + "enabled").comment("enable displaying this feature").define("enable " + s, true);
            this._anchor = b.translation("footwork.config." + s + "anchor").comment("the point from which offsets will calculate").defineEnum(s + " anchor point", (Enum)ap);
            this._numberX = b.translation("footwork.config." + s + "X").comment("where the center of the HUD element should be in relation to the anchor point").defineInRange(s + " x offset", defX, -2147483647, Integer.MAX_VALUE);
            this._numberY = b.translation("footwork.config." + s + "Y").comment("where the center of the HUD element should be in relation to the anchor point").defineInRange(s + " y offset", defY, -2147483647, Integer.MAX_VALUE);
        }

        public void bake() {
            this.anchorPoint = (AnchorPoint)((Object)this._anchor.get());
            this.numberX = (Integer)this._numberX.get();
            this.numberY = (Integer)this._numberY.get();
            this.enabled = (Boolean)this._display.get();
        }
    }

    public static enum BarType {
        CLASSIC,
        AMO,
        DARKMEGA;

    }

    public static enum AnchorPoint {
        TOPLEFT,
        TOPCENTER,
        TOPRIGHT,
        MIDDLELEFT,
        CROSSHAIR,
        MIDDLERIGHT,
        BOTTOMLEFT,
        BOTTOMCENTER,
        BOTTOMRIGHT;

    }
}

