/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.footwork.utils;

import jackiecrazy.footwork.capability.resources.CombatData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GeneralUtils {
    public static double getSpeedSq(Entity e) {
        if (e.func_184187_bx() != null) {
            if (e.func_184208_bv() instanceof LivingEntity) {
                return CombatData.getCap((LivingEntity)e.func_184208_bv()).getMotionConsistently().func_189985_c();
            }
            return e.func_184208_bv().func_213322_ci().func_189985_c();
        }
        if (e instanceof LivingEntity) {
            return Math.max(CombatData.getCap((LivingEntity)e).getMotionConsistently().func_189985_c(), e.func_213322_ci().func_189985_c());
        }
        return e.func_213322_ci().func_189985_c();
    }

    @Nullable
    public static EntityType getEntityTypeFromResourceLocation(ResourceLocation rl) {
        if (ForgeRegistries.ENTITIES.containsKey(rl)) {
            return (EntityType)ForgeRegistries.ENTITIES.getValue(rl);
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocationFromEntityType(EntityType et) {
        if (ForgeRegistries.ENTITIES.containsValue((IForgeRegistryEntry)et)) {
            return ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)et);
        }
        return null;
    }

    @Nullable
    public static ResourceLocation getResourceLocationFromEntity(Entity et) {
        EntityType type = et.func_200600_R();
        if (ForgeRegistries.ENTITIES.containsValue((IForgeRegistryEntry)type)) {
            ResourceLocation key = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)type);
            return key;
        }
        return null;
    }

    @Nonnull
    public static RayTraceResult raytraceAnything(World world, LivingEntity attacker, double range) {
        Vector3d start = attacker.func_174824_e(0.5f);
        Vector3d look = attacker.func_70040_Z().func_186678_a(range + 2.0);
        Vector3d end = start.func_178787_e(look);
        Entity entity = null;
        List list = world.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_72321_a(look.field_72450_a, look.field_72448_b, look.field_72449_c).func_186662_g(1.0), null);
        double d0 = 0.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            Optional raytraceresult;
            if (entity1 == attacker || !(raytraceresult = (axisalignedbb = entity1.func_174813_aQ()).func_216365_b(start, end)).isPresent() || !((d1 = GeneralUtils.getDistSqCompensated(entity1, (Entity)attacker)) < d0) && d0 != 0.0 || !(d1 < range * range)) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            return new EntityRayTraceResult(entity);
        }
        look = attacker.func_70040_Z().func_186678_a(range);
        end = start.func_178787_e(look);
        BlockRayTraceResult rtr = world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        if (rtr != null) {
            return rtr;
        }
        return new BlockRayTraceResult(end, Direction.UP, new BlockPos(end), false);
    }

    public static double getDistSqCompensated(Entity from, Entity to) {
        double x = from.func_226277_ct_() - to.func_226277_ct_();
        x = Math.max(Math.abs(x) - (double)(from.func_213311_cf() / 2.0f + to.func_213311_cf() / 2.0f), 0.0);
        double y = from.func_226278_cu_() + (double)(from.func_213302_cg() / 2.0f) - (to.func_226278_cu_() + (double)(to.func_213302_cg() / 2.0f));
        y = Math.max(Math.abs(y) - (double)(from.func_213302_cg() / 2.0f + to.func_213302_cg() / 2.0f), 0.0);
        double z = from.func_226281_cx_() - to.func_226281_cx_();
        z = Math.max(Math.abs(z) - (double)(from.func_213311_cf() / 2.0f + to.func_213311_cf() / 2.0f), 0.0);
        double me = x * x + y * y + z * z;
        double you = from.func_70068_e(to);
        return Math.min(me, you);
    }

    public static float getMaxHealthBeforeWounding(LivingEntity of) {
        return of.func_110138_aP() + CombatData.getCap(of).getWounding();
    }

    public static double getDistSqCompensated(Entity from, Vector3d to) {
        double x = from.func_226277_ct_() - to.field_72450_a;
        x = Math.max(Math.abs(x) - (double)(from.func_213311_cf() / 2.0f), 0.0);
        double y = from.func_226278_cu_() + (double)(from.func_213302_cg() / 2.0f) - to.field_72448_b;
        y = Math.max(Math.abs(y) - (double)(from.func_213302_cg() / 2.0f), 0.0);
        double z = from.func_226281_cx_() - to.field_72449_c;
        z = Math.max(Math.abs(z) - (double)(from.func_213311_cf() / 2.0f), 0.0);
        return x * x + y * y + z * z;
    }

    public static double getDistSqCompensated(Entity from, BlockPos to) {
        double x = from.func_226277_ct_() - (double)to.func_177958_n();
        x = Math.max(Math.abs(x) - (double)(from.func_213311_cf() / 2.0f), 0.0);
        double y = from.func_226278_cu_() + (double)(from.func_213302_cg() / 2.0f) - (double)to.func_177956_o();
        y = Math.max(Math.abs(y) - (double)(from.func_213302_cg() / 2.0f), 0.0);
        double z = from.func_226281_cx_() - (double)to.func_177952_p();
        z = Math.max(Math.abs(z) - (double)(from.func_213311_cf() / 2.0f), 0.0);
        return x * x + y * y + z * z;
    }

    public static Entity raytraceEntity(World world, LivingEntity attacker, double range) {
        Vector3d start = attacker.func_174824_e(0.5f);
        Vector3d look = attacker.func_70040_Z().func_186678_a(range + 2.0);
        Vector3d end = start.func_178787_e(look);
        Entity entity = null;
        List list = world.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_72321_a(look.field_72450_a, look.field_72448_b, look.field_72449_c).func_186662_g(1.0), null);
        double d0 = -1.0;
        for (Entity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            Optional raytraceresult;
            if (entity1 == attacker || !(raytraceresult = (axisalignedbb = entity1.func_174813_aQ()).func_216365_b(start, end)).isPresent() || !((d1 = GeneralUtils.getDistSqCompensated(entity1, (Entity)attacker)) < d0) && d0 != -1.0 || !(d1 < range * range)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public static LivingEntity raytraceLiving(LivingEntity attacker, double range) {
        return GeneralUtils.raytraceLiving(attacker.field_70170_p, attacker, range);
    }

    public static LivingEntity raytraceLiving(World world, LivingEntity attacker, double range) {
        Vector3d start = attacker.func_174824_e(0.5f);
        Vector3d look = attacker.func_70040_Z().func_186678_a(range + 2.0);
        Vector3d end = start.func_178787_e(look);
        LivingEntity entity = null;
        List list = world.func_175647_a(LivingEntity.class, attacker.func_174813_aQ().func_72321_a(look.field_72450_a, look.field_72448_b, look.field_72449_c).func_186662_g(1.5), null);
        double d0 = -1.0;
        for (LivingEntity entity1 : list) {
            double d1;
            AxisAlignedBB axisalignedbb;
            Optional raytraceresult;
            if (entity1 == attacker || !(raytraceresult = (axisalignedbb = entity1.func_174813_aQ()).func_216365_b(start, end)).isPresent() || !((d1 = GeneralUtils.getDistSqCompensated((Entity)entity1, (Entity)attacker)) < d0) && d0 != -1.0 || !(d1 < range * range)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public static Entity collidingEntity(Entity elb) {
        AxisAlignedBB aabb = elb.func_174813_aQ();
        Vector3d motion = elb.func_213322_ci().func_72432_b().func_186678_a(0.5);
        List entities = elb.field_70170_p.func_175674_a(elb, aabb.func_72321_a(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c), EntityPredicates.field_94557_a);
        double dist = 0.0;
        Entity pick = null;
        for (Entity e : entities) {
            if (!(e.func_70068_e(elb) < dist) && dist != 0.0) continue;
            pick = e;
            dist = e.func_70068_e(elb);
        }
        return pick;
    }

    public static List<Entity> raytraceEntities(World world, LivingEntity attacker, double range) {
        Vector3d start = attacker.func_174824_e(0.5f);
        Vector3d look = attacker.func_70040_Z().func_186678_a(range + 2.0);
        Vector3d end = start.func_178787_e(look);
        ArrayList<Entity> ret = new ArrayList<Entity>();
        List list = world.func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_72321_a(look.field_72450_a, look.field_72448_b, look.field_72449_c).func_186662_g(1.0), EntityPredicates.field_94557_a);
        for (Entity entity1 : list) {
            AxisAlignedBB axisalignedbb;
            Optional raytraceresult;
            if (entity1 == attacker || !(GeneralUtils.getDistSqCompensated((Entity)attacker, entity1) < range * range) || !(raytraceresult = (axisalignedbb = entity1.func_174813_aQ()).func_216365_b(start, end)).isPresent()) continue;
            ret.add(entity1);
        }
        return ret;
    }

    public static Vector3d getPointInFrontOf(Entity target, Entity from, double distance) {
        Vector3d end = target.func_213303_ch().func_178787_e(from.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_186678_a(distance));
        return GeneralUtils.getClosestAirSpot(from.func_213303_ch(), end, from);
    }

    public static Vector3d getClosestAirSpot(Vector3d from, Vector3d to, Entity e) {
        Vector3d ret = to;
        to = to.func_178787_e(to.func_178788_d(from).func_72432_b().func_186678_a(2.0));
        double widthParse = e.func_213311_cf() / 2.0f;
        double heightParse = e.func_213302_cg();
        if (widthParse <= 0.5) {
            widthParse = 0.0;
        }
        if (heightParse <= 1.0) {
            heightParse = 0.0;
        }
        for (double addX = -widthParse; addX <= widthParse; addX += 0.5) {
            for (double addZ = -widthParse; addZ <= widthParse; addZ += 0.5) {
                for (double addY = (double)(e.func_213302_cg() / 2.0f); addY <= heightParse; addY += 0.5) {
                    Vector3d mod = new Vector3d(addX, addY, addZ);
                    BlockRayTraceResult r = e.field_70170_p.func_217299_a(new RayTraceContext(from.func_178787_e(mod), to.func_178787_e(mod), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, e));
                    if (r == null || r.func_216346_c() != RayTraceResult.Type.BLOCK || r.func_216347_e().equals((Object)from.func_178787_e(mod))) continue;
                    Vector3d hit = r.func_216347_e().func_178788_d(mod);
                    switch (r.func_216354_b()) {
                        case NORTH: {
                            hit = hit.func_72441_c(0.0, 0.0, -1.0);
                            break;
                        }
                        case SOUTH: {
                            hit = hit.func_72441_c(0.0, 0.0, 1.0);
                            break;
                        }
                        case EAST: {
                            hit = hit.func_72441_c(1.0, 0.0, 0.0);
                            break;
                        }
                        case WEST: {
                            hit = hit.func_72441_c(-1.0, 0.0, 0.0);
                            break;
                        }
                        case UP: {
                            break;
                        }
                        case DOWN: {
                            hit = hit.func_72441_c(0.0, -1.0, 0.0);
                        }
                    }
                    if (!(from.func_72436_e(hit) < from.func_72436_e(ret))) continue;
                    ret = hit;
                }
            }
        }
        return ret;
    }

    public static boolean viewBlocked(LivingEntity viewer, LivingEntity viewed, boolean flimsy) {
        if (viewer.func_70068_e((Entity)viewed) > 1000.0) {
            return true;
        }
        AxisAlignedBB viewerBoundBox = viewer.func_174813_aQ();
        AxisAlignedBB angelBoundingBox = viewed.func_174813_aQ();
        Vector3d[] viewerPoints = new Vector3d[]{new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72340_a, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72339_c), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72337_e, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72334_f), new Vector3d(viewerBoundBox.field_72336_d, viewerBoundBox.field_72338_b, viewerBoundBox.field_72339_c)};
        Vector3d[] angelPoints = new Vector3d[]{new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72340_a, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72339_c), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72337_e, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72334_f), new Vector3d(angelBoundingBox.field_72336_d, angelBoundingBox.field_72338_b, angelBoundingBox.field_72339_c)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.field_70170_p.func_217299_a(new RayTraceContext(viewerPoints[i], angelPoints[i], flimsy ? RayTraceContext.BlockMode.OUTLINE : RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)viewer)).func_216346_c() == RayTraceResult.Type.MISS) {
                return false;
            }
            if (GeneralUtils.rayTraceBlocks(viewer, viewer.field_70170_p, viewerPoints[i], angelPoints[i], pos -> {
                BlockState state = viewer.field_70170_p.func_180495_p(pos);
                return flimsy ? !state.func_185904_a().func_76224_d() : !GeneralUtils.canSeeThrough(state, viewer.field_70170_p, pos);
            }) != null) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static RayTraceResult rayTraceBlocks(LivingEntity livingEntity, World world, Vector3d vec31, Vector3d vec32, Predicate<BlockPos> stopOn) {
        if (!(Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c) || Double.isNaN(vec32.field_72450_a) || Double.isNaN(vec32.field_72448_b) || Double.isNaN(vec32.field_72449_c))) {
            BlockRayTraceResult raytraceresult;
            int j1;
            int i1;
            int i = MathHelper.func_76128_c((double)vec32.field_72450_a);
            int j = MathHelper.func_76128_c((double)vec32.field_72448_b);
            int k = MathHelper.func_76128_c((double)vec32.field_72449_c);
            int l = MathHelper.func_76128_c((double)vec31.field_72450_a);
            BlockPos blockpos = new BlockPos(l, i1 = MathHelper.func_76128_c((double)vec31.field_72448_b), j1 = MathHelper.func_76128_c((double)vec31.field_72449_c));
            if (stopOn.test(blockpos) && (raytraceresult = world.func_217299_a(new RayTraceContext(vec31, vec32, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)livingEntity))) != null) {
                return raytraceresult;
            }
            int k1 = 200;
            while (k1-- >= 0) {
                BlockRayTraceResult raytraceresult1;
                Direction enumfacing;
                if (Double.isNaN(vec31.field_72450_a) || Double.isNaN(vec31.field_72448_b) || Double.isNaN(vec31.field_72449_c)) {
                    return null;
                }
                if (l == i && i1 == j && j1 == k) {
                    return null;
                }
                boolean flag2 = true;
                boolean flag = true;
                boolean flag1 = true;
                double d0 = 999.0;
                double d1 = 999.0;
                double d2 = 999.0;
                if (i > l) {
                    d0 = (double)l + 1.0;
                } else if (i < l) {
                    d0 = (double)l + 0.0;
                } else {
                    flag2 = false;
                }
                if (j > i1) {
                    d1 = (double)i1 + 1.0;
                } else if (j < i1) {
                    d1 = (double)i1 + 0.0;
                } else {
                    flag = false;
                }
                if (k > j1) {
                    d2 = (double)j1 + 1.0;
                } else if (k < j1) {
                    d2 = (double)j1 + 0.0;
                } else {
                    flag1 = false;
                }
                double d3 = 999.0;
                double d4 = 999.0;
                double d5 = 999.0;
                double d6 = vec32.field_72450_a - vec31.field_72450_a;
                double d7 = vec32.field_72448_b - vec31.field_72448_b;
                double d8 = vec32.field_72449_c - vec31.field_72449_c;
                if (flag2) {
                    d3 = (d0 - vec31.field_72450_a) / d6;
                }
                if (flag) {
                    d4 = (d1 - vec31.field_72448_b) / d7;
                }
                if (flag1) {
                    d5 = (d2 - vec31.field_72449_c) / d8;
                }
                if (d3 == -0.0) {
                    d3 = -1.0E-4;
                }
                if (d4 == -0.0) {
                    d4 = -1.0E-4;
                }
                if (d5 == -0.0) {
                    d5 = -1.0E-4;
                }
                if (d3 < d4 && d3 < d5) {
                    enumfacing = i > l ? Direction.WEST : Direction.EAST;
                    vec31 = new Vector3d(d0, vec31.field_72448_b + d7 * d3, vec31.field_72449_c + d8 * d3);
                } else if (d4 < d5) {
                    enumfacing = j > i1 ? Direction.DOWN : Direction.UP;
                    vec31 = new Vector3d(vec31.field_72450_a + d6 * d4, d1, vec31.field_72449_c + d8 * d4);
                } else {
                    enumfacing = k > j1 ? Direction.NORTH : Direction.SOUTH;
                    vec31 = new Vector3d(vec31.field_72450_a + d6 * d5, vec31.field_72448_b + d7 * d5, d2);
                }
                if (!stopOn.test(blockpos = new BlockPos(l = MathHelper.func_76128_c((double)vec31.field_72450_a) - (enumfacing == Direction.EAST ? 1 : 0), i1 = MathHelper.func_76128_c((double)vec31.field_72448_b) - (enumfacing == Direction.UP ? 1 : 0), j1 = MathHelper.func_76128_c((double)vec31.field_72449_c) - (enumfacing == Direction.SOUTH ? 1 : 0))) || (raytraceresult1 = world.func_217299_a(new RayTraceContext(vec31, vec32, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)livingEntity))) == null) continue;
                return raytraceresult1;
            }
        }
        return null;
    }

    public static boolean canSeeThrough(BlockState blockState, World world, BlockPos pos) {
        if (!blockState.func_200132_m() || !blockState.func_200015_d((IBlockReader)world, pos)) {
            return true;
        }
        Block block = blockState.func_177230_c();
        if (block instanceof DoorBlock) {
            return blockState.func_177229_b((Property)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER;
        }
        return blockState.func_196952_d((IBlockReader)world, pos) == VoxelShapes.func_197880_a();
    }

    public static BlockPos posFromAABB(AxisAlignedBB aabb) {
        return new BlockPos((aabb.field_72336_d + aabb.field_72340_a) / 2.0, (aabb.field_72337_e + aabb.field_72338_b) / 2.0, (aabb.field_72334_f + aabb.field_72339_c) / 2.0);
    }

    public static boolean isFacingEntity(Entity entity1, Entity entity2, int angle) {
        double cos;
        if (angle >= 360) {
            return true;
        }
        if (angle < 0) {
            return GeneralUtils.isBehindEntity(entity2, entity1, -angle);
        }
        Vector3d posVec = entity2.func_213303_ch().func_72441_c(0.0, (double)entity2.func_70047_e(), 0.0);
        Vector3d lookVec = entity1.func_70676_i(1.0f);
        Vector3d relativePosVec = posVec.func_72444_a(entity1.func_213303_ch().func_72441_c(0.0, (double)entity1.func_70047_e(), 0.0)).func_72432_b();
        double dotsq = relativePosVec.func_72430_b(lookVec) * Math.abs(relativePosVec.func_72430_b(lookVec)) / (relativePosVec.func_189985_c() * lookVec.func_189985_c());
        return dotsq < -((cos = (double)MathHelper.func_76134_b((float)GeneralUtils.rad((float)angle / 2.0f))) * cos);
    }

    public static boolean isBehindEntity(Entity entity, Entity reference, int angle) {
        double cos;
        if (angle >= 360) {
            return true;
        }
        Vector3d posVec = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vector3d lookVec = GeneralUtils.getBodyOrientation(reference);
        Vector3d relativePosVec = posVec.func_72444_a(reference.func_213303_ch().func_72441_c(0.0, (double)reference.func_70047_e(), 0.0)).func_72432_b();
        relativePosVec = new Vector3d(relativePosVec.field_72450_a, 0.0, relativePosVec.field_72449_c);
        double dotsq = relativePosVec.func_72430_b(lookVec) * Math.abs(relativePosVec.func_72430_b(lookVec)) / (relativePosVec.func_189985_c() * lookVec.func_189985_c());
        return dotsq > (cos = (double)MathHelper.func_76134_b((float)GeneralUtils.rad((float)angle / 2.0f))) * cos;
    }

    public static float rad(float angle) {
        return (float)((double)angle * Math.PI / 180.0);
    }

    public static Vector3d getBodyOrientation(Entity e) {
        float f = MathHelper.func_76134_b((float)(-e.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-e.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-e.field_70125_A * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-e.field_70125_A * ((float)Math.PI / 180)));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static float deg(float rad) {
        return (float)((double)rad * 180.0 / Math.PI);
    }

    public static boolean isFacingEntity(Entity entity1, Entity entity2, int horAngle, int vertAngle) {
        horAngle = Math.min(horAngle, 360);
        vertAngle = Math.min(vertAngle, 360);
        if (horAngle < 0) {
            return GeneralUtils.isBehindEntity(entity2, entity1, -horAngle, Math.abs(vertAngle));
        }
        double xDiff = entity1.func_226277_ct_() - entity2.func_226277_ct_();
        double zDiff = entity1.func_226281_cx_() - entity2.func_226281_cx_();
        if (vertAngle != 360) {
            Vector3d posVec = entity2.func_213303_ch().func_72441_c(0.0, (double)entity2.func_70047_e(), 0.0);
            double distIgnoreY = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            double relativeHeadVec = entity2.func_226278_cu_() - entity1.func_226278_cu_() - (double)entity1.func_70047_e() + (double)entity2.func_213302_cg();
            double relativeFootVec = entity2.func_226278_cu_() - entity1.func_226278_cu_() - (double)entity1.func_70047_e();
            double angleHead = -MathHelper.func_181159_b((double)relativeHeadVec, (double)distIgnoreY);
            double angleFoot = -MathHelper.func_181159_b((double)relativeFootVec, (double)distIgnoreY);
            double maxRot = GeneralUtils.rad(entity1.field_70125_A + (float)vertAngle / 2.0f);
            double minRot = GeneralUtils.rad(entity1.field_70125_A - (float)vertAngle / 2.0f);
            if (angleHead > maxRot || angleFoot < minRot) {
                return false;
            }
        }
        if (horAngle != 360) {
            Vector3d lookVec = entity1.func_70676_i(1.0f);
            Vector3d bodyVec = GeneralUtils.getBodyOrientation(entity1);
            Vector3d relativePosVec = entity2.func_213303_ch().func_178788_d(entity1.func_213303_ch());
            double angleLook = MathHelper.func_181159_b((double)lookVec.field_72449_c, (double)lookVec.field_72450_a);
            double angleBody = MathHelper.func_181159_b((double)bodyVec.field_72449_c, (double)bodyVec.field_72450_a);
            double anglePos = MathHelper.func_181159_b((double)relativePosVec.field_72449_c, (double)relativePosVec.field_72450_a);
            angleBody += Math.PI;
            angleLook += Math.PI;
            anglePos += Math.PI;
            double rad = GeneralUtils.rad((float)horAngle / 2.0f);
            if (Math.abs(angleLook - anglePos) > rad && Math.abs(angleBody - anglePos) > rad) {
                return false;
            }
        }
        return true;
    }

    public static boolean isBehindEntity(Entity entity, Entity reference, int horAngle, int vertAngle) {
        if (horAngle < 0) {
            return GeneralUtils.isFacingEntity(reference, entity, -horAngle, Math.abs(vertAngle));
        }
        Vector3d posVec = reference.func_213303_ch().func_72441_c(0.0, (double)reference.func_70047_e(), 0.0);
        double xDiff = reference.func_226277_ct_() - entity.func_226277_ct_();
        double zDiff = reference.func_226281_cx_() - entity.func_226281_cx_();
        double distIgnoreY = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double relativeHeadVec = reference.func_226278_cu_() - entity.func_226278_cu_() - (double)entity.func_70047_e() + (double)reference.func_213302_cg();
        double relativeFootVec = reference.func_226278_cu_() - entity.func_226278_cu_() - (double)entity.func_70047_e();
        double angleHead = -MathHelper.func_181159_b((double)relativeHeadVec, (double)distIgnoreY);
        double angleFoot = -MathHelper.func_181159_b((double)relativeFootVec, (double)distIgnoreY);
        double maxRot = GeneralUtils.rad(reference.field_70125_A + (float)vertAngle / 2.0f);
        double minRot = GeneralUtils.rad(reference.field_70125_A - (float)vertAngle / 2.0f);
        if (angleHead > maxRot || angleFoot < minRot) {
            return false;
        }
        double xDiffCompensated = xDiff < 0.0 ? Math.min(-0.1, xDiff + (double)(entity.func_213311_cf() / 2.0f) + (double)(reference.func_213311_cf() / 2.0f)) : Math.max(0.1, xDiff - (double)(entity.func_213311_cf() / 2.0f) - (double)(reference.func_213311_cf() / 2.0f));
        double zDiffCompensated = zDiff < 0.0 ? Math.min(-0.1, zDiff + (double)(entity.func_213311_cf() / 2.0f) + (double)(reference.func_213311_cf() / 2.0f)) : Math.max(0.1, zDiff - (double)(entity.func_213311_cf() / 2.0f) - (double)(reference.func_213311_cf() / 2.0f));
        Vector3d bodyVec = GeneralUtils.getBodyOrientation(reference);
        Vector3d lookVec = reference.func_70676_i(1.0f);
        Vector3d relativePosVec = new Vector3d(xDiffCompensated, 0.0, zDiffCompensated);
        double dotsqLook = relativePosVec.func_72430_b(lookVec) * Math.abs(relativePosVec.func_72430_b(lookVec)) / (relativePosVec.func_189985_c() * lookVec.func_189985_c());
        double dotsqBody = relativePosVec.func_72430_b(bodyVec) * Math.abs(relativePosVec.func_72430_b(bodyVec)) / (relativePosVec.func_189985_c() * bodyVec.func_189985_c());
        double cos = MathHelper.func_76134_b((float)GeneralUtils.rad((float)horAngle / 2.0f));
        return dotsqBody > cos * cos || dotsqLook > cos * cos;
    }

    public static BlockPos[] bresenham(BlockPos from, BlockPos to) {
        double p_x = from.func_177958_n();
        double p_y = from.func_177956_o();
        double p_z = from.func_177952_p();
        double d_x = to.func_177958_n() - from.func_177958_n();
        double d_y = to.func_177956_o() - from.func_177956_o();
        double d_z = to.func_177952_p() - from.func_177952_p();
        int N = (int)Math.ceil(Math.max(Math.abs(d_x), Math.max(Math.abs(d_y), Math.abs(d_z))));
        double s_x = d_x / (double)N;
        double s_y = d_y / (double)N;
        double s_z = d_z / (double)N;
        BlockPos[] out = new BlockPos[N];
        if (out.length == 0) {
            return out;
        }
        out[0] = new BlockPos((int)p_x, (int)p_y, (int)p_z);
        for (int ii = 1; ii < N; ++ii) {
            out[ii] = new BlockPos((int)(p_x += s_x), (int)(p_y += s_y), (int)(p_z += s_z));
        }
        return out;
    }

    public static float getCosAngleSq(Vector3d from, Vector3d to) {
        double top = from.func_72430_b(to) * from.func_72430_b(to);
        double bot = from.func_189985_c() * to.func_189985_c();
        return (float)(top / bot);
    }

    public static ItemStack dropSkull(LivingEntity elb) {
        ItemStack ret = null;
        if (elb instanceof AbstractSkeletonEntity) {
            ret = elb instanceof WitherSkeletonEntity ? new ItemStack((IItemProvider)Items.field_196183_dw) : new ItemStack((IItemProvider)Items.field_196182_dv);
        } else if (elb instanceof ZombieEntity) {
            ret = new ItemStack((IItemProvider)Items.field_196186_dz);
        } else if (elb instanceof CreeperEntity) {
            ret = new ItemStack((IItemProvider)Items.field_196185_dy);
        } else if (elb instanceof EnderDragonEntity) {
            ret = new ItemStack((IItemProvider)Items.field_196151_dA);
        } else if (elb instanceof PlayerEntity) {
            PlayerEntity p = (PlayerEntity)elb;
            ret = new ItemStack((IItemProvider)Items.field_196184_dx);
            ret.func_77982_d(new CompoundNBT());
            ret.func_77978_p().func_74778_a("SkullOwner", p.func_200200_C_().getString());
        }
        return ret;
    }

    public static double getAttributeValueHandSensitive(LivingEntity e, Attribute a, Hand h) {
        if (e.func_110148_a(a) == null) {
            return 4.0;
        }
        if (h == Hand.MAIN_HAND) {
            return GeneralUtils.getAttributeValueSafe(e, a);
        }
        ModifiableAttributeInstance mai = new ModifiableAttributeInstance(a, n -> {});
        Collection ignore = e.func_184614_ca().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)a);
        block0: for (AttributeModifier am : e.func_110148_a(a).func_225505_c_()) {
            for (AttributeModifier f : ignore) {
                if (!f.func_111167_a().equals(am.func_111167_a())) continue;
                continue block0;
            }
            mai.func_233767_b_(am);
        }
        for (AttributeModifier f : e.func_184592_cb().func_111283_C(EquipmentSlotType.MAINHAND).get((Object)a)) {
            mai.func_188479_b(f.func_111167_a());
            mai.func_233767_b_(f);
        }
        return mai.func_111126_e();
    }

    public static double getAttributeValueSafe(LivingEntity e, Attribute a) {
        if (e.func_110148_a(a) != null) {
            return e.func_233637_b_(a);
        }
        return a.func_111110_b();
    }

    public static boolean isKitMain(ItemStack is) {
        return is.func_77978_p() != null && is.func_77978_p().func_74767_n("kit");
    }
}

