/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.capability.resources;

import jackiecrazy.footwork.api.WarAttributes;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.event.ConsumeMightEvent;
import jackiecrazy.footwork.event.ConsumePostureEvent;
import jackiecrazy.footwork.event.ConsumeSpiritEvent;
import jackiecrazy.footwork.event.GainBarrierEvent;
import jackiecrazy.footwork.event.GainMightEvent;
import jackiecrazy.footwork.event.GainPostureEvent;
import jackiecrazy.footwork.event.RegenSpiritEvent;
import jackiecrazy.footwork.event.StaggerEvent;
import jackiecrazy.footwork.potion.FootworkEffects;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.config.CombatConfig;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.config.ResourceConfig;
import jackiecrazy.wardance.networking.CombatChannel;
import jackiecrazy.wardance.networking.UpdateClientPacket;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.WarSkills;
import jackiecrazy.wardance.utils.CombatUtils;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CombatCapability
implements ICombatCapability {
    public static final float MAXQI = 10.0f;
    public static final UUID WOUND = UUID.fromString("982bbbb2-bbd0-4166-801a-560d1a4149c8");
    public static final UUID MORE = UUID.fromString("982bbbb2-bbd0-4166-801a-560d1a4149c9");
    private static final AttributeModifier STAGGERA = new AttributeModifier(WOUND, "stagger armor debuff", -7.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier STAGGERSA = new AttributeModifier(MORE, "additional stagger armor penalty", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier STAGGERS = new AttributeModifier(WOUND, "stagger speed debuff", -1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final WeakReference<LivingEntity> dude;
    int lastRangeTick = 0;
    private ItemStack prev;
    private float might;
    private float spirit;
    private float posture;
    private float rank;
    private float mpos;
    private float mspi;
    private float wounding;
    private float burnout;
    private float fatigue;
    private float mainReel;
    private float offReel;
    private float maxMight;
    private float resolve;
    private float barrier;
    private float mbar;
    private float vision;
    private int shatterCD;
    private int qcd;
    private int scd;
    private int pcd;
    private int ccd;
    private int mBind;
    private int oBind;
    private int retina;
    private int staggert;
    private int mstaggert;
    private int mstaggerc;
    private int staggerc;
    private int offhandcd;
    private int barriercd;
    private int roll;
    private int sweepAngle = -1;
    private boolean offhand;
    private boolean combat;
    private long lastUpdate;
    private boolean first;
    private boolean shattering;
    private boolean shieldDown;
    private float cache;
    private int parrying;
    private long staggerTickExisted;
    private int sweeping;
    private int adrenaline;
    private ItemStack tempOffhand = ItemStack.field_190927_a;
    private Vector3d motion;

    public CombatCapability(LivingEntity e) {
        this.dude = new WeakReference<LivingEntity>(e);
        this.setTrueMaxSpirit((float)GeneralUtils.getAttributeValueSafe((LivingEntity)e, (Attribute)((Attribute)WarAttributes.MAX_SPIRIT.get())));
    }

    private static float getMPos(LivingEntity elb) {
        float ret = 1.0f;
        if (elb == null) {
            return ret;
        }
        ret = GeneralUtils.getResourceLocationFromEntity((Entity)elb) != null && CombatUtils.customPosture.containsKey(GeneralUtils.getResourceLocationFromEntity((Entity)elb)) ? CombatUtils.customPosture.get(GeneralUtils.getResourceLocationFromEntity((Entity)elb)).floatValue() : (float)(Math.ceil(9.174311926605505 * (double)elb.func_213311_cf() * (double)elb.func_213302_cg()) + (double)elb.func_70658_aO() / 2.0);
        if (elb instanceof PlayerEntity) {
            ret = (float)((double)ret * 1.5);
        }
        ret = (float)((double)ret + GeneralUtils.getAttributeValueSafe((LivingEntity)elb, (Attribute)((Attribute)WarAttributes.MAX_POSTURE.get())));
        return ret;
    }

    public float getResolve() {
        return this.resolve;
    }

    public void setResolve(float amount) {
        this.resolve = amount;
    }

    public float getMight() {
        return this.might;
    }

    public void setMight(float amount) {
        float cap = this.maxMight;
        this.might = !Float.isFinite(this.might) ? 0.0f : MathHelper.func_76131_a((float)amount, (float)0.0f, (float)cap);
    }

    public float addMight(float amount) {
        GainMightEvent gme = new GainMightEvent((LivingEntity)this.dude.get(), amount);
        MinecraftForge.EVENT_BUS.post((Event)gme);
        if (gme.isCanceled()) {
            return -1.0f;
        }
        amount = gme.getQuantity();
        float temp = this.might + amount;
        this.setMight(temp);
        this.setMightGrace(ResourceConfig.qiGrace);
        this.addRank(amount * 0.1f);
        return temp % 10.0f;
    }

    public boolean consumeMight(float amount, float above) {
        boolean lacking;
        ConsumeMightEvent cse = new ConsumeMightEvent((LivingEntity)this.dude.get(), amount, above);
        MinecraftForge.EVENT_BUS.post((Event)cse);
        amount = cse.getAmount();
        boolean bl = lacking = this.might - amount < above;
        if (cse.isCanceled()) {
            return cse.getResult() == Event.Result.ALLOW || cse.getResult() != Event.Result.DENY && !lacking;
        }
        if (cse.getResult() == Event.Result.DEFAULT && lacking) {
            return false;
        }
        amount = Math.min(amount, this.might - above);
        this.might -= amount;
        return cse.getResult() != Event.Result.DENY;
    }

    public int getMightGrace() {
        return this.qcd;
    }

    public void setMightGrace(int amount) {
        this.qcd = amount;
    }

    public int decrementMightGrace(int amount) {
        this.qcd -= amount;
        if (this.qcd < 0) {
            int temp = this.qcd;
            this.qcd = 0;
            return -temp;
        }
        return 0;
    }

    public float getSpirit() {
        return this.spirit;
    }

    public void setSpirit(float amount) {
        this.spirit = !Float.isFinite(this.spirit) ? 0.0f : MathHelper.func_76131_a((float)amount, (float)0.0f, (float)this.getMaxSpirit());
    }

    public float addSpirit(float amount) {
        float overflow = Math.max(0.0f, this.spirit + amount - this.mspi);
        this.setSpirit(this.spirit + amount);
        return overflow;
    }

    public boolean consumeSpirit(float amount, float above) {
        boolean lacking;
        ConsumeSpiritEvent cse = new ConsumeSpiritEvent((LivingEntity)this.dude.get(), amount, above);
        MinecraftForge.EVENT_BUS.post((Event)cse);
        amount = cse.getAmount();
        boolean bl = lacking = this.spirit - amount < above;
        if (cse.isCanceled()) {
            return cse.getResult() == Event.Result.ALLOW || cse.getResult() != Event.Result.DENY && !lacking;
        }
        if (cse.getResult() == Event.Result.DEFAULT && lacking) {
            return false;
        }
        amount = Math.min(amount, this.spirit - above);
        this.spirit -= amount;
        this.setBurnout(this.getBurnout() + amount * ResourceConfig.burnout);
        this.setSpiritGrace(ResourceConfig.spiritCD);
        return cse.getResult() != Event.Result.DENY;
    }

    public int getSpiritGrace() {
        return this.scd;
    }

    public void setSpiritGrace(int amount) {
        this.scd = amount;
    }

    public int decrementSpiritGrace(int amount) {
        this.scd -= amount;
        if (this.scd < 0) {
            int temp = this.scd;
            this.scd = 0;
            return -temp;
        }
        return 0;
    }

    public float getPosture() {
        return this.posture;
    }

    public void setPosture(float amount) {
        this.posture = !Float.isFinite(this.posture) ? 0.0f : MathHelper.func_76131_a((float)amount, (float)0.0f, (float)this.getMaxPosture());
    }

    public float addPosture(float amount) {
        float overflow = Math.max(0.0f, this.posture + amount - this.getMaxPosture());
        this.setPosture(this.posture + amount);
        return overflow;
    }

    public boolean isFirstStaggerStrike() {
        if (this.dude.get() == null) {
            return false;
        }
        return (long)((LivingEntity)this.dude.get()).field_70173_aa == this.staggerTickExisted;
    }

    public float consumePosture(LivingEntity assailant, float amount, float above, boolean force) {
        float ret = 0.0f;
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null) {
            return ret;
        }
        if (this.staggert > 0) {
            return amount;
        }
        if (!Float.isFinite(this.posture)) {
            this.posture = this.getMaxPosture();
        }
        ConsumePostureEvent cpe = new ConsumePostureEvent(elb, assailant, amount, above);
        MinecraftForge.EVENT_BUS.post((Event)cpe);
        if (cpe.isCanceled()) {
            return 0.0f;
        }
        amount = cpe.getAmount();
        if (cpe.getResult() != Event.Result.ALLOW && amount > this.getTrueMaxPosture() * CombatConfig.posCap && !force) {
            ret = amount - this.getTrueMaxPosture() * CombatConfig.posCap;
            amount = this.getTrueMaxPosture() * CombatConfig.posCap;
        }
        if (elb.func_70644_a(Effects.field_76429_m) && GeneralConfig.resistance) {
            amount *= 1.0f - (float)(elb.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 0.2f;
        }
        if (above > 0.0f && this.posture - amount < above) {
            ret = amount - above;
            amount = this.posture - above;
        } else if (this.posture - amount < 0.0f) {
            this.posture = 0.0f;
            StaggerEvent se = new StaggerEvent(elb, assailant, CombatConfig.staggerDurationMin + Math.max(0, (int)((elb.func_110138_aP() - elb.func_110143_aJ()) / elb.func_110138_aP() * (float)(CombatConfig.staggerDuration - CombatConfig.staggerDurationMin))), CombatConfig.staggerHits);
            MinecraftForge.EVENT_BUS.post((Event)se);
            if (se.isCanceled()) {
                return 0.0f;
            }
            this.setStaggerCount(se.getCount());
            this.setStaggerTime(se.getLength());
            elb.field_70170_p.func_184148_a(null, elb.func_226277_ct_(), elb.func_226278_cu_(), elb.func_226281_cx_(), SoundEvents.field_187929_hc, SoundCategory.PLAYERS, 0.3f + WarDance.rand.nextFloat() * 0.5f, 0.75f + WarDance.rand.nextFloat() * 0.5f);
            elb.func_233575_bb_();
            for (Entity rider : elb.func_184188_bt()) {
                rider.func_233575_bb_();
            }
            this.staggerTickExisted = elb.field_70173_aa;
            return -1.0f;
        }
        float weakness = 1.0f;
        if (elb.func_70644_a(Effects.field_76438_s)) {
            for (int uwu = 0; uwu < elb.func_70660_b(Effects.field_76438_s).func_76458_c() + 1; ++uwu) {
                weakness *= GeneralConfig.hunger;
            }
        }
        float cooldown = (float)ResourceConfig.postureCD * weakness;
        this.posture -= amount;
        this.addFatigue(amount * ResourceConfig.fatigue);
        this.setPostureGrace((int)(cooldown += (float)(ResourceConfig.armorPostureCD * elb.func_70658_aO()) / 20.0f));
        this.sync();
        return ret;
    }

    public int getPostureGrace() {
        return this.pcd;
    }

    public void setPostureGrace(int amount) {
        this.pcd = amount;
    }

    public int decrementPostureGrace(int amount) {
        this.pcd -= amount;
        if (this.pcd < 0) {
            int temp = this.pcd;
            this.pcd = 0;
            return -temp;
        }
        return 0;
    }

    public float getRank() {
        return this.rank;
    }

    public void setRank(float amount) {
        this.rank = !Float.isFinite(this.rank) ? 0.0f : MathHelper.func_76131_a((float)amount, (float)0.0f, (float)10.0f);
    }

    public void setAdrenalineCooldown(int amount) {
        this.adrenaline = amount;
    }

    public boolean halvedAdrenaline() {
        return this.adrenaline != 0;
    }

    public float addRank(float amount) {
        float overflow = Math.max(0.0f, this.rank + amount - 10.0f);
        this.setRank(this.rank + amount);
        return overflow;
    }

    public boolean consumeRank(float amount, float above) {
        if (this.rank - amount < above) {
            return false;
        }
        this.rank -= amount;
        return true;
    }

    public float getTrueMaxPosture() {
        if (this.mpos == 0.0f) {
            this.mpos = CombatCapability.getMPos((LivingEntity)this.dude.get());
        }
        return this.mpos;
    }

    public void setTrueMaxPosture(float amount) {
        float perc = this.posture / this.mpos;
        float temp = this.mpos;
        this.mpos = amount;
        if (this.mpos != temp) {
            this.posture = perc * this.mpos;
        }
        if (Float.isNaN(this.posture)) {
            this.posture = this.mpos;
        }
    }

    public float getTrueMaxSpirit() {
        if (this.mspi == 0.0f) {
            return 10.0f;
        }
        return this.mspi;
    }

    public void setTrueMaxSpirit(float amount) {
        this.mspi = amount;
    }

    public float getMaxMight() {
        return this.maxMight;
    }

    public void setMaxMight(float amount) {
        this.maxMight = amount;
    }

    public int getMaxStaggerTime() {
        return this.mstaggert;
    }

    private void setComboGrace(int amount) {
        this.ccd = amount;
    }

    private int decrementComboGrace(int amount) {
        this.ccd -= amount;
        if (this.ccd < 0) {
            int temp = this.ccd;
            this.ccd = 0;
            return -temp;
        }
        return 0;
    }

    public int getStaggerTime() {
        return this.staggert;
    }

    public void setStaggerTime(int amount) {
        if (amount == 0 && this.staggert > 0 && this.dude.get() != null) {
            LivingEntity elb = (LivingEntity)this.dude.get();
            elb.func_110148_a(Attributes.field_233821_d_).func_188479_b(WOUND);
            elb.func_110148_a(Attributes.field_233826_i_).func_188479_b(WOUND);
            elb.func_110148_a(Attributes.field_233826_i_).func_188479_b(MORE);
            this.mstaggert = 0;
        } else if (this.dude.get() != null && amount > 0 && this.staggert == 0) {
            LivingEntity elb = (LivingEntity)this.dude.get();
            elb.func_110148_a(Attributes.field_233821_d_).func_188479_b(WOUND);
            elb.func_110148_a(Attributes.field_233821_d_).func_233769_c_(STAGGERS);
            elb.func_110148_a(Attributes.field_233826_i_).func_188479_b(WOUND);
            elb.func_110148_a(Attributes.field_233826_i_).func_233769_c_(STAGGERA);
            elb.func_110148_a(Attributes.field_233826_i_).func_188479_b(MORE);
            elb.func_110148_a(Attributes.field_233826_i_).func_233769_c_(STAGGERSA);
        }
        this.mstaggert = Math.max(this.mstaggert, amount);
        this.staggert = amount;
    }

    public int decrementStaggerTime(int amount) {
        if (this.staggert - amount > 0) {
            this.staggert -= amount;
        } else {
            LivingEntity elb = (LivingEntity)this.dude.get();
            if (this.staggert > 0 && elb != null) {
                elb.func_110148_a(Attributes.field_233821_d_).func_188479_b(WOUND);
                elb.func_110148_a(Attributes.field_233826_i_).func_188479_b(WOUND);
                elb.func_110148_a(Attributes.field_233826_i_).func_188479_b(MORE);
                this.setPosture(this.getMaxPosture());
                this.staggerc = 0;
            }
            int temp = this.staggert;
            this.mstaggert = 0;
            this.staggert = 0;
            return -temp;
        }
        return 0;
    }

    public int getMaxStaggerCount() {
        return this.mstaggerc;
    }

    public int getStaggerCount() {
        return this.staggerc;
    }

    public void setStaggerCount(int amount) {
        this.mstaggerc = Math.max(this.mstaggerc, amount);
        this.staggerc = amount;
    }

    public void decrementStaggerCount(int amount) {
        if (this.staggerc - amount > 0) {
            this.staggerc -= amount;
        } else {
            this.setStaggerTime(0);
            this.setPosture(this.getMaxPosture());
            this.staggerc = 0;
            this.mstaggerc = 0;
        }
    }

    public float getMaxBarrier() {
        return this.mbar;
    }

    public void setMaxBarrier(float amount) {
        this.mbar = amount;
    }

    public int getBarrierCooldown() {
        return this.barriercd;
    }

    public void setBarrierCooldown(int amount) {
        this.barriercd = amount;
    }

    public void decrementBarrierCooldown(int amount) {
        this.barriercd = this.barriercd - amount > 0 ? (this.barriercd -= amount) : 0;
    }

    public float getBarrier() {
        return this.barrier;
    }

    public void setBarrier(float amount) {
        this.barrier = amount;
    }

    public float consumeBarrier(float amount) {
        float prev;
        if (this.shieldDown) {
            return 0.0f;
        }
        if (this.barrier - amount > 0.0f) {
            prev = amount;
            this.barrier -= amount;
        } else {
            prev = this.barrier;
            this.barrier = 0.0f;
            this.shieldDown = true;
        }
        this.setBarrierCooldown((int)((LivingEntity)this.dude.get()).func_233637_b_((Attribute)WarAttributes.BARRIER_COOLDOWN.get()));
        return prev;
    }

    public void addBarrier(float amount) {
        this.barrier += amount;
        float max = this.getMaxBarrier();
        if (this.barrier > max) {
            this.barrier = max;
            this.shieldDown = max == 0.0f;
        }
    }

    public int getOffhandCooldown() {
        return this.offhandcd;
    }

    public void setOffhandCooldown(int amount) {
        this.offhandcd = amount;
    }

    public void addOffhandCooldown(int amount) {
        this.offhandcd += amount;
    }

    public int getRollTime() {
        return this.roll;
    }

    public void setRollTime(int amount) {
        this.roll = amount;
    }

    public void decrementRollTime(int amount) {
        if (this.roll + amount < 0) {
            this.roll += amount;
        } else if (this.roll - amount > 0) {
            this.roll -= amount;
        } else if (this.roll != 0) {
            if (this.dude.get() instanceof PlayerEntity) {
                PlayerEntity p = (PlayerEntity)this.dude.get();
                p.setForcedPose(null);
            }
            this.roll = 0;
        }
    }

    public boolean isOffhandAttack() {
        return this.offhand;
    }

    public void setOffhandAttack(boolean off) {
        this.offhand = off;
    }

    public boolean isCombatMode() {
        return this.combat;
    }

    public void toggleCombatMode(boolean on) {
        this.combat = on;
    }

    public float getWounding() {
        return this.wounding;
    }

    public void setWounding(float amount) {
        this.wounding = Math.max(0.0f, amount);
        if (this.dude.get() != null) {
            boolean reg;
            if (!ResourceConfig.immortalWL == (reg = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((LivingEntity)this.dude.get()).func_200600_R()) != null && ResourceConfig.immortal.contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((LivingEntity)this.dude.get()).func_200600_R()).toString()))) {
                this.wounding = 0.0f;
            }
            ((LivingEntity)this.dude.get()).func_110148_a(Attributes.field_233818_a_).func_188479_b(WOUND);
            ((LivingEntity)this.dude.get()).func_110148_a(Attributes.field_233818_a_).func_233767_b_(new AttributeModifier(WOUND, "wounding", (double)(-this.wounding), AttributeModifier.Operation.ADDITION));
        }
    }

    public float getFatigue() {
        return this.fatigue;
    }

    public void setFatigue(float amount) {
        boolean reg;
        this.fatigue = Math.max(0.0f, amount);
        if (this.dude.get() != null && !ResourceConfig.immortalWL == (reg = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((LivingEntity)this.dude.get()).func_200600_R()) != null && ResourceConfig.immortal.contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((LivingEntity)this.dude.get()).func_200600_R()).toString()))) {
            this.fatigue = 0.0f;
        }
    }

    public float getBurnout() {
        return this.burnout;
    }

    public void setBurnout(float amount) {
        boolean reg;
        this.burnout = Math.max(0.0f, amount);
        if (this.dude.get() != null && !ResourceConfig.immortalWL == (reg = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((LivingEntity)this.dude.get()).func_200600_R()) != null && ResourceConfig.immortal.contains(ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)((LivingEntity)this.dude.get()).func_200600_R()).toString()))) {
            this.burnout = 0.0f;
        }
    }

    public void addWounding(float amount) {
        this.setWounding(this.wounding + amount);
    }

    public void addFatigue(float amount) {
        this.setFatigue(this.fatigue + amount);
    }

    public void addBurnout(float amount) {
        this.setBurnout(this.burnout + amount);
    }

    public int getHandBind(Hand h) {
        if (h == Hand.OFF_HAND) {
            return this.oBind;
        }
        return this.mBind;
    }

    public void setHandBind(Hand h, int amount) {
        switch (h) {
            case MAIN_HAND: {
                this.mBind = amount;
                break;
            }
            case OFF_HAND: {
                this.oBind = amount;
            }
        }
    }

    public void decrementHandBind(Hand h, int amount) {
        switch (h) {
            case MAIN_HAND: {
                this.mBind -= Math.min(amount, this.mBind);
                break;
            }
            case OFF_HAND: {
                this.oBind -= Math.min(amount, this.oBind);
            }
        }
    }

    public float getHandReel(Hand hand) {
        if (hand == Hand.OFF_HAND) {
            return this.offReel;
        }
        return this.mainReel;
    }

    public void setHandReel(Hand hand, float value) {
        if (hand == Hand.OFF_HAND) {
            this.offReel = value;
        } else {
            this.mainReel = value;
        }
    }

    public boolean consumeShatter(float value) {
        this.shattering = true;
        return this.shatterCD > 0;
    }

    public int getShatterCooldown() {
        return this.shatterCD;
    }

    public void setShatterCooldown(int value) {
        this.shattering = value != 0;
        this.shatterCD = value;
    }

    public int decrementShatterCooldown(int value) {
        int ret = 0;
        this.shatterCD -= value;
        if (this.shatterCD < 0) {
            ret = -this.shatterCD;
            this.shatterCD = 0;
        }
        return ret;
    }

    public float getCachedCooldown() {
        return this.cache;
    }

    public void setCachedCooldown(float value) {
        this.cache = value;
    }

    public int getForcedSweep() {
        return this.sweepAngle;
    }

    public void setForcedSweep(int angle) {
        this.sweepAngle = angle;
    }

    public void clientTick() {
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null) {
            return;
        }
        if (this.prev == null || !ItemStack.func_77989_b((ItemStack)elb.func_184592_cb(), (ItemStack)this.prev)) {
            this.prev = elb.func_184592_cb();
            this.offhandcd = 0;
        }
    }

    public void serverTick() {
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null) {
            return;
        }
        int ticks = (int)(elb.field_70170_p.func_82737_E() - this.lastUpdate);
        if (ticks < 1) {
            return;
        }
        this.vision = (float)elb.func_233637_b_(Attributes.field_233819_b_);
        if (elb.func_70644_a((Effect)FootworkEffects.SLEEP.get()) || elb.func_70644_a((Effect)FootworkEffects.PARALYSIS.get()) || elb.func_70644_a((Effect)FootworkEffects.PETRIFY.get())) {
            this.vision = -1.0f;
        }
        this.setTrueMaxPosture(CombatCapability.getMPos(elb));
        this.setTrueMaxSpirit((float)elb.func_233637_b_((Attribute)WarAttributes.MAX_SPIRIT.get()));
        this.setMaxMight((float)elb.func_233637_b_((Attribute)WarAttributes.MAX_MIGHT.get()));
        this.setMaxBarrier((float)(elb.func_233637_b_((Attribute)WarAttributes.BARRIER.get()) * (double)this.getMaxPosture()));
        int light = StealthUtils.getActualLightLevel((World)elb.field_70170_p, (BlockPos)elb.func_233580_cy_());
        for (long x = this.lastUpdate + (long)ticks; x > this.lastUpdate; --x) {
            if (x % 3L != 0L) continue;
            if (light > this.retina) {
                ++this.retina;
            }
            if (light >= this.retina) continue;
            --this.retina;
        }
        if (this.first) {
            this.setPosture(this.getMaxPosture());
        }
        if (ticks > 5 || (this.lastUpdate + (long)ticks) % 5L != this.lastUpdate % 5L) {
            this.motion = elb.func_213303_ch();
        }
        if (this.adrenaline > 0) {
            this.adrenaline -= Math.min(this.adrenaline, ticks);
        }
        int qiExtra = this.decrementMightGrace(ticks);
        int spExtra = this.decrementSpiritGrace(ticks);
        int poExtra = this.decrementPostureGrace(ticks);
        for (Hand h : Hand.values()) {
            this.decrementHandBind(h, ticks);
            if (this.getHandBind(h) == 0) continue;
            CombatUtils.setHandCooldown(elb, h, 0.0f, true);
        }
        this.addOffhandCooldown(ticks);
        this.decrementRollTime(ticks);
        this.decrementBarrierCooldown(ticks);
        this.decrementStaggerTime(ticks);
        if (this.getPostureGrace() == 0 && this.getStaggerTime() == 0 && this.getPosture() < this.getMaxPosture()) {
            this.addPosture(this.getPPT() * (float)poExtra);
        }
        if (this.getBarrierCooldown() == 0 && this.getStaggerTime() == 0) {
            this.addBarrier(this.getBPT() * (float)ticks);
        }
        if (this.getMaxBarrier() == 0.0f) {
            this.shieldDown = true;
        }
        if (this.shieldDown) {
            for (Hand h : Hand.values()) {
                if (!CombatUtils.isShield(elb, elb.func_184586_b(h)) || this.getHandBind(h) >= 5) continue;
                this.setHandBind(h, 7);
            }
        }
        float nausea = elb instanceof PlayerEntity || !elb.func_70644_a(Effects.field_76431_k) ? 0.0f : (float)(elb.func_70660_b(Effects.field_76431_k).func_76458_c() + 1) * GeneralConfig.nausea;
        this.addPosture(-nausea * (float)ticks);
        if (this.shatterCD <= 0) {
            this.shatterCD += ticks;
            if (this.shatterCD >= 0) {
                this.shattering = false;
                this.shatterCD = (int)GeneralUtils.getAttributeValueSafe((LivingEntity)elb, (Attribute)((Attribute)WarAttributes.SHATTER.get()));
            }
        } else if (this.shattering) {
            this.shatterCD -= ticks;
            if (this.shatterCD <= 0) {
                this.shatterCD = -ResourceConfig.shatterCooldown;
            }
        } else {
            this.shatterCD = (int)GeneralUtils.getAttributeValueSafe((LivingEntity)elb, (Attribute)((Attribute)WarAttributes.SHATTER.get()));
        }
        if (this.getSpiritGrace() == 0 && this.getStaggerTime() == 0 && this.getSpirit() < this.getMaxSpirit()) {
            this.addSpirit(this.getSPT() * (float)spExtra);
        }
        if (this.getMightGrace() == 0) {
            float over = (float)qiExtra * 0.01f;
            float decay = this.getMight();
            this.setMight(this.getMight() - over);
            this.setResolve(this.resolve + (decay -= this.getMight()));
        }
        if (this.might == 0.0f) {
            float decay = 0.01f;
            if (this.getComboRank() == 6) {
                decay = 0.025f;
            }
            if (this.getComboRank() == 7) {
                decay = 0.05f;
            }
            this.rank -= (decay *= (float)ticks);
            if (this.rank < 0.0f && elb instanceof PlayerEntity) {
                this.rank = 0.0f;
                this.addFatigue(-decay);
                this.addWounding(-decay);
                this.addBurnout(-decay);
            }
        }
        if (this.prev == null || !ItemStack.func_77989_b((ItemStack)elb.func_184592_cb(), (ItemStack)this.prev)) {
            this.prev = elb.func_184592_cb();
            this.setOffhandCooldown(0);
        }
        this.lastUpdate = elb.field_70170_p.func_82737_E();
        this.first = false;
        this.sync();
    }

    public void sync() {
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null || elb.field_70170_p.field_72995_K) {
            return;
        }
        CombatChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> elb), (Object)new UpdateClientPacket(elb.func_145782_y(), this.quickWrite()));
        if (!(elb instanceof FakePlayer) && elb instanceof ServerPlayerEntity) {
            CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)elb), (Object)new UpdateClientPacket(elb.func_145782_y(), this.write()));
        }
    }

    public ItemStack getTempItemStack() {
        return this.tempOffhand;
    }

    public void setTempItemStack(ItemStack is) {
        this.tempOffhand = is == null ? ItemStack.field_190927_a : is;
    }

    public void read(CompoundNBT c) {
        int temp = this.roll;
        this.setTrueMaxSpirit(c.func_74760_g("maxspi"));
        this.setMaxMight(c.func_74760_g("maxmight"));
        this.setBurnout(c.func_74760_g("burnout"));
        this.setWounding(c.func_74760_g("wounding"));
        this.setTrueMaxPosture(c.func_74760_g("maxpos"));
        this.setPosture(c.func_74760_g("posture"));
        this.setFatigue(c.func_74760_g("fatigue"));
        this.setStaggerTime(c.func_74762_e("staggert"));
        this.lastUpdate = c.func_74763_f("lastUpdate");
        this.setShatterCooldown(c.func_74762_e("shattercd"));
        this.setMaxBarrier(c.func_74760_g("maxBarrier"));
        this.setBarrier(c.func_74760_g("barrier"));
        this.mstaggerc = c.func_74762_e("mstaggerc");
        this.mstaggert = c.func_74762_e("mstaggert");
        this.setStaggerCount(c.func_74762_e("staggerc"));
        this.retina = c.func_74762_e("retina");
        this.vision = c.func_74760_g("vision");
        this.shieldDown = c.func_74767_n("shieldDown");
        if (!c.func_74764_b("qi")) {
            return;
        }
        this.setMight(c.func_74760_g("qi"));
        this.setResolve(c.func_74760_g("resolve"));
        this.setRank(c.func_74760_g("combo"));
        this.setSpirit(c.func_74760_g("spirit"));
        this.setMightGrace(c.func_74762_e("qicd"));
        this.setPostureGrace(c.func_74762_e("posturecd"));
        this.setSpiritGrace(c.func_74762_e("spiritcd"));
        this.setBarrierCooldown(c.func_74762_e("shield"));
        this.setOffhandCooldown(c.func_74762_e("offhandcd"));
        this.setRollTime(c.func_74762_e("roll"));
        this.setHandBind(Hand.MAIN_HAND, c.func_74762_e("mainBind"));
        this.setHandBind(Hand.OFF_HAND, c.func_74762_e("offBind"));
        this.setOffhandAttack(c.func_74767_n("offhand"));
        this.toggleCombatMode(c.func_74767_n("combat"));
        this.setForcedSweep(c.func_74762_e("sweep"));
        this.setHandReel(Hand.MAIN_HAND, c.func_74760_g("mainReel"));
        this.setHandReel(Hand.OFF_HAND, c.func_74760_g("offReel"));
        this.first = c.func_74767_n("first");
        this.adrenaline = c.func_74762_e("adrenaline");
        this.parrying = c.func_74762_e("parrying");
        this.setTempItemStack(ItemStack.func_199557_a((CompoundNBT)c.func_74775_l("temp")));
        if (this.dude.get() instanceof PlayerEntity) {
            if (this.getRollTime() > CombatConfig.rollEndsAt && c.func_74767_n("rolling")) {
                ((PlayerEntity)this.dude.get()).setForcedPose(Pose.SLEEPING);
            } else if (temp == CombatConfig.rollEndsAt) {
                ((PlayerEntity)this.dude.get()).setForcedPose(null);
            }
        }
    }

    public int getParryingTick() {
        return this.parrying;
    }

    public void setParryingTick(int parrying) {
        this.parrying = parrying;
    }

    public int getSweepTick() {
        return this.sweeping;
    }

    public void setSweepTick(int tick) {
        this.sweeping = tick;
    }

    public boolean isValid() {
        return true;
    }

    public Vector3d getMotionConsistently() {
        if (this.dude.get() == null || this.motion == null) {
            return Vector3d.field_186680_a;
        }
        return ((LivingEntity)this.dude.get()).func_213303_ch().func_178788_d(this.motion).func_186678_a(0.25);
    }

    public CompoundNBT write() {
        CompoundNBT c = new CompoundNBT();
        c.func_74768_a("retina", this.getRetina());
        c.func_74776_a("vision", this.visionRange());
        c.func_74776_a("qi", this.getMight());
        c.func_74776_a("resolve", this.getResolve());
        c.func_74776_a("posture", this.getPosture());
        c.func_74776_a("combo", this.getRank());
        c.func_74776_a("spirit", this.getSpirit());
        c.func_74776_a("maxpos", this.getTrueMaxPosture());
        c.func_74776_a("maxspi", this.getTrueMaxSpirit());
        c.func_74776_a("burnout", this.getBurnout());
        c.func_74776_a("fatigue", this.getFatigue());
        c.func_74776_a("wounding", this.getWounding());
        c.func_74776_a("maxmight", this.getMaxMight());
        c.func_74768_a("qicd", this.getMightGrace());
        c.func_74768_a("posturecd", this.getPostureGrace());
        c.func_74768_a("spiritcd", this.getSpiritGrace());
        c.func_74768_a("shield", this.getBarrierCooldown());
        c.func_74768_a("mstaggerc", this.getMaxStaggerCount());
        c.func_74768_a("mstaggert", this.getMaxStaggerTime());
        c.func_74768_a("staggerc", this.getStaggerCount());
        c.func_74768_a("staggert", this.getStaggerTime());
        c.func_74768_a("offhandcd", this.getOffhandCooldown());
        c.func_74768_a("roll", this.getRollTime());
        c.func_74768_a("mainBind", this.getHandBind(Hand.MAIN_HAND));
        c.func_74768_a("offBind", this.getHandBind(Hand.OFF_HAND));
        c.func_74776_a("mainReel", this.getHandReel(Hand.MAIN_HAND));
        c.func_74776_a("offReel", this.getHandReel(Hand.OFF_HAND));
        c.func_74757_a("offhand", this.isOffhandAttack());
        c.func_74757_a("combat", this.isCombatMode());
        c.func_74772_a("lastUpdate", this.lastUpdate);
        c.func_74776_a("maxBarrier", this.mbar);
        c.func_74776_a("barrier", this.barrier);
        c.func_74757_a("first", this.first);
        c.func_74768_a("parrying", this.parrying);
        c.func_74768_a("adrenaline", this.adrenaline);
        c.func_74768_a("shattercd", this.getShatterCooldown());
        c.func_74768_a("sweep", this.getForcedSweep());
        c.func_74757_a("rolling", this.dude.get() instanceof PlayerEntity && ((PlayerEntity)this.dude.get()).getForcedPose() == Pose.SLEEPING);
        c.func_74757_a("shieldDown", this.shieldDown);
        if (!this.tempOffhand.func_190926_b()) {
            c.func_218657_a("temp", (INBT)this.tempOffhand.func_77955_b(new CompoundNBT()));
        }
        return c;
    }

    public void addRangedMight(boolean pass) {
        LivingEntity shooter = (LivingEntity)this.dude.get();
        if (shooter == null) {
            return;
        }
        if (pass) {
            this.addMight(MathHelper.func_76131_a((float)((float)(shooter.field_70173_aa - this.lastRangeTick) * 0.01f), (float)0.0f, (float)0.3f));
        }
        this.lastRangeTick = shooter.field_70173_aa;
    }

    public int getRetina() {
        return this.retina;
    }

    public float visionRange() {
        return this.vision;
    }

    public CompoundNBT quickWrite() {
        CompoundNBT c = new CompoundNBT();
        c.func_74776_a("posture", this.getPosture());
        c.func_74776_a("maxpos", this.getTrueMaxPosture());
        c.func_74776_a("fatigue", this.getFatigue());
        c.func_74768_a("staggert", this.getStaggerTime());
        c.func_74768_a("mstaggert", this.getMaxStaggerTime());
        c.func_74768_a("staggerc", this.getStaggerCount());
        c.func_74768_a("mstaggerc", this.getMaxStaggerCount());
        c.func_74772_a("lastUpdate", this.lastUpdate);
        c.func_74768_a("shattercd", this.getShatterCooldown());
        c.func_74776_a("maxBarrier", this.mbar);
        c.func_74776_a("barrier", this.barrier);
        c.func_74768_a("retina", this.retina);
        c.func_74776_a("vision", this.vision);
        return c;
    }

    private float getPPT() {
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null) {
            return 0.0f;
        }
        int exp = elb.func_70644_a(Effects.field_76436_u) ? elb.func_70660_b(Effects.field_76436_u).func_76458_c() + 1 : 0;
        float poison = 1.0f;
        for (int j = 0; j < exp; ++j) {
            poison *= GeneralConfig.poison;
        }
        float exhaustMod = Math.max(0.0f, elb.func_70644_a((Effect)FootworkEffects.EXHAUSTION.get()) ? 1.0f - (float)elb.func_70660_b((Effect)FootworkEffects.EXHAUSTION.get()).func_76458_c() * 0.2f : 1.0f);
        float armorMod = 2.5f + (float)Math.min(elb.func_70658_aO(), 20) * 0.125f;
        float cooldownMod = Math.min(CombatUtils.getCooledAttackStrength(elb, Hand.MAIN_HAND, 0.5f), CombatUtils.getCooledAttackStrength(elb, Hand.MAIN_HAND, 0.5f));
        float healthMod = 0.25f + elb.func_110143_aJ() / elb.func_110138_aP() * 0.75f;
        if (CasterData.getCap(elb).isSkillUsable((Skill)WarSkills.BOULDER_BRACE.get())) {
            armorMod = 2.5f;
            healthMod = 1.0f;
        }
        float ret = this.getMaxPosture() / (armorMod * 20.0f) * cooldownMod * exhaustMod * healthMod * poison;
        GainPostureEvent ev = new GainPostureEvent(elb, ret);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getQuantity();
    }

    private float getBPT() {
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null) {
            return 0.0f;
        }
        int exp = elb.func_70644_a(Effects.field_76436_u) ? elb.func_70660_b(Effects.field_76436_u).func_76458_c() + 1 : 0;
        float poison = 1.0f;
        for (int j = 0; j < exp; ++j) {
            poison *= GeneralConfig.poison;
        }
        float exhaustMod = Math.max(0.0f, elb.func_70644_a((Effect)FootworkEffects.EXHAUSTION.get()) ? 1.0f - (float)elb.func_70660_b((Effect)FootworkEffects.EXHAUSTION.get()).func_76458_c() * 0.2f : 1.0f);
        float armorMod = 2.5f + (float)Math.min(elb.func_70658_aO(), 20) * 0.125f;
        float healthMod = 0.25f + elb.func_110143_aJ() / elb.func_110138_aP() * 0.75f;
        if (CasterData.getCap(elb).isSkillUsable((Skill)WarSkills.BOULDER_BRACE.get())) {
            armorMod = 2.5f;
            healthMod = 1.0f;
        }
        float ret = this.getMaxPosture() / (armorMod * 20.0f) * exhaustMod * healthMod * poison;
        GainBarrierEvent ev = new GainBarrierEvent(elb, ret);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getQuantity();
    }

    private float getSPT() {
        LivingEntity elb = (LivingEntity)this.dude.get();
        if (elb == null) {
            return 0.0f;
        }
        int exp = elb.func_70644_a(Effects.field_76436_u) ? elb.func_70660_b(Effects.field_76436_u).func_76458_c() + 1 : 0;
        float poison = 1.0f;
        for (int j = 0; j < exp; ++j) {
            poison *= GeneralConfig.poison;
        }
        float exhaustMod = Math.max(0.0f, elb.func_70644_a((Effect)FootworkEffects.EXHAUSTION.get()) ? 1.0f - (float)elb.func_70660_b((Effect)FootworkEffects.EXHAUSTION.get()).func_76458_c() * 0.2f : 1.0f);
        float armorMod = 5.0f + (float)Math.min(elb.func_70658_aO(), 20) * 0.25f;
        float ret = this.getMaxSpirit() / (armorMod * 20.0f) * exhaustMod * poison;
        RegenSpiritEvent ev = new RegenSpiritEvent(elb, ret);
        MinecraftForge.EVENT_BUS.post((Event)ev);
        return ev.getQuantity();
    }
}

