/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.capability.skill;

import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.networking.CombatChannel;
import jackiecrazy.wardance.networking.SyncSkillPacket;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraftforge.fml.network.PacketDistributor;

public class SkillCapability
implements ISkillCapability {
    private final HashMap<Skill, SkillData> data = new HashMap();
    private final List<Skill> equippedSkill = new ArrayList<Skill>(10);
    private final List<Skill> skillList = new ArrayList<Skill>();
    private final WeakReference<LivingEntity> dude;
    private final Queue<Skill> lastCast = new LinkedList<Skill>();
    boolean sync = false;
    boolean fastSync = false;
    boolean gatedSkills = false;
    int index = -1;

    public SkillCapability(LivingEntity attachTo) {
        this.dude = new WeakReference<LivingEntity>(attachTo);
    }

    private SkillData nonNullGet(Skill d) {
        SkillData data = this.data.get((Object)d);
        if (data == null) {
            this.data.put(d, new SkillData(d, 0.0f, 0.0f));
            data = this.data.get((Object)d);
        }
        return data;
    }

    @Override
    public boolean isSkillSelectable(Skill s) {
        LivingEntity bruv = (LivingEntity)this.dude.get();
        if (bruv != null) {
            if (!s.isSelectable(bruv)) {
                return false;
            }
            return this.skillList.contains((Object)s) == this.gatedSkills;
        }
        return true;
    }

    @Override
    public void setSkillSelectable(Skill s, boolean selectable) {
        if (selectable == this.gatedSkills) {
            if (!this.skillList.contains((Object)s)) {
                this.skillList.add(s);
            }
        } else {
            this.skillList.remove((Object)s);
        }
        this.sync = true;
    }

    @Override
    public List<Skill> getSelectableList() {
        return this.skillList;
    }

    @Override
    public Optional<SkillData> getSkillData(Skill s) {
        return Optional.ofNullable(this.data.get((Object)s));
    }

    @Override
    public Skill.STATE getSkillState(Skill s) {
        if (!this.data.containsKey((Object)s)) {
            return Skill.STATE.INACTIVE;
        }
        return this.data.get((Object)s).getState();
    }

    @Override
    @Nullable
    public Skill getHolsteredSkill() {
        if (this.index < 0) {
            return null;
        }
        Skill ret = this.equippedSkill.get(this.index % this.equippedSkill.size());
        if (this.getSkillState(ret) != Skill.STATE.HOLSTERED) {
            ret = null;
        }
        return ret;
    }

    @Override
    public void holsterSkill(int index) {
        Skill to = this.equippedSkill.get(index % this.equippedSkill.size());
        if (to != null && to.castingCheck((LivingEntity)this.dude.get()) != Skill.CastStatus.ALLOWED) {
            return;
        }
        for (Skill s : this.equippedSkill) {
            if (s == null || this.getSkillState(s) != Skill.STATE.HOLSTERED) continue;
            this.changeSkillState(s, Skill.STATE.INACTIVE);
        }
        this.index = index;
        if (to != null) {
            this.changeSkillState(to, Skill.STATE.HOLSTERED);
            this.nonNullGet(to).markDirty();
            this.fastSync = true;
        }
        this.sync = true;
    }

    @Override
    public boolean changeSkillState(Skill d, Skill.STATE to) {
        SkillData data = this.nonNullGet(d);
        if (data != null && data.getState() == Skill.STATE.ACTIVE && GeneralConfig.debug) {
            WarDance.LOGGER.debug("skill " + (Object)((Object)d) + " is already active, overwriting.");
        }
        boolean update = d.onStateChange((LivingEntity)this.dude.get(), data, data.getState(), to);
        data.markDirty();
        this.fastSync = true;
        return update;
    }

    @Override
    public Map<Skill, SkillData> getAllSkillData() {
        return this.data;
    }

    @Override
    public Skill.STATE getCategoryState(SkillCategory skill) {
        for (Skill s : new ArrayList<Skill>(this.data.keySet())) {
            if (s == null || !s.getParentCategory().equals(skill)) continue;
            return this.getSkillState(s);
        }
        return Skill.STATE.INACTIVE;
    }

    @Override
    public boolean isTagActive(String tag) {
        for (SkillData e : new ArrayList<SkillData>(this.data.values())) {
            if (e.getState() != Skill.STATE.ACTIVE || !e.getSkill().getTags((LivingEntity)this.dude.get()).func_230235_a_((Object)tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeActiveTag(String tag) {
        for (Map.Entry<Skill, SkillData> e : this.data.entrySet()) {
            if (!e.getKey().getTags((LivingEntity)this.dude.get()).func_230235_a_((Object)tag)) continue;
            this.changeSkillState(e.getKey(), Skill.STATE.INACTIVE);
        }
    }

    @Override
    public Skill getEquippedVariation(SkillCategory other) {
        for (Skill k : new ArrayList<Skill>(this.equippedSkill)) {
            if (k == null || k.getParentCategory() != other) continue;
            return k;
        }
        return null;
    }

    @Override
    public List<Skill> getEquippedSkills() {
        return this.equippedSkill;
    }

    @Override
    public void setEquippedSkills(List<Skill> skills) {
        this.equippedSkill.clear();
        this.equippedSkill.addAll(skills);
        this.sync = true;
    }

    @Override
    public boolean isSkillUsable(Skill skill) {
        if (skill == null) {
            return false;
        }
        if (!this.isSkillSelectable(skill)) {
            return false;
        }
        if (!this.equippedSkill.contains((Object)skill)) {
            return false;
        }
        return skill.castingCheck((LivingEntity)this.dude.get()) == Skill.CastStatus.ALLOWED || skill.castingCheck((LivingEntity)this.dude.get()) == Skill.CastStatus.ACTIVE;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT to = new CompoundNBT();
        to.func_74768_a("holster", this.index);
        to.func_74757_a("gamerule", this.gatedSkills);
        if (!this.data.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (SkillData effectinstance : this.data.values()) {
                listnbt.add((Object)effectinstance.write(new CompoundNBT()));
            }
            to.func_218657_a("skillData", (INBT)listnbt);
        }
        for (int a = 0; a < this.equippedSkill.size(); ++a) {
            if (this.equippedSkill.get(a) == null) continue;
            to.func_74778_a("equippedSkill" + a, this.equippedSkill.get(a).getRegistryName().toString());
        }
        ListNBT str = new ListNBT();
        for (Skill add : this.skillList) {
            str.add((Object)StringNBT.func_229705_a_((String)add.getRegistryName().toString()));
        }
        to.func_218657_a("randomList", (INBT)str);
        return to;
    }

    @Override
    public void read(CompoundNBT from) {
        if (!from.func_74767_n("fast")) {
            this.data.clear();
            this.index = from.func_74762_e("holster");
            this.gatedSkills = from.func_74767_n("gamerule");
            Skill[] als = new Skill[10];
            for (int a = 0; a < als.length; ++a) {
                if (!from.func_74764_b("equippedSkill" + a)) continue;
                als[a] = Skill.getSkill(from.func_74779_i("equippedSkill" + a));
            }
            this.skillList.clear();
            if (from.func_150297_b("randomList", 9)) {
                ListNBT list = from.func_150295_c("randomList", 8);
                for (Object s : list.toArray()) {
                    if (!(s instanceof StringNBT) || Skill.getSkill(((StringNBT)s).func_150285_a_()) == null) continue;
                    this.skillList.add(Skill.getSkill(((StringNBT)s).func_150285_a_()));
                }
            }
            this.equippedSkill.clear();
            this.equippedSkill.addAll(Arrays.asList(als));
        }
        if (from.func_150297_b("skillData", 9)) {
            ListNBT listnbt = from.func_150295_c("skillData", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                SkillData data = SkillData.read(compoundnbt);
                if (data == null) continue;
                this.data.put(data.getSkill(), data);
            }
        }
    }

    private CompoundNBT fastWrite() {
        CompoundNBT to = new CompoundNBT();
        if (!this.data.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (SkillData effectinstance : this.data.values()) {
                if (!effectinstance._isDirty()) continue;
                listnbt.add((Object)effectinstance.write(new CompoundNBT()));
            }
            if (!listnbt.isEmpty()) {
                to.func_218657_a("skillData", (INBT)listnbt);
                to.func_74757_a("fast", true);
            }
        }
        return to;
    }

    @Override
    public void update() {
        CompoundNBT written;
        LivingEntity caster = (LivingEntity)this.dude.get();
        if (caster == null) {
            return;
        }
        boolean gate = caster.field_70170_p.func_82736_K().func_223586_b(WarDance.GATED_SKILLS);
        this.sync |= this.gatedSkills != gate;
        this.gatedSkills = gate;
        for (SkillData d : this.data.values()) {
            if (d == null || d.getSkill() == null || !d.getSkill().equippedTick(caster, d)) continue;
            d.markDirty();
            this.fastSync = true;
        }
        for (SkillData s : this.getAllSkillData().values()) {
            if (s.getDuration() < 0.0f && s.getState() == Skill.STATE.ACTIVE) {
                this.lastCast.add(s.getSkill());
                while (this.lastCast.size() > 5) {
                    this.lastCast.remove();
                }
                this.changeSkillState(s.getSkill(), Skill.STATE.COOLING);
                continue;
            }
            if (!(s.getDuration() <= 0.0f) || s.getState() != Skill.STATE.COOLING) continue;
            this.changeSkillState(s.getSkill(), Skill.STATE.INACTIVE);
        }
        if (this.sync && caster instanceof ServerPlayerEntity) {
            CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)caster), (Object)new SyncSkillPacket(this.write()));
        } else if (caster instanceof ServerPlayerEntity && !(written = this.fastWrite()).isEmpty()) {
            CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)caster), (Object)new SyncSkillPacket(written));
        }
        this.sync = false;
    }

    @Override
    public Skill[] getPastCasts() {
        return this.lastCast.toArray(new Skill[5]);
    }
}

