/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.capability.status;

import com.google.common.collect.Maps;
import jackiecrazy.wardance.WarDance;
import jackiecrazy.wardance.capability.status.IMark;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.handlers.EntityHandler;
import jackiecrazy.wardance.networking.CombatChannel;
import jackiecrazy.wardance.networking.UpdateAfflictionPacket;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategory;
import jackiecrazy.wardance.skill.SkillData;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fml.network.PacketDistributor;

public class Mark
implements IMark {
    private final Map<Skill, SkillData> statuus = Maps.newHashMap();
    private final WeakReference<LivingEntity> dude;
    boolean sync = false;

    public Mark(LivingEntity attachTo) {
        this.dude = new WeakReference<LivingEntity>(attachTo);
    }

    @Override
    public Optional<SkillData> getActiveMark(Skill s) {
        return Optional.ofNullable(this.statuus.get((Object)s));
    }

    @Override
    public void mark(SkillData d) {
        SkillData sd;
        if (this.dude.get() == null) {
            return;
        }
        if (this.statuus.containsKey((Object)d.getSkill()) && GeneralConfig.debug) {
            WarDance.LOGGER.warn("status " + d + " is already active, merging according to rules.");
        }
        if ((sd = d.getSkill().onMarked(d.getCaster(((LivingEntity)this.dude.get()).field_70170_p), (LivingEntity)this.dude.get(), d, this.statuus.get((Object)d.getSkill()))) != null) {
            this.statuus.put(d.getSkill(), sd);
        } else {
            this.statuus.remove((Object)d.getSkill());
        }
        this.sync = true;
    }

    @Override
    public void removeMark(Skill s) {
        SkillData sd = this.statuus.get((Object)s);
        LivingEntity victim = (LivingEntity)this.dude.get();
        if (sd != null && victim != null) {
            sd.getSkill().onMarkEnd(sd.getCaster(victim.field_70170_p), victim, sd);
        }
        this.sync = true;
        this.statuus.remove((Object)s);
    }

    @Override
    public Map<Skill, SkillData> getActiveMarks() {
        return this.statuus;
    }

    @Override
    public void clearMarks() {
        for (Skill s : new HashSet<Skill>(this.statuus.keySet())) {
            this.removeMark(s);
        }
    }

    @Override
    public boolean isMarked(Skill skill) {
        return this.statuus.containsKey((Object)skill);
    }

    @Override
    public boolean isMarked(SkillCategory skill) {
        for (Skill s : this.statuus.keySet()) {
            if (s == null || s.getParentCategory() != skill) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT write() {
        CompoundNBT to = new CompoundNBT();
        if (!this.statuus.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (SkillData effectinstance : this.statuus.values()) {
                listnbt.add((Object)effectinstance.write(new CompoundNBT()));
            }
            to.func_218657_a("ActiveAfflictions", (INBT)listnbt);
        }
        return to;
    }

    @Override
    public void read(CompoundNBT from) {
        this.statuus.clear();
        if (from.func_150297_b("ActiveAfflictions", 9)) {
            ListNBT listnbt = from.func_150295_c("ActiveAfflictions", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundNBT compoundnbt = listnbt.func_150305_b(i);
                SkillData effectinstance = SkillData.read(compoundnbt);
                if (effectinstance == null) continue;
                this.statuus.put(effectinstance.getSkill(), effectinstance);
            }
        }
    }

    @Override
    public void update() {
        LivingEntity ticker = (LivingEntity)this.dude.get();
        if (ticker == null) {
            return;
        }
        ArrayList<SkillData> active = new ArrayList<SkillData>(this.getActiveMarks().values());
        for (SkillData cd : active) {
            if (!cd.getSkill().markTick(cd.getCaster(ticker.field_70170_p), ticker, cd)) continue;
            this.sync = true;
        }
        if (this.sync && ticker instanceof ServerPlayerEntity) {
            CombatChannel.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)ticker), (Object)new UpdateAfflictionPacket(ticker.func_145782_y(), this.write()));
            this.sync = false;
        }
        if (this.sync && EntityHandler.mustUpdate.containsValue(ticker)) {
            CombatChannel.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> ticker), (Object)new UpdateAfflictionPacket(ticker.func_145782_y(), this.write()));
            this.sync = false;
        }
    }
}

