/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import jackiecrazy.footwork.api.WarAttributes;
import jackiecrazy.footwork.capability.resources.CombatData;
import jackiecrazy.footwork.capability.resources.ICombatCapability;
import jackiecrazy.footwork.config.DisplayConfigUtils;
import jackiecrazy.footwork.utils.GeneralUtils;
import jackiecrazy.footwork.utils.StealthUtils;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.capability.skill.ISkillCapability;
import jackiecrazy.wardance.capability.status.Marks;
import jackiecrazy.wardance.config.ClientConfig;
import jackiecrazy.wardance.config.CombatConfig;
import jackiecrazy.wardance.config.GeneralConfig;
import jackiecrazy.wardance.config.ResourceConfig;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategories;
import jackiecrazy.wardance.skill.SkillData;
import jackiecrazy.wardance.skill.coupdegrace.CoupDeGrace;
import jackiecrazy.wardance.utils.CombatUtils;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.GameSettings;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.settings.AttackIndicatorStatus;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="wardance")
public class RenderEvents {
    static final DecimalFormat formatter = new DecimalFormat("#.#");
    private static final Cache<LivingEntity, Tuple<StealthUtils.Awareness, Double>> cache = CacheBuilder.newBuilder().weakKeys().expireAfterWrite(1L, TimeUnit.SECONDS).build();
    private static final ResourceLocation amo = new ResourceLocation("wardance", "textures/hud/amo.png");
    private static final ResourceLocation darkmega = new ResourceLocation("wardance", "textures/hud/dark.png");
    private static final ResourceLocation raihud = new ResourceLocation("wardance", "textures/hud/thanksrai.png");
    private static final ResourceLocation stealth = new ResourceLocation("wardance", "textures/hud/stealth.png");
    static float currentComboLevel = 0.0f;
    private static float currentMightLevel = 0.0f;
    private static float currentSpiritLevel = 0.0f;
    private static boolean flip = false;

    @SubscribeEvent
    public static void down(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ActiveRenderInfo camera = mc.field_71460_t.func_215316_n();
        MatrixStack poseStack = event.getMatrixStack();
        float partialTicks = event.getPartialTicks();
        Entity cameraEntity = camera.func_216773_g() != null ? camera.func_216773_g() : mc.field_71439_g;
        Vector3d cameraPos = camera.func_216785_c();
        ClippingHelper frustum = new ClippingHelper(poseStack.func_227866_c_().func_227870_a_(), event.getProjectionMatrix());
        frustum.func_228952_a_(cameraPos.func_82615_a(), cameraPos.func_82617_b(), cameraPos.func_82616_c());
        ClientWorld client = mc.field_71441_e;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void displayCoolie(RenderGameOverlayEvent.Post event) {
        int y;
        MainWindow sr = event.getWindow();
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack stack = event.getMatrixStack();
        if (GeneralConfig.dual) {
            GameSettings gamesettings;
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS) && (gamesettings = mc.field_71474_y).func_243230_g() == PointOfView.FIRST_PERSON) {
                int width = sr.func_198107_o();
                int height = sr.func_198087_p();
                ClientPlayerEntity player = mc.field_71439_g;
                if (player == null) {
                    return;
                }
                if ((!gamesettings.field_74330_P || gamesettings.field_74319_N || player.func_175140_cp() || gamesettings.field_178879_v) && mc.field_71474_y.field_186716_M == AttackIndicatorStatus.CROSSHAIR) {
                    GlStateManager.func_227709_e_();
                    float cooldown = CombatUtils.getCooledAttackStrength((LivingEntity)player, Hand.OFF_HAND, 0.0f);
                    boolean hyperspeed = false;
                    if (RenderEvents.getEntityLookedAt((Entity)player, GeneralUtils.getAttributeValueHandSensitive((LivingEntity)player, (Attribute)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Hand)Hand.OFF_HAND)) != null && cooldown >= 1.0f) {
                        hyperspeed = (float)CombatUtils.getCooldownPeriod((LivingEntity)player, Hand.OFF_HAND) > 5.0f;
                        hyperspeed &= RenderEvents.getEntityLookedAt((Entity)player, GeneralUtils.getAttributeValueHandSensitive((LivingEntity)player, (Attribute)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Hand)Hand.OFF_HAND)).func_70089_S();
                    }
                    y = height / 2 - 7 - 7;
                    int x = width / 2 - 8;
                    if (hyperspeed) {
                        mc.field_71456_v.func_238474_b_(stack, x, y, 68, 94, 16, 16);
                    } else if (cooldown < 1.0f) {
                        int k = (int)(cooldown * 17.0f);
                        mc.field_71456_v.func_238474_b_(stack, x, y, 36, 94, 16, 4);
                        mc.field_71456_v.func_238474_b_(stack, x, y, 52, 94, k, 4);
                    }
                }
            }
            if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR) && mc.func_175606_aa() instanceof PlayerEntity) {
                float strength;
                GlStateManager.func_227673_b_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                PlayerEntity p = (PlayerEntity)mc.func_175606_aa();
                ItemStack itemstack = p.func_184592_cb();
                HandSide oppositeHand = p.func_184591_cq().func_188468_a();
                int halfOfScreen = sr.func_198107_o() / 2;
                GlStateManager.func_227623_K_();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderHelper.func_227780_a_();
                if (mc.field_71474_y.field_186716_M == AttackIndicatorStatus.HOTBAR && (strength = CombatUtils.getCooledAttackStrength((LivingEntity)p, Hand.OFF_HAND, 0.0f)) < 1.0f) {
                    int y2 = sr.func_198087_p() - 20;
                    int x = halfOfScreen + 91 + 6;
                    if (oppositeHand == HandSide.LEFT) {
                        x = halfOfScreen - 91 - 22;
                    }
                    mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                    int modStrength = (int)(strength * 19.0f);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    mc.field_71456_v.func_238474_b_(stack, x + 18, y2, 0, 94, 18, 18);
                    mc.field_71456_v.func_238474_b_(stack, x + 18, y2 + 18 - modStrength, 18, 112 - modStrength, 18, modStrength);
                }
                RenderHelper.func_74518_a();
                RenderSystem.disableBlend();
            }
        }
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.ALL) && mc.func_175606_aa() instanceof PlayerEntity) {
            Entity look;
            ClientPlayerEntity player = mc.field_71439_g;
            ICombatCapability cap = CombatData.getCap((LivingEntity)player);
            int width = sr.func_198107_o();
            int height = sr.func_198087_p();
            mc.func_110434_K().func_110577_a(raihud);
            currentSpiritLevel = RenderEvents.updateValue(currentSpiritLevel, cap.getSpirit());
            currentMightLevel = RenderEvents.updateValue(currentMightLevel, cap.getMight());
            float f = currentComboLevel = cap.getRank() > currentComboLevel ? RenderEvents.updateValue(currentComboLevel, cap.getRank()) : cap.getRank();
            if (cap.isCombatMode()) {
                stack.func_227860_a_();
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                Pair<Integer, Integer> pair = RenderEvents.translateCoords(ClientConfig.CONFIG.might, width, height);
                int x = Math.max((Integer)pair.getFirst() - 16, 0);
                y = Math.min((Integer)pair.getSecond() - 16, height - 32);
                int fillHeight = (int)(Math.min(1.0f, currentMightLevel / cap.getMaxMight()) * 32.0f);
                if (ClientConfig.CONFIG.might.enabled) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    stack.func_227860_a_();
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y, 0, 64, 32, 32);
                    stack.func_227865_b_();
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y + 32 - fillHeight, 0, 96 - fillHeight, 32, fillHeight);
                    stack.func_227865_b_();
                    fillHeight += Math.min(fillHeight, 3);
                    fillHeight = Math.min(fillHeight, 32);
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y, 32, 64, 32, 32);
                    stack.func_227865_b_();
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y + 32 - fillHeight, 64, 96 - fillHeight, 32, fillHeight);
                    stack.func_227865_b_();
                    stack.func_227865_b_();
                }
                pair = RenderEvents.translateCoords(ClientConfig.CONFIG.spirit, width, height);
                x = MathHelper.func_76125_a((int)((Integer)pair.getFirst() - 16), (int)0, (int)(width - 32));
                y = MathHelper.func_76125_a((int)((Integer)pair.getSecond() - 16), (int)0, (int)(height - 32));
                fillHeight = (int)(Math.min(1.0f, currentSpiritLevel / cap.getMaxSpirit()) * 32.0f);
                String display = formatter.format(currentSpiritLevel) + "/" + formatter.format(cap.getMaxSpirit());
                stack.func_227860_a_();
                if (ClientConfig.CONFIG.spirit.enabled) {
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y, 0, 96, 32, 32);
                    stack.func_227865_b_();
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y + 32 - fillHeight, 0, 128 - fillHeight, 32, fillHeight);
                    stack.func_227865_b_();
                    fillHeight += Math.min(fillHeight, 3);
                    fillHeight = Math.min(fillHeight, 32);
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y + 1, 32, 96, 32, 32);
                    stack.func_227865_b_();
                    stack.func_227860_a_();
                    mc.field_71456_v.func_238474_b_(stack, x, y + 33 - fillHeight, 64, 128 - fillHeight, 32, fillHeight);
                    stack.func_227865_b_();
                }
                if (ClientConfig.CONFIG.spiritNumber.enabled) {
                    pair = RenderEvents.translateCoords(ClientConfig.CONFIG.spiritNumber, width, height);
                    mc.field_71466_p.func_238405_a_(event.getMatrixStack(), display, (float)((Integer)pair.getFirst()).intValue() - (float)mc.field_71466_p.func_78256_a(display) / 2.0f, (float)((Integer)pair.getSecond() - 2), ClientConfig.spiritColor);
                }
                if (ClientConfig.CONFIG.mightNumber.enabled) {
                    pair = RenderEvents.translateCoords(ClientConfig.CONFIG.mightNumber, width, height);
                    display = formatter.format(currentMightLevel) + "/" + formatter.format(cap.getMaxMight());
                    mc.field_71466_p.func_238405_a_(event.getMatrixStack(), display, (float)((Integer)pair.getFirst()).intValue() - (float)mc.field_71466_p.func_78256_a(display) / 2.0f, (float)((Integer)pair.getSecond() - 2), ClientConfig.mightColor);
                }
                stack.func_227865_b_();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                stack.func_227865_b_();
                RenderSystem.enableBlend();
                stack.func_227860_a_();
                if (ClientConfig.CONFIG.combo.enabled) {
                    mc.func_110434_K().func_110577_a(raihud);
                    int combowidth = 32;
                    float workingCombo = currentComboLevel;
                    int comboU = (int)MathHelper.func_151237_a((double)Math.floor(workingCombo), (double)0.0, (double)4.0) * 32;
                    int divisor = 1;
                    if (workingCombo >= 4.0f) {
                        divisor = 2;
                    }
                    if (workingCombo >= 6.0f) {
                        combowidth = 33;
                        comboU = 159;
                        divisor = 3;
                    }
                    if (workingCombo >= 9.0f) {
                        combowidth = 64;
                        comboU = 192;
                        fillHeight = (int)((workingCombo - 9.0f) * 32.0f);
                    } else {
                        fillHeight = divisor > 1 ? (int)((workingCombo - (float)(divisor * 2)) / (float)divisor * 32.0f) : (int)(((double)workingCombo - Math.floor(workingCombo)) * 32.0);
                    }
                    pair = RenderEvents.translateCoords(ClientConfig.CONFIG.combo, width, height);
                    x = MathHelper.func_76125_a((int)((Integer)pair.getFirst() - combowidth / 2), (int)0, (int)(width - combowidth));
                    y = MathHelper.func_76125_a((int)((Integer)pair.getSecond() - 23), (int)0, (int)(height - 46));
                    mc.field_71456_v.func_238474_b_(stack, x, y, comboU, 0, combowidth, 32);
                    mc.field_71456_v.func_238474_b_(stack, x, y + 33 - fillHeight, comboU, 65 - fillHeight, combowidth, fillHeight - 2);
                }
                stack.func_227865_b_();
                RenderSystem.disableBlend();
            }
            mc.func_110434_K().func_110577_a(amo);
            if (cap.isCombatMode() || cap.getPosture() < cap.getMaxPosture() || cap.getStaggerTime() > 0 || (double)cap.getShatterCooldown() < Math.floor(GeneralUtils.getAttributeValueSafe((LivingEntity)player, (Attribute)((Attribute)WarAttributes.SHATTER.get()))) || cap.getBarrier() < cap.getMaxBarrier()) {
                RenderEvents.drawPostureBarAt(true, stack, (LivingEntity)player, width, height);
            }
            if ((look = RenderEvents.getEntityLookedAt((Entity)player, 32.0)) instanceof LivingEntity) {
                LivingEntity looked;
                block35: {
                    looked = (LivingEntity)look;
                    ArrayList<SkillData> afflict = new ArrayList<SkillData>();
                    ISkillCapability skill = CasterData.getCap((LivingEntity)player);
                    if (ClientConfig.CONFIG.enemyAfflict.enabled) {
                        CoupDeGrace cdg;
                        Skill variant = skill.getEquippedVariation(SkillCategories.coup_de_grace);
                        if (look != player && variant instanceof CoupDeGrace && skill.isSkillUsable(variant) && (cdg = (CoupDeGrace)variant).willKillOnCast((LivingEntity)player, looked)) {
                            afflict.add(new SkillData(cdg, 0.0f, 0.0f));
                        }
                        afflict.addAll(Marks.getCap(looked).getActiveMarks().values().stream().filter(a -> a.getSkill().showsMark((SkillData)a, looked)).collect(Collectors.toList()));
                        Pair<Integer, Integer> pair = RenderEvents.translateCoords(ClientConfig.CONFIG.enemyAfflict, width, height);
                        for (int index = 0; index < afflict.size(); ++index) {
                            SkillData s = (SkillData)afflict.get(index);
                            mc.func_110434_K().func_110577_a(s.getSkill().icon());
                            Color c = s.getSkill().getColor();
                            RenderSystem.color4f((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)1.0f);
                            AbstractGui.func_238463_a_((MatrixStack)stack, (int)((Integer)pair.getFirst() - (afflict.size() - 1 - index) * 16 + (afflict.size() - 1) * 8 - 8), (int)((Integer)pair.getSecond()), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                            if (s.getMaxDuration() == 0.0f) continue;
                            String display = formatter.format(s.getDuration());
                            mc.field_71466_p.func_238405_a_(event.getMatrixStack(), display, (float)((Integer)pair.getFirst() - (afflict.size() - 1 - index) * 16 + (afflict.size() - 1) * 8 - 8), (float)((Integer)pair.getSecond() - 2), 0);
                        }
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (ClientConfig.CONFIG.stealth.enabled && cap.isCombatMode()) {
                        Pair<Integer, Integer> pair = RenderEvents.translateCoords(ClientConfig.CONFIG.stealth, width, height);
                        Tuple<StealthUtils.Awareness, Double> info = RenderEvents.stealthInfo(looked);
                        double dist = (Double)info.func_76340_b();
                        int shift = 0;
                        switch ((StealthUtils.Awareness)info.func_76341_a()) {
                            case ALERT: {
                                break block35;
                            }
                            case DISTRACTED: {
                                shift = 1;
                                break;
                            }
                            case UNAWARE: {
                                if (Minecraft.func_71410_x().field_71439_g == null) break;
                                shift = looked.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) < dist * dist ? 2 : 3;
                            }
                        }
                        if ((Double)info.func_76340_b() < 0.0) {
                            shift = 0;
                        }
                        mc.func_110434_K().func_110577_a(stealth);
                        AbstractGui.func_238463_a_((MatrixStack)stack, (int)((Integer)pair.getFirst() - 16), (int)((Integer)pair.getSecond() - 8), (float)0.0f, (float)(shift * 16), (int)32, (int)16, (int)64, (int)64);
                    }
                }
                if (ClientConfig.CONFIG.enemyPosture.enabled && (cap.isCombatMode() || CombatData.getCap((LivingEntity)((LivingEntity)look)).getPosture() < CombatData.getCap((LivingEntity)((LivingEntity)look)).getMaxPosture() || CombatData.getCap((LivingEntity)((LivingEntity)look)).getStaggerTime() > 0 || (double)cap.getShatterCooldown() < GeneralUtils.getAttributeValueSafe((LivingEntity)player, (Attribute)((Attribute)WarAttributes.SHATTER.get())) || cap.getBarrier() < cap.getMaxBarrier())) {
                    RenderEvents.drawPostureBarAt(false, stack, looked, width, height);
                }
            }
        }
    }

    private static void drawPostureBarAt(boolean you, MatrixStack ms, LivingEntity elb, int width, int height) {
        ClientConfig.BarType b = ClientConfig.CONFIG.enemyPosture.bar;
        if (you) {
            b = ClientConfig.CONFIG.playerPosture.bar;
        }
        switch (b) {
            case AMO: {
                RenderEvents.drawAmoPostureBarAt(you, ms, elb, width, height);
                break;
            }
            case DARKMEGA: {
                RenderEvents.drawDarkPostureBarAt(you, ms, elb, width, height);
                break;
            }
            case CLASSIC: {
                RenderEvents.drawOldPostureBarAt(you, ms, elb, width, height);
            }
        }
    }

    private static void drawOldPostureBarAt(boolean you, MatrixStack ms, LivingEntity elb, int width, int height) {
        Pair<Integer, Integer> pair = you ? RenderEvents.translateCoords(ClientConfig.CONFIG.playerPosture, width, height) : RenderEvents.translateCoords(ClientConfig.CONFIG.enemyPosture, width, height);
        int atX = (Integer)pair.getFirst();
        int atY = (Integer)pair.getSecond();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(amo);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        ICombatCapability itsc = CombatData.getCap((LivingEntity)elb);
        mc.func_213239_aq().func_76320_a("postureBar");
        float cap = itsc.getMaxPosture();
        int barWidth = 182;
        int left = atX - barWidth / 2;
        float posture = itsc.getPosture();
        float trueMaxPosture = Float.isFinite(itsc.getTrueMaxPosture()) ? itsc.getTrueMaxPosture() : 1.0f;
        float posPerc = posture / Math.max(0.1f, trueMaxPosture);
        posPerc = Float.isFinite(posPerc) ? posPerc : 0.0f;
        posPerc = MathHelper.func_76131_a((float)posPerc, (float)0.0f, (float)1.0f);
        double shatter = MathHelper.func_76131_a((float)(itsc.getBarrier() / itsc.getMaxBarrier()), (float)0.0f, (float)1.0f);
        if (cap > 0.0f) {
            if (shatter <= 0.0) {
                shatter = (double)(ResourceConfig.shatterCooldown + itsc.getShatterCooldown()) / (double)ResourceConfig.shatterCooldown;
                RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
            }
            int filled = (int)(shatter * (double)(barWidth + 2));
            mc.field_71456_v.func_238474_b_(ms, left - 1, atY - 1, 0, 74, filled, 7);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71456_v.func_238474_b_(ms, left, atY, 0, 64, barWidth, 5);
            filled = (int)(posPerc * (float)barWidth);
            RenderSystem.color3f((float)(1.0f - posPerc), (float)posPerc, (float)0.11764706f);
            mc.field_71456_v.func_238474_b_(ms, left, atY, 0, 69, filled, 5);
            float fatigue = itsc.getMaxPosture() / trueMaxPosture;
            fatigue = Float.isFinite(fatigue) ? fatigue : 0.0f;
            filled = (int)(fatigue * (float)barWidth);
            RenderSystem.color3f((float)1.0f, (float)0.1f, (float)0.1f);
            mc.field_71456_v.func_238474_b_(ms, left + filled, atY, filled, 69, barWidth - filled, 5);
            if (itsc.getStaggerTime() > 0) {
                int invulTime = (int)(MathHelper.func_76131_a((float)((float)itsc.getStaggerTime() / (float)CombatConfig.staggerDuration), (float)0.0f, (float)1.0f) * (float)barWidth);
                RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
                mc.field_71456_v.func_238474_b_(ms, left, atY, 0, 69, invulTime, 5);
            }
        }
        mc.func_213239_aq().func_76319_b();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        RenderSystem.disableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawAmoPostureBarAt(boolean you, MatrixStack ms, LivingEntity elb, int width, int height) {
        int halfBarWidth;
        Pair<Integer, Integer> pair = you ? RenderEvents.translateCoords(ClientConfig.CONFIG.playerPosture, width, height) : RenderEvents.translateCoords(ClientConfig.CONFIG.enemyPosture, width, height);
        int atX = (Integer)pair.getFirst();
        int atY = (Integer)pair.getSecond();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(amo);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        ICombatCapability itsc = CombatData.getCap((LivingEntity)elb);
        mc.func_213239_aq().func_76320_a("postureBar");
        float cap = itsc.getMaxPosture();
        int flexBarWidth = halfBarWidth = Math.min(240, (int)(Math.sqrt(itsc.getTrueMaxPosture()) * 25.0)) / 2;
        int barHeight = 7;
        if (cap > 0.0f) {
            int shatter = itsc.getShatterCooldown();
            int mshatter = (int)GeneralUtils.getAttributeValueSafe((LivingEntity)elb, (Attribute)((Attribute)WarAttributes.SHATTER.get()));
            mc.field_71456_v.func_238474_b_(ms, atX + flexBarWidth, atY - 1, 235, 0, 5, 7);
            mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth - 5, atY - 1, 0, 0, 5, 7);
            flexBarWidth = (int)((float)flexBarWidth - itsc.getFatigue() * (float)halfBarWidth / itsc.getTrueMaxPosture());
            mc.field_71456_v.func_238474_b_(ms, atX + flexBarWidth, atY - 1, 235, 40, 5, 7);
            mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth - 5, atY - 1, 0, 40, 5, 7);
            if (itsc.getStaggerTime() > 0) {
                int count = (int)((float)((itsc.getMaxStaggerCount() - itsc.getStaggerCount()) * flexBarWidth) / (float)itsc.getMaxStaggerCount()) + 3;
                int time = (int)((float)((itsc.getMaxStaggerTime() - itsc.getStaggerTime()) * flexBarWidth) / (float)itsc.getMaxStaggerTime()) + 3;
                flexBarWidth = Math.max(count, time);
                mc.field_71456_v.func_238474_b_(ms, atX, atY, 238 - flexBarWidth, 13, flexBarWidth, 6);
                mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth, atY, 0, 13, flexBarWidth, 6);
            } else {
                flexBarWidth = (int)(itsc.getPosture() * (float)halfBarWidth / itsc.getTrueMaxPosture()) + 4;
                mc.field_71456_v.func_238474_b_(ms, atX, atY, 238 - flexBarWidth, 7, flexBarWidth, 6);
                mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth - 1, atY, 0, 7, flexBarWidth + 1, 6);
                if (shatter > 0 && shatter != mshatter) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)shatter / (float)mshatter));
                    mc.field_71456_v.func_238474_b_(ms, atX, atY, 238 - flexBarWidth, 54, flexBarWidth, 6);
                    mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth - 1, atY, 0, 54, flexBarWidth + 1, 6);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                float barrier = itsc.getBarrier();
                flexBarWidth = (int)(barrier * (float)halfBarWidth / itsc.getTrueMaxPosture()) + 5;
                int vOff = itsc.consumeBarrier(flip ? -1.0E-4f : 1.0E-4f) == 0.0f ? 26 : 19;
                mc.field_71456_v.func_238474_b_(ms, atX, atY - 1, 239 - flexBarWidth, vOff, flexBarWidth + 1, 7);
                mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth, atY - 1, 0, vOff, flexBarWidth + 1, 7);
            }
        }
        mc.func_213239_aq().func_76319_b();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        RenderSystem.disableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawDarkPostureBarAt(boolean you, MatrixStack ms, LivingEntity elb, int width, int height) {
        int halfBarWidth;
        Pair<Integer, Integer> pair = you ? RenderEvents.translateCoords(ClientConfig.CONFIG.playerPosture, width, height) : RenderEvents.translateCoords(ClientConfig.CONFIG.enemyPosture, width, height);
        int atX = (Integer)pair.getFirst();
        int atY = (Integer)pair.getSecond();
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(darkmega);
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        ICombatCapability itsc = CombatData.getCap((LivingEntity)elb);
        mc.func_213239_aq().func_76320_a("postureBar");
        float cap = itsc.getMaxPosture();
        int flexBarWidth = halfBarWidth = Math.min(240, (int)(Math.sqrt(itsc.getTrueMaxPosture()) * 25.0)) / 2;
        int barHeight = 10;
        if (cap > 0.0f) {
            int shatter = itsc.getShatterCooldown();
            int mshatter = (int)GeneralUtils.getAttributeValueSafe((LivingEntity)elb, (Attribute)((Attribute)WarAttributes.SHATTER.get()));
            mc.field_71456_v.func_238474_b_(ms, atX, atY - 2, 240 - flexBarWidth - 10, 0, flexBarWidth + 10, 10);
            mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth - 10, atY - 2, 0, 0, flexBarWidth + 10, 10);
            int temp = flexBarWidth = (int)((float)flexBarWidth - itsc.getFatigue() * (float)halfBarWidth / itsc.getTrueMaxPosture());
            mc.field_71456_v.func_238474_b_(ms, atX + flexBarWidth, atY - 2, 232, 50, 10, 10);
            mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth - 9, atY - 2, 0, 50, 12, 10);
            if (itsc.getStaggerTime() > 0) {
                int count = (int)((float)((itsc.getMaxStaggerCount() - itsc.getStaggerCount()) * flexBarWidth) / (float)itsc.getMaxStaggerCount()) + 3;
                int time = (int)((float)((itsc.getMaxStaggerTime() - itsc.getStaggerTime()) * flexBarWidth) / (float)itsc.getMaxStaggerTime()) + 3;
                flexBarWidth = Math.max(count, time);
                mc.field_71456_v.func_238474_b_(ms, atX, atY - 2, 238 - flexBarWidth, 20, flexBarWidth, 10);
                mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth, atY - 2, 0, 20, flexBarWidth, 10);
            } else {
                flexBarWidth = (int)(itsc.getPosture() * (float)halfBarWidth / itsc.getTrueMaxPosture()) + 4;
                mc.field_71456_v.func_238474_b_(ms, atX, atY - 2, 238 - flexBarWidth, 10, flexBarWidth, 10);
                mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth, atY - 2, 2, 10, flexBarWidth, 10);
                flexBarWidth = (int)(itsc.getBarrier() * (float)halfBarWidth / itsc.getTrueMaxPosture()) + 5;
                flip = !flip;
                int vOffset = itsc.consumeBarrier(flip ? -0.001f : 0.001f) == 0.0f ? 40 : 30;
                mc.field_71456_v.func_238474_b_(ms, atX - flexBarWidth, atY - 2, 0, vOffset, flexBarWidth + 1, 10);
                mc.field_71456_v.func_238474_b_(ms, atX, atY - 2, 239 - flexBarWidth, vOffset, flexBarWidth + 1, 10);
                if (shatter > 0) {
                    int insigniaU = 115;
                    int insigniaV = 80;
                    int insigniaW = 11;
                    if (shatter != mshatter) {
                        float otemp = 1.0f - (float)shatter / (float)mshatter;
                        if ((otemp *= 2.0f) > 1.0f) {
                            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(-(otemp - 2.0f)));
                            otemp = 1.0f;
                        }
                        int fini = (int)(otemp * (float)temp);
                        mc.field_71456_v.func_238474_b_(ms, atX, atY - 2, 240 - fini - 10, 70, fini + 10, 10);
                        mc.field_71456_v.func_238474_b_(ms, atX - fini - 9, atY - 2, 0, 70, fini + 10, 10);
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(-(otemp - 2.0f)));
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        insigniaV = 90;
                    }
                    mc.field_71456_v.func_238474_b_(ms, atX - insigniaW / 2, atY - 2, insigniaU, insigniaV, insigniaW, 9);
                    mc.field_71456_v.func_238474_b_(ms, atX - temp - 8, atY - 2, 0, 80, 10, 10);
                    mc.field_71456_v.func_238474_b_(ms, atX + temp, atY - 2, 232, 80, 10, 10);
                }
            }
        }
        mc.func_213239_aq().func_76319_b();
        mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
        RenderSystem.disableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static Entity getEntityLookedAt(Entity e, double finalDistance) {
        Entity foundEntity = null;
        double distance = finalDistance;
        RayTraceResult pos = RenderEvents.raycast(e, finalDistance);
        Vector3d positionVector = e.func_213303_ch();
        if (e instanceof PlayerEntity) {
            positionVector = positionVector.func_72441_c(0.0, (double)e.func_213307_e(e.func_213283_Z()), 0.0);
        }
        if (pos != null) {
            distance = pos.func_216347_e().func_72438_d(positionVector);
        }
        Vector3d lookVector = e.func_70040_Z();
        Vector3d reachVector = positionVector.func_72441_c(lookVector.field_72450_a * finalDistance, lookVector.field_72448_b * finalDistance, lookVector.field_72449_c * finalDistance);
        Entity lookedEntity = null;
        List entitiesInBoundingBox = e.func_130014_f_().func_72839_b(e, e.func_174813_aQ().func_72314_b(lookVector.field_72450_a * finalDistance, lookVector.field_72448_b * finalDistance, lookVector.field_72449_c * finalDistance).func_72321_a(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            if (entity.func_70067_L()) {
                double distanceToEntity;
                AxisAlignedBB collisionBox = entity.func_184177_bl();
                Optional interceptPosition = collisionBox.func_216365_b(positionVector, reachVector);
                if (collisionBox.func_72318_a(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.func_72438_d((Vector3d)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    public static RayTraceResult raycast(Entity e, double len) {
        Vector3d look;
        Vector3d vec = new Vector3d(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
        if (e instanceof PlayerEntity) {
            vec = vec.func_178787_e(new Vector3d(0.0, (double)e.func_213307_e(e.func_213283_Z()), 0.0));
        }
        if ((look = e.func_70040_Z()) == null) {
            return null;
        }
        return RenderEvents.raycast(vec, look, e, len);
    }

    public static RayTraceResult raycast(Vector3d origin, Vector3d ray, Entity e, double len) {
        Vector3d next = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        return e.field_70170_p.func_217299_a(new RayTraceContext(origin, next, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, e));
    }

    private static float updateValue(float f, float to) {
        if (f == -1.0f) {
            return to;
        }
        boolean close = true;
        float temp = f;
        if (to > f) {
            f = (float)((double)f + MathHelper.func_151237_a((double)((to - temp) / 20.0f), (double)0.01, (double)0.1));
            close = false;
        }
        if (to < f) {
            f = (float)((double)f + MathHelper.func_151237_a((double)((to - temp) / 20.0f), (double)-0.1, (double)-0.01));
            boolean bl = close = !close;
        }
        if (close) {
            f = to;
        }
        return f;
    }

    private static Tuple<StealthUtils.Awareness, Double> stealthInfo(LivingEntity at) {
        try {
            return (Tuple)cache.get((Object)at, () -> {
                StealthUtils.Awareness a = StealthUtils.INSTANCE.getAwareness((LivingEntity)Minecraft.func_71410_x().field_71439_g, at);
                double mult = Minecraft.func_71410_x().field_71439_g.func_213340_A((Entity)at);
                return new Tuple((Object)a, (Object)(mult * (double)CombatData.getCap((LivingEntity)at).visionRange()));
            });
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return new Tuple((Object)StealthUtils.Awareness.ALERT, (Object)1.0);
        }
    }

    private static Pair<Integer, Integer> translateCoords(DisplayConfigUtils.DisplayData dd, int width, int height) {
        return RenderEvents.translateCoords(dd.anchorPoint, dd.numberX, dd.numberY, width, height);
    }

    private static void renderEye(LivingEntity passedEntity, float partialTicks, MatrixStack poseStack) {
        Tuple<StealthUtils.Awareness, Double> info = RenderEvents.stealthInfo(passedEntity);
        double dist = (Double)info.func_76340_b();
        int shift = 0;
        switch ((StealthUtils.Awareness)info.func_76341_a()) {
            case ALERT: {
                return;
            }
            case DISTRACTED: {
                shift = 1;
                break;
            }
            case UNAWARE: {
                if (Minecraft.func_71410_x().field_71439_g == null) break;
                int n = shift = passedEntity.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) < dist * dist ? 2 : 3;
            }
        }
        if ((Double)info.func_76340_b() < 0.0) {
            shift = 0;
        }
        double x = passedEntity.field_70169_q + (passedEntity.func_226277_ct_() - passedEntity.field_70169_q) * (double)partialTicks;
        double y = passedEntity.field_70167_r + (passedEntity.func_226278_cu_() - passedEntity.field_70167_r) * (double)partialTicks;
        double z = passedEntity.field_70166_s + (passedEntity.func_226281_cx_() - passedEntity.field_70166_s) * (double)partialTicks;
        EntityRendererManager renderDispatcher = Minecraft.func_71410_x().func_175598_ae();
        Vector3d renderPos = renderDispatcher.field_217783_c.func_216785_c();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_((double)((float)(x - renderPos.func_82615_a())), (double)((float)(y - renderPos.func_82617_b() + (double)passedEntity.func_213302_cg())), (double)((float)(z - renderPos.func_82616_c())));
        Minecraft.func_71410_x().func_110434_K().func_110577_a(stealth);
        poseStack.func_227861_a_(0.0, 0.5, 0.0);
        poseStack.func_227863_a_(Minecraft.func_71410_x().func_175598_ae().func_229098_b_());
        float size = MathHelper.func_76131_a((float)(0.002f * CombatData.getCap((LivingEntity)passedEntity).getTrueMaxPosture()), (float)0.015f, (float)0.1f);
        poseStack.func_227862_a_(-size, -size, size);
        AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)-16, (int)-8, (float)0.0f, (float)(shift * 16), (int)32, (int)16, (int)64, (int)64);
        poseStack.func_227865_b_();
    }

    private static Pair<Integer, Integer> translateCoords(DisplayConfigUtils.AnchorPoint ap, int x, int y, int width, int height) {
        int rety;
        int retx;
        switch (ap) {
            case TOPLEFT: {
                retx = 0;
                rety = 0;
                break;
            }
            case TOPRIGHT: {
                retx = 0;
                rety = width;
                break;
            }
            case CROSSHAIR: {
                retx = width / 2;
                rety = height / 2;
                break;
            }
            case TOPCENTER: {
                retx = width / 2;
                rety = 0;
                break;
            }
            case BOTTOMLEFT: {
                retx = 0;
                rety = height;
                break;
            }
            case MIDDLELEFT: {
                retx = 0;
                rety = height / 2;
                break;
            }
            case BOTTOMRIGHT: {
                retx = width;
                rety = height;
                break;
            }
            case MIDDLERIGHT: {
                retx = width;
                rety = height / 2;
                break;
            }
            case BOTTOMCENTER: {
                retx = width / 2;
                rety = height;
                break;
            }
            default: {
                rety = 0;
                retx = 0;
            }
        }
        retx = MathHelper.func_76125_a((int)(retx + x), (int)0, (int)width);
        rety = MathHelper.func_76125_a((int)(rety + y), (int)0, (int)height);
        return Pair.of((Object)retx, (Object)rety);
    }
}

