/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import jackiecrazy.wardance.capability.skill.CasterData;
import jackiecrazy.wardance.client.screen.PassiveButton;
import jackiecrazy.wardance.client.screen.SkillListWidget;
import jackiecrazy.wardance.client.screen.SkillSelectionButton;
import jackiecrazy.wardance.client.screen.SkillSliceButton;
import jackiecrazy.wardance.client.screen.VariationListWidget;
import jackiecrazy.wardance.networking.CombatChannel;
import jackiecrazy.wardance.networking.UpdateSkillSelectionPacket;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.SkillCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class SkillSelectionScreen
extends Screen {
    private static final ResourceLocation radial = new ResourceLocation("wardance", "textures/skill/radialhud.png");
    private static final int[] fixedU = new int[]{150, 0, 150, 300, 300};
    private static final int[] fixedV = new int[]{0, 150, 150, 150, 0};
    private static final int PADDING = 6;
    private final List<SkillCategory> unsortedBases;
    private final SkillSliceButton[] skillPie = new SkillSliceButton[5];
    private final PassiveButton[] passives = new PassiveButton[5];
    private final int numButtons = 2;
    public SkillListWidget.CategoryEntry selectedSkill = null;
    public VariationListWidget.VariationEntry selectedVariation = null;
    private SkillListWidget skillList;
    private VariationListWidget variationList;
    private InfoPanel skillInfo;
    private int listWidth;
    private List<SkillCategory> bases;
    private int buttonMargin = 1;
    private String lastFilterText = "";
    private TextFieldWidget search;
    private boolean sorted = false;
    private AdvancedData advancedData = AdvancedData.NORMAL;

    public SkillSelectionScreen() {
        super((ITextComponent)new TranslationTextComponent("wardance.skillselection.title"));
        this.bases = Skill.variationMap.keySet().stream().filter(this::selectable).collect(Collectors.toList());
        this.unsortedBases = Collections.unmodifiableList(this.bases);
    }

    private static String stripControlCodes(String value) {
        return StringUtils.func_76338_a((String)value);
    }

    private boolean selectable(SkillCategory s) {
        for (Skill sub : Skill.variationMap.get(s)) {
            if (!CasterData.getCap((LivingEntity)Minecraft.func_71410_x().field_71439_g).isSkillSelectable(sub)) continue;
            return true;
        }
        return false;
    }

    public void func_231160_c_() {
        int d;
        for (SkillCategory mod : this.bases) {
            this.listWidth = Math.max(this.listWidth, this.getFontRenderer().func_78256_a(mod.name().getString()) + 20);
        }
        this.listWidth = Math.max(Math.min(this.listWidth, this.field_230708_k_ / 5), 100);
        this.listWidth += this.listWidth % 2 != 0 ? 2 - this.listWidth % 2 : 0;
        int skillCircleWidth = 150;
        int infoWidth = this.field_230708_k_ - this.listWidth - skillCircleWidth - 24;
        int doneButtonWidth = Math.min(infoWidth, 200);
        int y = this.field_230709_l_ - 20 - 6;
        this.func_230480_a_((Widget)new Button((this.listWidth + 6 + this.field_230708_k_ - doneButtonWidth) / 2, y, doneButtonWidth, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> this.func_231175_as__()));
        this.search = new TextFieldWidget(this.getFontRenderer(), 7, y, this.listWidth - 2, 14, (ITextComponent)new TranslationTextComponent("fml.menu.mods.search"));
        int fullButtonHeight = 32;
        int n = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        this.skillList = new SkillListWidget(this, this.listWidth, 6, n - 9 - 6);
        this.skillList.func_230959_g_(6);
        int split = (this.field_230709_l_ - 12 - fullButtonHeight) * 2 / 3;
        this.skillInfo = new InfoPanel(this.field_230706_i_, infoWidth, split, 6);
        int n2 = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        this.variationList = new VariationListWidget(this, infoWidth - 9, split + 12, n2 - 9 - 6);
        this.variationList.func_230959_g_(12 + this.listWidth);
        List<Skill> oldList = CasterData.getCap((LivingEntity)Minecraft.func_71410_x().field_71439_g).getEquippedSkills();
        for (d = 0; d < this.skillPie.length; ++d) {
            this.skillPie[d] = new SkillSliceButton(this, this.field_230708_k_ - skillCircleWidth, 3, skillCircleWidth, fixedU[d], fixedV[d], radial, d);
            this.skillPie[d].setSkill(oldList.get(d));
            this.field_230705_e_.add(this.skillPie[d]);
        }
        for (d = 0; d < this.passives.length; ++d) {
            this.passives[d] = new PassiveButton(this, this.field_230708_k_ - skillCircleWidth + d * 31, 6 + skillCircleWidth, 23, d);
            this.passives[d].setSkill(oldList.get(d + this.skillPie.length));
            this.field_230705_e_.add(this.passives[d]);
        }
        this.field_230705_e_.add(this.search);
        this.field_230705_e_.add(this.skillList);
        this.field_230705_e_.add(this.variationList);
        this.field_230705_e_.add(this.skillInfo);
        this.search.func_146195_b(false);
        this.search.func_146205_d(true);
        this.resortMods(AdvancedData.NORMAL);
        this.updateCache();
        this.func_212928_a((IGuiEventListener)this.skillList);
    }

    public void func_231023_e_() {
        this.search.func_146178_a();
        this.skillList.func_241215_a_((AbstractList.AbstractListEntry)this.selectedSkill);
        this.variationList.func_241215_a_((AbstractList.AbstractListEntry)this.selectedVariation);
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            this.bases.sort(this.advancedData);
            this.skillList.refreshList();
            this.variationList.refreshList();
            if (this.selectedSkill != null) {
                this.selectedSkill = this.skillList.func_231039_at__().stream().filter(e -> e.getCategory() == this.selectedSkill.getCategory()).findFirst().orElse(null);
                this.updateCache();
            }
            this.sorted = true;
        }
    }

    public <T extends ExtendedList.AbstractListEntry<T>> void buildSkillList(Consumer<T> modListViewConsumer, Function<SkillCategory, T> newEntry) {
        this.bases.forEach(mod -> modListViewConsumer.accept(newEntry.apply((SkillCategory)mod)));
    }

    public <T extends ExtendedList.AbstractListEntry<T>> void buildVariationList(SkillCategory s, Consumer<T> modListViewConsumer, Function<Skill, T> newEntry) {
        Skill.variationMap.get(s).forEach(mod -> {
            if (CasterData.getCap((LivingEntity)Minecraft.func_71410_x().field_71439_g).isSkillSelectable((Skill)((Object)mod))) {
                modListViewConsumer.accept(newEntry.apply((Skill)((Object)mod)));
            }
        });
    }

    private void reloadMods() {
        this.bases = this.unsortedBases.stream().filter(mi -> net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)SkillSelectionScreen.stripControlCodes(mi.name().getString())).contains(net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.search.func_146179_b()))).collect(Collectors.toList());
        this.lastFilterText = this.search.func_146179_b();
    }

    boolean isValidInsertion(Skill insert) {
        for (SkillSliceButton skillSliceButton : this.skillPie) {
            if (skillSliceButton.getSkill() == null || !skillSliceButton.getSkill().isFamily(insert)) continue;
            return false;
        }
        for (SkillSelectionButton skillSelectionButton : this.passives) {
            if (skillSelectionButton.getSkill() == null || !skillSelectionButton.getSkill().isFamily(insert)) continue;
            return false;
        }
        return CasterData.getCap((LivingEntity)Minecraft.func_71410_x().field_71439_g).isSkillSelectable(insert);
    }

    private void resortMods(AdvancedData newSort) {
        this.advancedData = newSort;
        for (AdvancedData sort : AdvancedData.values()) {
            if (sort.button == null) continue;
            sort.button.field_230693_o_ = this.advancedData != sort;
        }
        this.sorted = false;
    }

    public void func_230430_a_(MatrixStack mStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(mStack);
        this.skillList.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        this.variationList.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        if (this.skillInfo != null) {
            this.skillInfo.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
            RenderSystem.disableScissor();
        }
        for (SkillSliceButton skillSliceButton : this.skillPie) {
            skillSliceButton.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
        for (SkillSelectionButton skillSelectionButton : this.passives) {
            skillSelectionButton.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        }
        TranslationTextComponent text = new TranslationTextComponent("fml.menu.mods.search");
        int x = this.skillList.getLeft() + (this.skillList.getRight() - this.skillList.getLeft()) / 2 - this.getFontRenderer().func_238414_a_((ITextProperties)text) / 2;
        FontRenderer fontRenderer = this.getFontRenderer();
        IReorderingProcessor iReorderingProcessor = text.func_241878_f();
        float f = x;
        int n = this.search.field_230691_m_;
        this.getFontRenderer().getClass();
        fontRenderer.func_238422_b_(mStack, iReorderingProcessor, f, (float)(n - 9), 0xFFFFFF);
        this.search.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(mStack, mouseX, mouseY, partialTicks);
    }

    public Minecraft getMinecraftInstance() {
        return this.field_230706_i_;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public void setSelectedSkill(SkillListWidget.CategoryEntry entry) {
        this.selectedSkill = entry == this.selectedSkill ? null : entry;
        this.selectedVariation = null;
        this.variationList.refreshList();
        this.updateCache();
    }

    public void setSelectedVariation(VariationListWidget.VariationEntry entry) {
        this.selectedVariation = entry == this.selectedVariation ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        if (this.selectedSkill == null) {
            this.skillInfo.clearInfo();
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(new TranslationTextComponent("wardance:skills_general").getString() + "\n");
            lines.add(new TranslationTextComponent("wardance:skills_colors").getString() + "\n");
            lines.add(new TranslationTextComponent("wardance:skills_terms").getString() + "\n");
            this.skillInfo.setInfo(lines, null);
            return;
        }
        SkillCategory selectedSkill = this.selectedSkill.getCategory();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(TextFormatting.BOLD + "" + TextFormatting.UNDERLINE + selectedSkill.name().getString() + TextFormatting.RESET + "\n");
        lines.add(selectedSkill.description().getString());
        if (this.selectedVariation != null) {
            lines.add("\n");
            lines.add(this.selectedVariation.getSkill().description().getString());
            if (this.field_230706_i_ != null && this.field_230706_i_.field_71474_y.field_74330_P) {
                lines.add("\n");
                lines.add(TextFormatting.DARK_GRAY + new TranslationTextComponent("wardance:skill_tag").getString() + this.selectedVariation.getSkill().getTags((LivingEntity)this.field_230706_i_.field_71439_g).func_230236_b_() + "\n");
                lines.add(TextFormatting.DARK_GRAY + new TranslationTextComponent("wardance:skill_soft_incompat").getString() + this.selectedVariation.getSkill().getSoftIncompatibility((LivingEntity)this.field_230706_i_.field_71439_g).func_230236_b_() + "\n");
                lines.add(TextFormatting.DARK_GRAY + new TranslationTextComponent("wardance:skill_hard_incompat").getString() + this.selectedVariation.getSkill().getHardIncompatibility((LivingEntity)this.field_230706_i_.field_71439_g).func_230236_b_() + TextFormatting.RESET);
            }
        }
        lines.add("\n");
        this.skillInfo.setInfo(lines, null);
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        String s = this.search.func_146179_b();
        AdvancedData sort = this.advancedData;
        SkillListWidget.CategoryEntry selected = this.selectedSkill;
        this.func_231158_b_(mc, width, height);
        this.search.func_146180_a(s);
        this.selectedSkill = selected;
        if (!this.search.func_146179_b().isEmpty()) {
            this.reloadMods();
        }
        if (sort != AdvancedData.NORMAL) {
            this.resortMods(sort);
        }
        this.updateCache();
    }

    public void func_231175_as__() {
        ArrayList<Skill> newSkills = new ArrayList<Skill>();
        for (SkillSliceButton skillSliceButton : this.skillPie) {
            newSkills.add(skillSliceButton.getSkill());
        }
        for (SkillSelectionButton skillSelectionButton : this.passives) {
            newSkills.add(skillSelectionButton.getSkill());
        }
        CasterData.getCap((LivingEntity)Minecraft.func_71410_x().field_71439_g).setEquippedSkills(newSkills);
        CombatChannel.INSTANCE.sendToServer((Object)new UpdateSkillSelectionPacket(newSkills));
        this.field_230706_i_.func_147108_a(null);
    }

    class InfoPanel
    extends ScrollPanel {
        private ResourceLocation logoPath;
        private List<IReorderingProcessor> lines;

        InfoPanel(Minecraft mcIn, int widthIn, int heightIn, int topIn) {
            super(mcIn, widthIn, heightIn, topIn, SkillSelectionScreen.this.skillList.getRight() + 6);
            this.lines = Collections.emptyList();
        }

        void setInfo(List<String> lines, ResourceLocation logoPath) {
            this.logoPath = logoPath;
            this.lines = this.resizeContent(lines);
            this.scrollDistance = 0.0f;
        }

        void clearInfo() {
            this.logoPath = null;
            this.lines = Collections.emptyList();
            this.scrollDistance = 0.0f;
        }

        private List<IReorderingProcessor> resizeContent(List<String> lines) {
            ArrayList<IReorderingProcessor> ret = new ArrayList<IReorderingProcessor>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                ITextComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                int maxTextLength = this.width - 12;
                if (maxTextLength < 0) continue;
                ret.addAll(LanguageMap.func_74808_a().func_244260_a(SkillSelectionScreen.this.field_230712_o_.func_238420_b_().func_238362_b_((ITextProperties)chat, maxTextLength, Style.field_240709_b_)));
            }
            return ret;
        }

        public int getContentHeight() {
            int height = 0;
            int n = this.lines.size();
            SkillSelectionScreen.this.field_230712_o_.getClass();
            if ((height += n * 9) < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected int getScrollAmount() {
            SkillSelectionScreen.this.field_230712_o_.getClass();
            return 9 * 3;
        }

        protected void drawPanel(MatrixStack mStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
            if (this.logoPath != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(this.logoPath);
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int headerHeight = 50;
                GuiUtils.drawInscribedRect((MatrixStack)mStack, (int)(this.left + 6), (int)relativeY, (int)(this.width - 12), (int)headerHeight, (int)64, (int)64, (boolean)false, (boolean)true);
                relativeY += headerHeight + 6;
            }
            for (IReorderingProcessor line : this.lines) {
                if (line != null) {
                    RenderSystem.enableBlend();
                    SkillSelectionScreen.this.field_230712_o_.func_238407_a_(mStack, line, (float)(this.left + 6), (float)relativeY, 0xFFFFFF);
                    RenderSystem.disableAlphaTest();
                    RenderSystem.disableBlend();
                }
                SkillSelectionScreen.this.field_230712_o_.getClass();
                relativeY += 9;
            }
            Style component = this.findTextLine(mouseX, mouseY);
            if (component != null) {
                SkillSelectionScreen.this.func_238653_a_(mStack, component, mouseX, mouseY);
            }
        }

        private Style findTextLine(int mouseX, int mouseY) {
            double offset = (float)(mouseY - this.top + 4) + this.scrollDistance + 1.0f;
            if (this.logoPath != null) {
                offset -= 50.0;
            }
            if (offset <= 0.0) {
                return null;
            }
            SkillSelectionScreen.this.field_230712_o_.getClass();
            int lineIdx = (int)(offset / 9.0);
            if (lineIdx >= this.lines.size() || lineIdx < 1) {
                return null;
            }
            IReorderingProcessor line = this.lines.get(lineIdx - 1);
            if (line != null) {
                return SkillSelectionScreen.this.field_230712_o_.func_238420_b_().func_243239_a(line, mouseX);
            }
            return null;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            Style component = this.findTextLine((int)mouseX, (int)mouseY);
            if (component != null) {
                SkillSelectionScreen.this.func_230455_a_(component);
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        protected void drawBackground() {
        }
    }

    private static enum AdvancedData implements Comparator<SkillCategory>
    {
        NORMAL,
        A_TO_Z{

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A{

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        Button button;

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(SkillCategory o1, SkillCategory o2) {
            String name1 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)SkillSelectionScreen.stripControlCodes(o1.name().getString()));
            String name2 = net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)SkillSelectionScreen.stripControlCodes(o2.name().getString()));
            return this.compare(name1, name2);
        }

        ITextComponent getButtonText() {
            return new TranslationTextComponent("fml.menu.mods." + net.minecraftforge.fml.loading.StringUtils.toLowerCase((String)this.name()));
        }
    }
}

