/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.wardance.command;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import jackiecrazy.wardance.skill.Skill;
import jackiecrazy.wardance.skill.WarSkills;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SkillArgument
implements ArgumentType<Skill> {
    public static final SuggestionProvider<CommandSource> SKILLS = SuggestionProviders.func_197494_a((ResourceLocation)new ResourceLocation("wardance", "skills"), (context, builder) -> ISuggestionProvider.func_201725_a(GameRegistry.findRegistry(Skill.class).getValues().stream(), (SuggestionsBuilder)builder, ForgeRegistryEntry::getRegistryName, type -> new TranslationTextComponent(Util.func_200697_a((String)"skill", (ResourceLocation)type.getRegistryName()))));
    private static final Collection<String> EXAMPLES = Stream.of((Skill)WarSkills.RETURN_TO_SENDER.get(), (Skill)WarSkills.VITAL_STRIKE.get()).map(worldKey -> worldKey.getRegistryName().toString()).collect(Collectors.toList());
    private static final DynamicCommandExceptionType INVALID_SKILL_EXCEPTION = new DynamicCommandExceptionType(worldKey -> new TranslationTextComponent("argument.skill.invalid", new Object[]{worldKey}));

    public static SkillArgument skill() {
        return new SkillArgument();
    }

    public Skill parse(StringReader reader) throws CommandSyntaxException {
        int start = reader.getCursor();
        ResourceLocation skill = ResourceLocation.func_195826_a((StringReader)reader);
        Skill result = Skill.getSkill(skill);
        if (result == null) {
            reader.setCursor(start);
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext((ImmutableStringReader)reader);
        }
        return result;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_listSuggestions_1_, SuggestionsBuilder p_listSuggestions_2_) {
        return ISuggestionProvider.func_197014_a((Iterable)GameRegistry.findRegistry(Skill.class).getKeys(), (SuggestionsBuilder)p_listSuggestions_2_);
    }

    public Collection<String> getExamples() {
        return super.getExamples();
    }
}

